/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;

public class DataTypeAnyURI
extends DataTypeBase<URI> {
    private static final DataTypeAnyURI singleInstance = new DataTypeAnyURI();

    private DataTypeAnyURI() {
        super(XACML.ID_DATATYPE_ANYURI, URI.class);
    }

    public static DataTypeAnyURI newInstance() {
        return singleInstance;
    }

    @Override
    public URI convert(Object source) throws DataTypeException {
        if (source == null || source instanceof URI) {
            return (URI)source;
        }
        if (source instanceof Identifier) {
            return ((Identifier)source).getUri();
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        URI uriValue = null;
        try {
            uriValue = new URI(stringValue);
        }
        catch (URISyntaxException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to anyURI", ex);
        }
        return uriValue;
    }

    @Override
    public String toStringValue(URI source) throws DataTypeException {
        return source == null ? null : source.toString();
    }
}

