/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.ISO8601Date;

public class DataTypeDate
extends DataTypeSemanticStringBase<ISO8601Date> {
    private static final DataTypeDate singleInstance = new DataTypeDate();

    private DataTypeDate() {
        super(XACML.ID_DATATYPE_DATE, ISO8601Date.class);
    }

    public static DataTypeDate newInstance() {
        return singleInstance;
    }

    @Override
    public ISO8601Date convert(Object source) throws DataTypeException {
        if (source == null || source instanceof ISO8601Date) {
            return (ISO8601Date)source;
        }
        if (source instanceof Date) {
            return ISO8601Date.fromDate((Date)source);
        }
        if (source instanceof Calendar) {
            return ISO8601Date.fromCalendar((Calendar)source);
        }
        String stringValue = this.convertToString(source);
        ISO8601Date dateValue = null;
        try {
            dateValue = ISO8601Date.fromISO8601DateString(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to Date", ex);
        }
        return dateValue;
    }
}

