/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.math.BigInteger;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;

public class DataTypeInteger
extends DataTypeBase<BigInteger> {
    private static final DataTypeInteger singleInstance = new DataTypeInteger();

    private DataTypeInteger() {
        super(XACML.ID_DATATYPE_INTEGER, BigInteger.class);
    }

    public static DataTypeInteger newInstance() {
        return singleInstance;
    }

    @Override
    public BigInteger convert(Object source) throws DataTypeException {
        if (source == null || source instanceof BigInteger) {
            return (BigInteger)source;
        }
        if (source instanceof Integer) {
            return new BigInteger(source.toString());
        }
        String stringValue = this.convertToString(source);
        BigInteger intValue = null;
        try {
            intValue = new BigInteger(stringValue);
        }
        catch (NumberFormatException ex) {
            throw new DataTypeException(this, "Failed to convert from \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to integer", ex);
        }
        return intValue;
    }
}

