/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML1;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.RFC822Name;

public class DataTypeRFC822Name
extends DataTypeSemanticStringBase<RFC822Name> {
    private static final DataTypeRFC822Name singleInstance = new DataTypeRFC822Name();

    private DataTypeRFC822Name() {
        super(XACML1.ID_DATATYPE_RFC822NAME, RFC822Name.class);
    }

    public static DataTypeRFC822Name newInstance() {
        return singleInstance;
    }

    @Override
    public RFC822Name convert(Object source) throws DataTypeException {
        if (source == null || source instanceof RFC822Name) {
            return (RFC822Name)source;
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        RFC822Name rfc822Name = null;
        try {
            rfc822Name = RFC822Name.newInstance(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to RFC822Name", ex);
        }
        return rfc822Name;
    }
}

