/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import javax.security.auth.x500.X500Principal;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML1;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;

public class DataTypeX500Name
extends DataTypeBase<X500Principal> {
    private static final DataTypeX500Name singleInstance = new DataTypeX500Name();

    private DataTypeX500Name() {
        super(XACML1.ID_DATATYPE_X500NAME, X500Principal.class);
    }

    public static DataTypeX500Name newInstance() {
        return singleInstance;
    }

    @Override
    public X500Principal convert(Object source) throws DataTypeException {
        if (source == null || source instanceof X500Principal) {
            return (X500Principal)source;
        }
        String stringValue = this.convertToString(source);
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(stringValue);
        }
        catch (IllegalArgumentException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to X500Name", ex);
        }
        return x500Principal;
    }
}

