/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.openaz.xacml.std.datatypes.IPAddress;
import org.apache.openaz.xacml.std.datatypes.IPv4Address;
import org.apache.openaz.xacml.std.datatypes.PortRange;

public class IPv6Address
extends IPAddress {
    private static final short[] NULL_ADDRESS = new short[]{0, 0, 0, 0, 0, 0, 0, 0};
    private short[] addressBytes;
    private Short prefix;
    private PortRange portRange;

    public IPv6Address(short[] addressBytesIn, Short prefixIn, PortRange portRangeIn) {
        this.addressBytes = addressBytesIn;
        this.prefix = prefixIn;
        this.portRange = portRangeIn;
        if (addressBytesIn.length != 8) {
            throw new IllegalArgumentException("Invalid byte count for IPv6 address: " + addressBytesIn.length);
        }
    }

    public static boolean isIPv4Address(short[] addressBytes) {
        if (addressBytes == null || addressBytes.length < 8) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (addressBytes[i] == 0) continue;
            return false;
        }
        return addressBytes[5] == -1;
    }

    public static String formatAddress(short[] addressParts) {
        StringBuilder stringBuilder = new StringBuilder();
        if (IPv6Address.isIPv4Address(addressParts)) {
            stringBuilder.append("::FFFF:");
            short[] ipv4Octets = new short[]{(short)(addressParts[6] >> 8 & 0xFF), (short)(addressParts[6] & 0xFF), (short)(addressParts[7] >> 8 & 0xFF), (short)(addressParts[7] & 0xFF)};
            stringBuilder.append(IPv4Address.formatAddress(ipv4Octets));
        } else {
            int zeroPos = -1;
            int zeroLen = 0;
            int i = 0;
            while (i < addressParts.length) {
                if (addressParts[i] == 0) {
                    int zeroCount = 1;
                    int j = i + 1;
                    while (j < addressParts.length && addressParts[j] == 0) {
                        ++j;
                        ++zeroCount;
                    }
                    if (zeroCount > zeroLen) {
                        zeroPos = i;
                        zeroLen = zeroCount;
                    }
                    i += zeroCount;
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < addressParts.length) {
                if (addressParts[i] == 0) {
                    if (i == zeroPos) {
                        if (i == 0) {
                            stringBuilder.append(':');
                        }
                        stringBuilder.append(':');
                        i += zeroLen;
                        continue;
                    }
                    stringBuilder.append('0');
                    if (++i >= addressParts.length) continue;
                    stringBuilder.append(':');
                    continue;
                }
                stringBuilder.append(String.format("%x", addressParts[i]));
                if (++i >= addressParts.length) continue;
                stringBuilder.append(':');
            }
        }
        return stringBuilder.toString();
    }

    protected static short[] getAddress(String ipv6Address) throws ParseException {
        if (ipv6Address.equals("::")) {
            return NULL_ADDRESS;
        }
        String parseString = ipv6Address;
        if (ipv6Address.startsWith("::")) {
            parseString = ipv6Address.substring(1);
        } else if (ipv6Address.endsWith("::")) {
            parseString = ipv6Address.substring(0, ipv6Address.length() - 1);
        }
        String[] addressFields = parseString.split("[:]", -1);
        if (addressFields == null || addressFields.length == 0 || addressFields.length > 8) {
            throw new ParseException("Invalid IPv6Address string \"" + ipv6Address + "\"", 0);
        }
        boolean isIPv4 = false;
        if (addressFields.length == 3 && addressFields[0].length() == 0 && addressFields[1].equalsIgnoreCase("FFFF") && addressFields[2].contains(".")) {
            isIPv4 = true;
        }
        short[] addressShorts = new short[8];
        int nAddressShorts = 0;
        int missingFields = isIPv4 ? 4 : 8 - addressFields.length;
        boolean sawMissingField = false;
        for (int i = 0; i < addressFields.length; ++i) {
            if (addressFields[i].length() == 0) {
                if (sawMissingField) {
                    throw new ParseException("Invalid IPv6Address string \"" + ipv6Address + "\": multiple zero runs", i);
                }
                sawMissingField = true;
                addressShorts[nAddressShorts++] = 0;
                for (int j = 0; j < missingFields; ++j) {
                    addressShorts[nAddressShorts++] = 0;
                }
                continue;
            }
            if (addressFields[i].indexOf(46) >= 0) {
                if (nAddressShorts != 6) {
                    throw new ParseException("Invalid IPv6Address string \"" + ipv6Address + "\": misplaced IPv4 address", i);
                }
                short[] ipv4Octets = null;
                try {
                    ipv4Octets = IPv4Address.getAddress(addressFields[i]);
                }
                catch (ParseException ex) {
                    throw new ParseException("Invalid IPv4Address in Ipv6Address \"" + addressFields[i] + "\"", i);
                }
                if (ipv4Octets == null) {
                    throw new ParseException("Invalid Ipv4Address in IPv6Address \"" + addressFields[i] + "\"", i);
                }
                assert (ipv4Octets.length == 4);
                addressShorts[nAddressShorts++] = (short)(ipv4Octets[0] * 256 + ipv4Octets[1]);
                addressShorts[nAddressShorts++] = (short)(ipv4Octets[2] * 256 + ipv4Octets[3]);
                continue;
            }
            try {
                addressShorts[nAddressShorts++] = (short)Integer.parseInt(addressFields[i], 16);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalid IPv6Address component \"" + addressFields[i] + "\": invalid hex", i);
            }
        }
        if (nAddressShorts < 8) {
            throw new ParseException("Invalid IPv6Address string \"" + ipv6Address + "\": not enough address fields", 0);
        }
        return addressShorts;
    }

    public static IPv6Address newIPv6Instance(String ipv6AddressString) throws ParseException {
        if (ipv6AddressString == null || ipv6AddressString.length() == 0) {
            return null;
        }
        if (!ipv6AddressString.startsWith("[")) {
            throw new ParseException("Invalid IPv6Address string \"" + ipv6AddressString + "\": missing opening bracket", 0);
        }
        int addressStart = 1;
        int addressEnd = ipv6AddressString.indexOf(93, addressStart);
        if (addressEnd < 0) {
            throw new ParseException("Invalid IPv6Address string \"" + ipv6AddressString + "\": missing closing bracket", 0);
        }
        if (addressEnd - addressStart < 2) {
            throw new ParseException("Invalid IPv6Address string \"" + ipv6AddressString + "\": empty address", 0);
        }
        int slashIndex = ipv6AddressString.indexOf("/");
        if (slashIndex > -1 && slashIndex < ipv6AddressString.indexOf("]")) {
            addressEnd = slashIndex;
        }
        short[] addressShorts = IPv6Address.getAddress(ipv6AddressString.substring(addressStart, addressEnd));
        int nextPos = addressEnd;
        Short prefix = null;
        if (nextPos < ipv6AddressString.length() - 1 && ipv6AddressString.charAt(nextPos) == ']' && ipv6AddressString.charAt(nextPos + 1) == '/') {
            ++nextPos;
        }
        if (nextPos < ipv6AddressString.length() && ipv6AddressString.charAt(nextPos) == '/') {
            if (++nextPos >= ipv6AddressString.length() || ipv6AddressString.charAt(nextPos) == ']' || ipv6AddressString.charAt(nextPos) == ':') {
                throw new ParseException("Invalid Ipv6Address string \"" + ipv6AddressString + "\": prefix designation without value", nextPos);
            }
            addressStart = nextPos;
            addressEnd = ipv6AddressString.indexOf(93, addressStart);
            if (addressEnd < 0 && (addressEnd = ipv6AddressString.indexOf(58, addressStart)) < 0) {
                addressEnd = ipv6AddressString.length();
            }
            if ((prefix = Short.valueOf(Short.parseShort(ipv6AddressString.substring(addressStart, addressEnd)))) > 128) {
                throw new ParseException("Invalid Ipv6Address string \"" + ipv6AddressString + "\": prefix is larger than 128", nextPos);
            }
            nextPos = addressEnd;
        }
        if (nextPos < ipv6AddressString.length() && ipv6AddressString.charAt(nextPos) == ']') {
            ++nextPos;
        }
        PortRange portRange = null;
        if (nextPos < ipv6AddressString.length() && ipv6AddressString.charAt(nextPos) == ':') {
            if (ipv6AddressString.substring(nextPos + 1).length() < 1) {
                throw new ParseException("Invalid IPv6 address string \"" + ipv6AddressString + "\": no portrange given after ':'", nextPos + 1);
            }
            portRange = PortRange.newInstance(ipv6AddressString.substring(nextPos + 1));
            nextPos = ipv6AddressString.length();
        }
        if (nextPos < ipv6AddressString.length()) {
            throw new ParseException("Invalid Ipv6Address string \"" + ipv6AddressString + "\": unknown content at end", nextPos);
        }
        return new IPv6Address(addressShorts, prefix, portRange);
    }

    public static boolean isIPv6Address(String ipv4AddressString) {
        if (ipv4AddressString == null || ipv4AddressString.length() == 0) {
            return false;
        }
        return ipv4AddressString.indexOf(58) < ipv4AddressString.lastIndexOf(58) && ipv4AddressString.indexOf(46) == ipv4AddressString.lastIndexOf(46);
    }

    @Override
    public String stringValue() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.addressBytes != null) {
            stringBuilder.append(IPv6Address.formatAddress(this.addressBytes));
        }
        if (this.prefix != null) {
            stringBuilder.append('/');
            stringBuilder.append(this.prefix);
        }
        stringBuilder.append("]");
        if (this.portRange != null) {
            stringBuilder.append(':');
            stringBuilder.append(this.portRange.stringValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IPv6Address)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IPv6Address ipAddress = (IPv6Address)obj;
        short[] bytesThis = this.addressBytes;
        short[] bytesThat = ipAddress.addressBytes;
        if (bytesThis == null ? bytesThat != null : bytesThat == null || !Arrays.equals(bytesThis, bytesThat)) {
            return false;
        }
        Short prefixThis = this.prefix;
        Short prefixThat = ipAddress.prefix;
        if (prefixThis == null ? prefixThat != null : prefixThis == prefixThat) {
            return false;
        }
        return !(this.portRange == null ? ipAddress.portRange != null : ipAddress.portRange == null || !ipAddress.portRange.equals(this.portRange));
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.addressBytes != null) {
            result = 31 * result + Arrays.hashCode(this.addressBytes);
        }
        if (this.prefix != null) {
            result = 31 * result + this.prefix.hashCode();
        }
        if (this.portRange != null) {
            result = 31 * result + this.portRange.hashCode();
        }
        return result;
    }
}

