/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.IDateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;
import org.apache.openaz.xacml.std.datatypes.ISO8601TimeZone;
import org.apache.openaz.xacml.std.datatypes.ParseUtils;

public class ISO8601Time
implements IDateTime<ISO8601Time>,
Comparable<ISO8601Time>,
SemanticString {
    private static final int ARBITRARY_YEAR = 1970;
    private static final int ARBITRARY_MONTH = 11;
    private static final int ARBITRARY_DAY = 15;
    private ISO8601DateTime dateTime;

    protected ISO8601Time(ISO8601DateTime iso8601DateTime) {
        this.dateTime = iso8601DateTime;
    }

    public ISO8601Time(String timeZoneIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this.dateTime = new ISO8601DateTime(timeZoneIn, 1970, 11, 15, hourIn, minuteIn, secondIn, millisecondIn);
    }

    public ISO8601Time(int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this((String)null, hourIn, minuteIn, secondIn, millisecondIn);
    }

    public ISO8601Time(ISO8601TimeZone timeZoneIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this(timeZoneIn == null ? null : timeZoneIn.getTimeZoneString(), hourIn, minuteIn, secondIn, millisecondIn);
    }

    public ISO8601Time(TimeZone timeZoneIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this(timeZoneIn == null ? null : timeZoneIn.getID(), hourIn, minuteIn, secondIn, millisecondIn);
    }

    public boolean getHasTimeZone() {
        return this.dateTime.getHasTimeZone();
    }

    public String getTimeZone() {
        return this.dateTime.getTimeZone();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getMillisecond() {
        return this.dateTime.getMillisecond();
    }

    @Override
    public ISO8601Time add(ISO8601Duration iso8601Duration) {
        return new ISO8601Time(this.dateTime.add(iso8601Duration));
    }

    @Override
    public ISO8601Time sub(ISO8601Duration iso8601Duration) {
        return new ISO8601Time(this.dateTime.sub(iso8601Duration));
    }

    public String stringValue(boolean includeTimeZone) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%02d", this.getHour()));
        stringBuilder.append(':');
        stringBuilder.append(String.format("%02d", this.getMinute()));
        stringBuilder.append(':');
        stringBuilder.append(String.format("%02d", this.getSecond()));
        int ms = this.getMillisecond();
        if (ms > 0) {
            stringBuilder.append('.');
            stringBuilder.append(String.format("%03d", ms));
        }
        if (this.getHasTimeZone() && includeTimeZone) {
            stringBuilder.append(this.getTimeZone());
        }
        return stringBuilder.toString();
    }

    @Override
    public String stringValue() {
        return this.stringValue(true);
    }

    public String toString() {
        return this.stringValue(true);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ISO8601Time)) {
            return false;
        }
        return this.dateTime.equals(((ISO8601Time)obj).dateTime);
    }

    @Override
    public int compareTo(ISO8601Time o) {
        return this.dateTime.compareTo(o.dateTime);
    }

    public static ISO8601Time fromCalendar(Calendar calendar) {
        return new ISO8601Time(calendar.getTimeZone(), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static ISO8601Time fromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return ISO8601Time.fromCalendar(cal);
    }

    public static ISO8601Time fromISO8601TimeString(String timeString) throws ParseException {
        int ss;
        int mm;
        if (timeString == null) {
            throw new NullPointerException("Null time string");
        }
        if (timeString.length() < 8) {
            throw new ParseException("Time string too short", 0);
        }
        int startPos = ParseUtils.nextNonWhite(timeString, 0);
        int hh = ParseUtils.getTwoDigitValue(timeString, startPos);
        if (hh < 0 || hh >= 24) {
            throw new ParseException("Invalid hour of day", startPos);
        }
        if ((startPos += 2) >= timeString.length()) {
            throw new ParseException("Invalid time string", startPos);
        }
        if (timeString.charAt(startPos) != ':') {
            throw new ParseException("Missing hour-minute separator", startPos);
        }
        if ((mm = ParseUtils.getTwoDigitValue(timeString, ++startPos)) < 0 || mm >= 60) {
            throw new ParseException("Invalid minute of hour", startPos);
        }
        if ((startPos += 2) >= timeString.length()) {
            throw new ParseException("Invalid time string", startPos);
        }
        if (timeString.charAt(startPos) != ':') {
            throw new ParseException("Missing minute-second separator", startPos);
        }
        if ((ss = ParseUtils.getTwoDigitValue(timeString, ++startPos)) < 0 || ss >= 60) {
            throw new ParseException("Invalid second of minute", startPos);
        }
        int ms = 0;
        if ((startPos += 2) < timeString.length() && timeString.charAt(startPos) == '.') {
            if ((ms = ParseUtils.getThreeDigitValue(timeString, ++startPos)) < 0 || ms >= 1000) {
                throw new ParseException("Invalid milliseconds", startPos);
            }
            startPos += 3;
        }
        String timezone = null;
        if (startPos < timeString.length()) {
            switch (timeString.charAt(startPos)) {
                case 'Z': {
                    timezone = "GMT";
                    ++startPos;
                    break;
                }
                case '+': 
                case '-': {
                    if (startPos + 5 < timeString.length()) {
                        timezone = "GMT" + timeString.substring(startPos, startPos + 6);
                        break;
                    }
                    throw new ParseException("Invalid timezone", startPos);
                }
                default: {
                    throw new ParseException("Invalid timezone", startPos);
                }
            }
        }
        return new ISO8601Time(timezone, hh, mm, ss, ms);
    }
}

