/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.openaz.xacml.std.datatypes.ExtendedNamespaceContext;

public class StringNamespaceContext
extends ExtendedNamespaceContext {
    private Map<String, Namespace> namespaceMap = new HashMap<String, Namespace>();
    private Namespace defaultNamespace = null;

    public StringNamespaceContext() {
    }

    public StringNamespaceContext(String namespaceURI) throws Exception {
        this.add(namespaceURI);
    }

    public StringNamespaceContext(String prefix, String namespaceURI) throws Exception {
        this.add(prefix, namespaceURI);
    }

    public void add(String namespaceURI) throws Exception {
        if (this.defaultNamespace != null) {
            throw new Exception("Default name already set");
        }
        this.defaultNamespace = new Namespace(namespaceURI);
    }

    public void add(String prefix, String namespace) throws Exception {
        if (prefix == null || prefix.equals("")) {
            this.add(namespace);
            return;
        }
        if (this.namespaceMap.get(prefix) != null) {
            throw new Exception("Namespace prefix '" + prefix + "' already in use (value='" + this.namespaceMap.get(prefix) + "'");
        }
        this.namespaceMap.put(prefix, new Namespace(prefix, namespace));
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("")) {
            if (this.defaultNamespace == null) {
                return "";
            }
            return this.defaultNamespace.getNamespace();
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.namespaceMap.get(prefix) == null) {
            return "";
        }
        return this.namespaceMap.get(prefix).getNamespace();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (this.defaultNamespace != null && namespaceURI.equals(this.defaultNamespace.getNamespace())) {
            return "";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        for (String key : this.namespaceMap.keySet()) {
            Namespace namespace = this.namespaceMap.get(key);
            if (!namespace.getNamespace().equals(namespaceURI)) continue;
            return namespace.getPrefix();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        ArrayList<String> prefixList = new ArrayList<String>();
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            prefixList.add("xmlns");
        } else if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            prefixList.add("xml");
        } else {
            if (this.defaultNamespace != null && this.defaultNamespace.getNamespace().equals(namespaceURI)) {
                prefixList.add("");
            }
            for (String key : this.namespaceMap.keySet()) {
                Namespace ns = this.namespaceMap.get(key);
                if (!ns.getNamespace().equals(namespaceURI)) continue;
                prefixList.add(ns.prefix);
            }
        }
        return prefixList.iterator();
    }

    @Override
    public Iterator<String> getAllPrefixes() {
        if (this.defaultNamespace == null) {
            return this.namespaceMap.keySet().iterator();
        }
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(this.namespaceMap.keySet());
        keyList.add("");
        return keyList.iterator();
    }

    private class Namespace {
        private String prefix;
        private String namespace;

        public Namespace(String namespace) {
            this.prefix = null;
            this.namespace = namespace;
        }

        public Namespace(String prefix, String namespace) {
            this.prefix = prefix;
            this.namespace = namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            return "{" + this.prefix + "," + this.namespace + "}";
        }
    }
}

