/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.MissingAttributeDetail;
import org.apache.openaz.xacml.std.StdMissingAttributeDetail;
import org.apache.openaz.xacml.std.StdMutableMissingAttributeDetail;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMMissingAttributeDetail {
    private static final Log logger = LogFactory.getLog(DOMMissingAttributeDetail.class);

    protected DOMMissingAttributeDetail() {
    }

    public static MissingAttributeDetail newInstance(Node nodeMissingAttributeDetail) throws DOMStructureException {
        int numChildren;
        Element elementMissingAttributeDetail = DOMUtil.getElement(nodeMissingAttributeDetail);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableMissingAttributeDetail mutableMissingAttributeDetail = new StdMutableMissingAttributeDetail();
        mutableMissingAttributeDetail.setCategory(DOMUtil.getIdentifierAttribute((Node)elementMissingAttributeDetail, "Category", !bLenient));
        mutableMissingAttributeDetail.setAttributeId(DOMUtil.getIdentifierAttribute((Node)elementMissingAttributeDetail, "AttributeId", !bLenient));
        mutableMissingAttributeDetail.setDataTypeId(DOMUtil.getIdentifierAttribute((Node)elementMissingAttributeDetail, "DataType", !bLenient));
        mutableMissingAttributeDetail.setIssuer(DOMUtil.getStringAttribute(elementMissingAttributeDetail, "Issuer"));
        NodeList children = elementMissingAttributeDetail.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeValue".equals(child.getLocalName())) {
                        mutableMissingAttributeDetail.addAttributeValue(DOMAttributeValue.newInstance(child, mutableMissingAttributeDetail.getCategory()));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeMissingAttributeDetail);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeMissingAttributeDetail);
            }
        }
        return new StdMissingAttributeDetail(mutableMissingAttributeDetail);
    }

    public static boolean repair(Node nodeMissingAttributeDetail) throws DOMStructureException {
        Element elementMissingAttributeDetail = DOMUtil.getElement(nodeMissingAttributeDetail);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementMissingAttributeDetail, "Category", logger) || result;
        result = DOMUtil.repairIdentifierAttribute(elementMissingAttributeDetail, "AttributeId", logger) || result;
        result = DOMUtil.repairIdentifierAttribute(elementMissingAttributeDetail, "DataType", logger) || result;
        return result;
    }
}

