/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.std.StdRequestAttributes;
import org.apache.openaz.xacml.std.dom.DOMAttribute;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRequestAttributes {
    private static final Log logger = LogFactory.getLog(DOMRequestAttributes.class);

    protected DOMRequestAttributes() {
    }

    public static RequestAttributes newInstance(Node nodeRequestAttributes) throws DOMStructureException {
        int numChildren;
        Element elementRequestAttributes = DOMUtil.getElement(nodeRequestAttributes);
        boolean bLenient = DOMProperties.isLenient();
        Identifier identifierCategory = DOMUtil.getIdentifierAttribute((Node)elementRequestAttributes, "Category", !bLenient);
        String xmlId = DOMUtil.getXmlId(elementRequestAttributes);
        Node nodeContentRoot = null;
        ArrayList<Attribute> listAttributes = new ArrayList<Attribute>();
        boolean sawContent = false;
        NodeList children = elementRequestAttributes.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Content".equals(childName)) {
                        int numGrandchildren;
                        if (sawContent && !bLenient) {
                            throw DOMUtil.newUnexpectedElementException(child, elementRequestAttributes);
                        }
                        sawContent = true;
                        NodeList grandchildren = child.getChildNodes();
                        if (grandchildren != null && (numGrandchildren = grandchildren.getLength()) > 0) {
                            for (int j = 0; j < numGrandchildren; ++j) {
                                Node grandchild = grandchildren.item(j);
                                if (!DOMUtil.isElement(grandchild)) continue;
                                if (nodeContentRoot != null) {
                                    if (bLenient) continue;
                                    throw DOMUtil.newUnexpectedElementException(grandchild, child);
                                }
                                nodeContentRoot = DOMUtil.getDirectDocumentChild(grandchild);
                            }
                        }
                        if (nodeContentRoot != null || bLenient) continue;
                        throw DOMUtil.newMissingContentException(child);
                    }
                    if ("Attribute".equals(childName)) {
                        listAttributes.add(DOMAttribute.newInstance(identifierCategory, child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeRequestAttributes);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeRequestAttributes);
            }
        }
        return new StdRequestAttributes(identifierCategory, listAttributes, nodeContentRoot, xmlId);
    }

    public static boolean repair(Node nodeRequestAttributes) throws DOMStructureException {
        int numChildren;
        Element elementRequestAttributes = DOMUtil.getElement(nodeRequestAttributes);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementRequestAttributes, "Category", logger) || result;
        NodeList children = elementRequestAttributes.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Attribute".equals(childName)) {
                        result = DOMAttribute.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementRequestAttributes.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRequestAttributes.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

