/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.std.StdMutableStatus;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStatusCode;
import org.apache.openaz.xacml.std.dom.DOMStatusDetail;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMStatus {
    private static final Log logger = LogFactory.getLog(DOMStatus.class);

    protected DOMStatus() {
    }

    public static Status newInstance(Node nodeStatus) throws DOMStructureException {
        int numChildren;
        Element elementStatus = DOMUtil.getElement(nodeStatus);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableStatus mutableStatus = new StdMutableStatus();
        NodeList children = elementStatus.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("StatusCode".equals(childName)) {
                        mutableStatus.setStatusCode(DOMStatusCode.newInstance(child));
                        continue;
                    }
                    if ("StatusMessage".equals(childName)) {
                        mutableStatus.setStatusMessage(child.getTextContent());
                        continue;
                    }
                    if ("StatusDetail".equals(childName)) {
                        mutableStatus.setStatusDetail(DOMStatusDetail.newInstance(child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeStatus);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeStatus);
            }
        }
        if (mutableStatus.getStatusCode() == null && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeStatus, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "StatusCode");
        }
        return new StdStatus(mutableStatus);
    }

    public static boolean repair(Node nodeStatus) throws DOMStructureException {
        int numChildren;
        Element elementStatus = DOMUtil.getElement(nodeStatus);
        boolean result = false;
        NodeList children = elementStatus.getChildNodes();
        boolean sawStatusCode = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("StatusCode".equals(childName)) {
                        result = DOMStatusCode.repair(child) || result;
                        sawStatusCode = true;
                        continue;
                    }
                    if ("StatusDetail".equals(childName)) {
                        result = DOMStatusDetail.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementStatus.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementStatus.removeChild(child);
                result = true;
            }
        }
        if (!sawStatusCode) {
            throw DOMUtil.newMissingElementException(nodeStatus, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "StatusCode");
        }
        return result;
    }
}

