/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.util.List;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeAssignmentType;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdMutableAttributeAssignment;
import org.apache.openaz.xacml.util.FactoryException;

public class JaxpAttributeAssignment
extends StdMutableAttributeAssignment {
    protected JaxpAttributeAssignment(Identifier attributeIdIn, Identifier categoryIdIn, String issuerIn, AttributeValue<?> attributeValueIn) {
        super(attributeIdIn, categoryIdIn, issuerIn, attributeValueIn);
    }

    public static JaxpAttributeAssignment newInstance(AttributeAssignmentType attributeAssignmentType) {
        if (attributeAssignmentType == null) {
            throw new NullPointerException("Null AttributeAssignmentType");
        }
        if (attributeAssignmentType.getAttributeId() == null) {
            throw new IllegalArgumentException("Null attributeId in AttributeAssignmentType");
        }
        if (attributeAssignmentType.getCategory() == null) {
            throw new IllegalArgumentException("Null categoryId in AttributeAssignmentType");
        }
        if (attributeAssignmentType.getDataType() == null) {
            throw new IllegalArgumentException("Null dataTypeId in AttributeAssignmentType");
        }
        if (attributeAssignmentType.getContent() == null || attributeAssignmentType.getContent().get(0) == null) {
            throw new IllegalArgumentException("Null value in AttributeAssignmentType");
        }
        IdentifierImpl attributeId = new IdentifierImpl(attributeAssignmentType.getAttributeId());
        IdentifierImpl categoryId = new IdentifierImpl(attributeAssignmentType.getCategory());
        IdentifierImpl dataTypeId = new IdentifierImpl(attributeAssignmentType.getDataType());
        DataTypeFactory dataTypeFactory = null;
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
            if (dataTypeFactory == null) {
                return null;
            }
        }
        catch (FactoryException ex) {
            return null;
        }
        DataType<?> dataType = dataTypeFactory.getDataType(dataTypeId);
        if (dataType == null) {
            throw new IllegalArgumentException("Unknown data type \"" + ((Object)dataTypeId).toString() + "\"");
        }
        List<Object> content = attributeAssignmentType.getContent();
        String issuer = attributeAssignmentType.getIssuer();
        AttributeValue<?> attributeValue = null;
        try {
            attributeValue = dataType.createAttributeValue(content);
        }
        catch (DataTypeException ex) {
            throw new IllegalArgumentException("Failed to create AttributeValue from \"" + ((Object)dataTypeId).toString() + "\"", ex);
        }
        return new JaxpAttributeAssignment(attributeId, categoryId, issuer, attributeValue);
    }
}

