/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributesType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.RequestReferenceType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.RequestType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.std.jaxp.JaxpRequestAttributes;
import org.apache.openaz.xacml.std.jaxp.JaxpRequestDefaults;
import org.apache.openaz.xacml.std.jaxp.JaxpRequestReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JaxpRequest
extends StdMutableRequest {
    private static Log logger = LogFactory.getLog(JaxpRequest.class);

    public static JaxpRequest newInstance(RequestType requestType) {
        if (requestType == null) {
            throw new NullPointerException("Null RequestType");
        }
        JaxpRequest jaxpRequest = new JaxpRequest();
        jaxpRequest.setCombinedDecision(requestType.isCombinedDecision());
        jaxpRequest.setReturnPolicyIdList(requestType.isReturnPolicyIdList());
        if (requestType.getAttributes() != null) {
            Iterator<AttributesType> iterAttributesTypes = requestType.getAttributes().iterator();
            while (iterAttributesTypes.hasNext()) {
                jaxpRequest.add(JaxpRequestAttributes.newInstance(iterAttributesTypes.next()));
            }
        }
        if (requestType.getMultiRequests() != null && requestType.getMultiRequests().getRequestReference() != null) {
            Iterator<RequestReferenceType> iterRequestReferenceTypes = requestType.getMultiRequests().getRequestReference().iterator();
            while (iterRequestReferenceTypes.hasNext()) {
                jaxpRequest.add(JaxpRequestReference.newInstance(iterRequestReferenceTypes.next()));
            }
        }
        if (requestType.getRequestDefaults() != null) {
            jaxpRequest.setRequestDefaults(JaxpRequestDefaults.newInstance(requestType.getRequestDefaults()));
        }
        return jaxpRequest;
    }

    public static JaxpRequest load(File fileXmlRequest) throws ParserConfigurationException, IOException, SAXException, JAXBException, DOMStructureException {
        if (fileXmlRequest == null) {
            throw new NullPointerException("Null File");
        }
        Document document = DOMUtil.loadDocument(fileXmlRequest);
        if (document == null) {
            logger.error((Object)("No Document returned parsing \"" + fileXmlRequest.getAbsolutePath() + "\""));
            return null;
        }
        NodeList nodeListRoot = document.getChildNodes();
        if (nodeListRoot == null || nodeListRoot.getLength() == 0) {
            logger.warn((Object)"No child elements of the XML document");
            return null;
        }
        Node nodeRoot = nodeListRoot.item(0);
        if (nodeRoot == null || nodeRoot.getNodeType() != 1) {
            logger.warn((Object)"Root of the document is not an ELEMENT");
            return null;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RequestType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement jaxbElementRequest = unmarshaller.unmarshal(nodeRoot, RequestType.class);
        if (jaxbElementRequest == null || jaxbElementRequest.getValue() == null) {
            logger.error((Object)"JAXB unmarshalling did not return a RequestType node");
            return null;
        }
        return JaxpRequest.newInstance((RequestType)jaxbElementRequest.getValue());
    }

    public static void main(String[] args) {
        for (String fileName : args) {
            JaxpRequest jaxpRequest = null;
            try {
                jaxpRequest = JaxpRequest.load(new File(fileName));
            }
            catch (Exception ex) {
                logger.fatal((Object)("Failed to load \"" + fileName + "\" as a JaxpRequest"), (Throwable)ex);
                continue;
            }
            if (jaxpRequest == null) {
                logger.warn((Object)("Null JaxpRequest returned for file \"" + fileName + "\""));
                continue;
            }
            logger.info((Object)("JaxpRequest for file \"" + fileName + "\"=" + jaxpRequest.toString()));
        }
    }
}

