/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ResponseType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ResultType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.std.StdMutableResponse;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.std.jaxp.JaxpResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JaxpResponse
extends StdMutableResponse {
    private static Log logger = LogFactory.getLog(JaxpResponse.class);

    protected JaxpResponse() {
    }

    public static JaxpResponse newInstance(ResponseType responseType) {
        if (responseType == null) {
            throw new NullPointerException("Null ResponseType");
        }
        if (responseType.getResult() == null || responseType.getResult().size() == 0) {
            throw new IllegalArgumentException("No ResultTypes in ResponseType");
        }
        JaxpResponse jaxpResponse = new JaxpResponse();
        Iterator<ResultType> iterResults = responseType.getResult().iterator();
        while (iterResults.hasNext()) {
            jaxpResponse.add(JaxpResult.newInstance(iterResults.next()));
        }
        return jaxpResponse;
    }

    public static JaxpResponse load(File fileXmlResponse) throws ParserConfigurationException, IOException, SAXException, JAXBException, DOMStructureException {
        if (fileXmlResponse == null) {
            throw new NullPointerException("Null File");
        }
        Document document = DOMUtil.loadDocument(fileXmlResponse);
        if (document == null) {
            logger.error((Object)("No Document returned parsing \"" + fileXmlResponse.getAbsolutePath() + "\""));
            return null;
        }
        NodeList nodeListRoot = document.getChildNodes();
        if (nodeListRoot == null || nodeListRoot.getLength() == 0) {
            logger.warn((Object)"No child elements of the XML document");
            return null;
        }
        Node nodeRoot = nodeListRoot.item(0);
        if (nodeRoot == null || nodeRoot.getNodeType() != 1) {
            logger.warn((Object)"Root of the document is not an ELEMENT");
            return null;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement jaxbElementResponse = unmarshaller.unmarshal(nodeRoot, ResponseType.class);
        if (jaxbElementResponse == null || jaxbElementResponse.getValue() == null) {
            logger.error((Object)"JAXB unmarshalling did not return a ResponseType node");
            return null;
        }
        return JaxpResponse.newInstance((ResponseType)jaxbElementResponse.getValue());
    }

    public static void main(String[] args) {
        for (String fileName : args) {
            JaxpResponse jaxpResponse = null;
            try {
                jaxpResponse = JaxpResponse.load(new File(fileName));
            }
            catch (Exception ex) {
                logger.fatal((Object)("Failed to load \"" + fileName + "\" as a JaxpResponse"), (Throwable)ex);
                continue;
            }
            if (jaxpResponse == null) {
                logger.warn((Object)("Null JaxpResponse returned for file \"" + fileName + "\""));
                continue;
            }
            logger.info((Object)("JaxpResponse for file \"" + fileName + "\"=" + jaxpResponse.toString()));
        }
    }
}

