/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PDP;
import org.apache.openaz.xacml.api.pap.PDPPIPConfig;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.api.pap.PDPStatus;
import org.apache.openaz.xacml.std.pap.StdPDPItemSetChangeNotifier;
import org.apache.openaz.xacml.std.pap.StdPDPStatus;

public class StdPDP
extends StdPDPItemSetChangeNotifier
implements PDP,
Comparable<StdPDP>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StdPDP.class);
    private String id;
    private String name;
    private String description;
    private PDPStatus status = new StdPDPStatus();
    private Set<PDPPolicy> policies = new HashSet<PDPPolicy>();
    private Set<PDPPIPConfig> pipConfigs = new HashSet<PDPPIPConfig>();

    public StdPDP() {
    }

    public StdPDP(String id) {
        this(id, null, null);
    }

    public StdPDP(String id, String name) {
        this(id, name, null);
    }

    public StdPDP(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public StdPDP(String id, Properties properties) {
        this(id);
        this.initialize(properties);
    }

    public void initialize(Properties properties) {
        for (Object key : properties.keySet()) {
            if (!key.toString().startsWith(this.id + ".")) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found: " + key));
            }
            if (key.toString().endsWith(".name")) {
                this.name = properties.getProperty(key.toString());
                continue;
            }
            if (!key.toString().endsWith(".description")) continue;
            this.description = properties.getProperty(key.toString());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.firePDPChanged(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.firePDPChanged(this);
    }

    @Override
    public PDPStatus getStatus() {
        return this.status;
    }

    public void setStatus(PDPStatus status) {
        this.status = status;
    }

    @Override
    public Set<PDPPolicy> getPolicies() {
        return Collections.unmodifiableSet(this.policies);
    }

    public void setPolicies(Set<PDPPolicy> policies) {
        this.policies = policies;
    }

    @Override
    public Set<PDPPIPConfig> getPipConfigs() {
        return Collections.unmodifiableSet(this.pipConfigs);
    }

    public void setPipConfigs(Set<PDPPIPConfig> pipConfigs) {
        this.pipConfigs = pipConfigs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StdPDP other = (StdPDP)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "StdPDP [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", status=" + this.status + ", policies=" + this.policies + ", pipConfigs=" + this.pipConfigs + "]";
    }

    @Override
    public int compareTo(StdPDP o) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof StdPDP)) {
            return -1;
        }
        if (o.name == null) {
            return -1;
        }
        if (this.name == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }
}

