/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PAPException;
import org.apache.openaz.xacml.api.pap.PDP;
import org.apache.openaz.xacml.api.pap.PDPGroup;
import org.apache.openaz.xacml.api.pap.PDPGroupStatus;
import org.apache.openaz.xacml.api.pap.PDPPIPConfig;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.std.pap.StdPDP;
import org.apache.openaz.xacml.std.pap.StdPDPGroupStatus;
import org.apache.openaz.xacml.std.pap.StdPDPItemSetChangeNotifier;
import org.apache.openaz.xacml.std.pap.StdPDPPIPConfig;
import org.apache.openaz.xacml.std.pap.StdPDPPolicy;

public class StdPDPGroup
extends StdPDPItemSetChangeNotifier
implements PDPGroup,
StdPDPItemSetChangeNotifier.StdItemSetChangeListener,
Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StdPDPGroup.class);
    private String id;
    private boolean isDefault = false;
    private String name;
    private String description;
    private StdPDPGroupStatus status = new StdPDPGroupStatus(PDPGroupStatus.Status.UNKNOWN);
    private Set<PDP> pdps = new HashSet<PDP>();
    private Set<PDPPolicy> policies = new HashSet<PDPPolicy>();
    private Set<PDPPIPConfig> pipConfigs = new HashSet<PDPPIPConfig>();
    @JsonIgnore
    private Path directory;

    public StdPDPGroup(String id, Path directory) {
        this.id = id;
        this.directory = directory;
    }

    public StdPDPGroup(String id, boolean isDefault, Path directory) {
        this(id, directory);
        this.isDefault = isDefault;
    }

    public StdPDPGroup(String id, boolean isDefault, String name, String description, Path directory) {
        this(id, isDefault, directory);
        this.name = name;
        if (name == null) {
            this.name = id;
        }
        this.description = description;
    }

    public StdPDPGroup(String id, String name, String description, Path directory) {
        this(id, false, name, description, directory);
        this.resetStatus();
    }

    public StdPDPGroup(String id, boolean isDefault, Properties properties, Path directory) throws PAPException {
        this(id, isDefault, directory);
        this.initialize(properties, directory);
        this.resetStatus();
    }

    private void initialize(Properties properties, Path directory) throws PAPException {
        if (this.id == null || this.id.length() == 0) {
            logger.warn((Object)"Cannot initialize with a null or zero length id");
            return;
        }
        for (Object key : properties.keySet()) {
            if (key.toString().startsWith(this.id + ".")) {
                String pdpList;
                if (key.toString().endsWith(".name")) {
                    this.name = properties.getProperty(key.toString());
                } else if (key.toString().endsWith(".description")) {
                    this.description = properties.getProperty(key.toString());
                } else if (key.toString().endsWith(".pdps") && (pdpList = properties.getProperty(key.toString())) != null && pdpList.length() > 0) {
                    for (String id : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)pdpList)) {
                        StdPDP pdp = new StdPDP(id, properties);
                        pdp.addItemSetChangeListener(this);
                        this.pdps.add(pdp);
                    }
                }
            }
            if (this.name != null) continue;
            this.name = this.id;
        }
        if (Files.notExists(directory, new LinkOption[0])) {
            logger.warn((Object)("Group directory does NOT exist: " + directory.toString()));
            try {
                Files.createDirectory(directory, new FileAttribute[0]);
                this.status.addLoadWarning("Group directory does NOT exist");
            }
            catch (IOException e) {
                logger.error((Object)e);
                this.status.addLoadError("Group directory does NOT exist");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
            }
        }
        this.loadPolicies(Paths.get(directory.toString(), "xacml.policy.properties"));
        this.loadPIPConfig(Paths.get(directory.toString(), "xacml.pip.properties"));
    }

    public void loadPolicies(Path file) throws PAPException {
        block29: {
            Properties policyProperties = new Properties();
            if (!file.toFile().exists()) {
                policyProperties.setProperty("xacml.rootPolicies", "");
                policyProperties.setProperty("xacml.referencedPolicies", "");
                try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                    policyProperties.store(os, "");
                    break block29;
                }
                catch (Exception e) {
                    throw new PAPException("Failed to create new default policy properties file '" + file + "'");
                }
            }
            try {
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    policyProperties.load(is);
                }
                this.readPolicyProperties(this.directory, policyProperties);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load group policy properties file: " + file), (Throwable)e);
                this.status.addLoadError("Not policy properties defined");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
                throw new PAPException("Failed to load group policy properties file: " + file);
            }
        }
    }

    public void loadPIPConfig(Path file) throws PAPException {
        block29: {
            Properties pipProperties = new Properties();
            if (!file.toFile().exists()) {
                pipProperties.setProperty("xacml.pip.engines", "");
                try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                    pipProperties.store(os, "");
                    break block29;
                }
                catch (Exception e) {
                    throw new PAPException("Failed to create new default pip properties file '" + file + "'");
                }
            }
            try {
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    pipProperties.load(is);
                }
                this.readPIPProperties(pipProperties);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to open group PIP Config properties file: " + file), (Throwable)e);
                this.status.addLoadError("Not PIP config properties defined");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
                throw new PAPException("Failed to load group policy properties file: " + file);
            }
        }
    }

    public void resetStatus() {
        this.status.reset();
        block7: for (PDP pdp : this.pdps) {
            switch (pdp.getStatus().getStatus()) {
                case OUT_OF_SYNCH: {
                    this.status.addOutOfSynchPDP(pdp);
                    continue block7;
                }
                case LAST_UPDATE_FAILED: {
                    this.status.addLastUpdateFailedPDP(pdp);
                    continue block7;
                }
                case LOAD_ERRORS: {
                    this.status.addFailedPDP(pdp);
                    continue block7;
                }
                case UPDATING_CONFIGURATION: {
                    this.status.addUpdatingPDP(pdp);
                    continue block7;
                }
                case UP_TO_DATE: {
                    this.status.addInSynchPDP(pdp);
                    continue block7;
                }
            }
            this.status.addUnknownPDP(pdp);
        }
        if (this.status.getUnknownPDPs().size() > 0) {
            this.status.setStatus(PDPGroupStatus.Status.UNKNOWN);
        } else if (this.status.getFailedPDPs().size() > 0 || this.status.getLastUpdateFailedPDPs().size() > 0) {
            this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
        } else if (this.status.getOutOfSynchPDPs().size() > 0) {
            this.status.setStatus(PDPGroupStatus.Status.OUT_OF_SYNCH);
        } else if (this.status.getUpdatingPDPs().size() > 0) {
            this.status.setStatus(PDPGroupStatus.Status.UPDATING_CONFIGURATION);
        } else {
            this.status.setStatus(PDPGroupStatus.Status.OK);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isDefaultGroup() {
        return this.isDefault;
    }

    public void setDefaultGroup(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String groupName) {
        this.name = groupName;
        this.firePDPGroupChanged(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String groupDescription) {
        this.description = groupDescription;
        this.firePDPGroupChanged(this);
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void setDirectory(Path groupDirectory) {
        this.directory = groupDirectory;
    }

    @Override
    public PDPGroupStatus getStatus() {
        return this.status;
    }

    @Override
    public Set<PDP> getPdps() {
        return Collections.unmodifiableSet(this.pdps);
    }

    public void setPdps(Set<PDP> pdps) {
        this.pdps = pdps;
    }

    public boolean addPDP(PDP pdp) {
        return this.pdps.add(pdp);
    }

    public boolean removePDP(PDP pdp) {
        return this.pdps.remove(pdp);
    }

    @Override
    public Set<PDPPolicy> getPolicies() {
        return Collections.unmodifiableSet(this.policies);
    }

    @Override
    public PDPPolicy getPolicy(String id) {
        for (PDPPolicy policy : this.policies) {
            if (!policy.getId().equals(id)) continue;
            return policy;
        }
        return null;
    }

    @Override
    public Properties getPolicyProperties() {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        ArrayList<String> roots = new ArrayList<String>();
        ArrayList<String> refs = new ArrayList<String>();
        for (PDPPolicy policy : this.policies) {
            if (policy.getName() != null) {
                properties.setProperty(policy.getId() + ".name", policy.getName());
            }
            if (policy.isRoot()) {
                roots.add(policy.getId());
                continue;
            }
            refs.add(policy.getId());
        }
        properties.setProperty("xacml.rootPolicies", Joiner.on((char)',').join(roots));
        properties.setProperty("xacml.referencedPolicies", Joiner.on((char)',').join(refs));
        return properties;
    }

    public PDPPolicy publishPolicy(String id, String name, boolean isRoot, InputStream policy) throws PAPException {
        if (this.getPolicy(id) != null) {
            throw new PAPException("Policy with id " + id + " already exists - unpublish it first.");
        }
        Path tempFile = null;
        try {
            long num;
            tempFile = Files.createFile(Paths.get(this.directory.toAbsolutePath().toString(), id), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                num = ByteStreams.copy((InputStream)policy, (OutputStream)os);
            }
            logger.info((Object)("Copied " + num + " bytes for policy " + name));
            StdPDPPolicy tempRootPolicy = new StdPDPPolicy(id, isRoot, name, tempFile.toUri());
            if (!tempRootPolicy.isValid()) {
                try {
                    Files.delete(tempFile);
                }
                catch (Exception ee) {
                    logger.error((Object)"Policy was invalid, could NOT delete it.", (Throwable)ee);
                }
                throw new PAPException("Policy is invalid");
            }
            this.policies.add(tempRootPolicy);
            this.firePDPGroupChanged(this);
            return tempRootPolicy;
        }
        catch (IOException e) {
            logger.error((Object)"Failed to publishPolicy: ", (Throwable)e);
            return null;
        }
    }

    public void copyPolicyToFile(String id, InputStream policy) throws PAPException {
        try {
            long num;
            Path policyFilePath = Paths.get(this.directory.toAbsolutePath().toString(), id);
            Path policyFile = Files.exists(policyFilePath, new LinkOption[0]) ? policyFilePath : Files.createFile(policyFilePath, new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(policyFile, new OpenOption[0]);){
                num = ByteStreams.copy((InputStream)policy, (OutputStream)os);
            }
            logger.info((Object)("Copied " + num + " bytes for policy " + this.name));
            for (PDPPolicy p : this.policies) {
                if (!p.getId().equals(id)) continue;
                logger.info((Object)("Policy '" + id + "' already exists in group '" + this.getId() + "'"));
                return;
            }
            StdPDPPolicy tempRootPolicy = new StdPDPPolicy(id, true, this.name, policyFile.toUri());
            if (!tempRootPolicy.isValid()) {
                try {
                    Files.delete(policyFile);
                }
                catch (Exception ee) {
                    logger.error((Object)"Policy was invalid, could NOT delete it.", (Throwable)ee);
                }
                throw new PAPException("Policy is invalid");
            }
            this.policies.add(tempRootPolicy);
            this.firePDPGroupChanged(this);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to copyPolicyToFile: ", (Throwable)e);
            throw new PAPException("Failed to copy policy to file: " + e);
        }
    }

    public boolean removePolicy(PDPPolicy policy) {
        StdPDPPolicy currentPolicy = (StdPDPPolicy)this.getPolicy(policy.getId());
        if (currentPolicy == null) {
            logger.error((Object)("Policy " + policy.getId() + " does not exist."));
            return false;
        }
        try {
            Files.delete(Paths.get(currentPolicy.getLocation()));
            this.policies.remove(currentPolicy);
            this.firePDPGroupChanged(this);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to delete policy " + policy));
            return false;
        }
    }

    @Override
    public Set<PDPPIPConfig> getPipConfigs() {
        return Collections.unmodifiableSet(this.pipConfigs);
    }

    @Override
    public PDPPIPConfig getPipConfig(String id) {
        for (PDPPIPConfig config : this.pipConfigs) {
            if (!config.getId().equals(id)) continue;
            return config;
        }
        return null;
    }

    public void setPipConfigs(Set<PDPPIPConfig> pipConfigs) {
        this.pipConfigs = pipConfigs;
        this.firePDPGroupChanged(this);
    }

    public void removeAllPIPConfigs() {
        this.pipConfigs.clear();
        this.firePDPGroupChanged(this);
    }

    @Override
    public Properties getPipConfigProperties() {
        Properties properties = new Properties();
        ArrayList<String> configs = new ArrayList<String>();
        for (PDPPIPConfig config : this.pipConfigs) {
            configs.add(config.getId());
            properties.putAll(config.getConfiguration());
        }
        properties.setProperty("xacml.pip.engines", Joiner.on((char)',').join(configs));
        return properties;
    }

    @Override
    public void repair() {
        Path policyPropertiesFile;
        Path pipPropertiesFile;
        this.status.reset();
        boolean fire = false;
        if (Files.notExists(this.directory, new LinkOption[0])) {
            logger.warn((Object)("Group directory does NOT exist: " + this.directory.toString()));
            try {
                Files.createDirectory(this.directory, new FileAttribute[0]);
                fire = true;
                this.status.addLoadWarning("Created missing group directory");
            }
            catch (IOException e) {
                logger.error((Object)e);
                this.status.addLoadError("Failed to create missing Group directory.");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
            }
        }
        if (Files.notExists(pipPropertiesFile = Paths.get(this.directory.toString(), "xacml.pip.properties"), new LinkOption[0])) {
            try {
                Files.createFile(pipPropertiesFile, new FileAttribute[0]);
                fire = true;
                this.status.addLoadWarning("Created missing PIP properties file");
            }
            catch (IOException e) {
                logger.error((Object)e);
                this.status.addLoadError("Failed to create missing PIP properties file");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
            }
        }
        if (Files.notExists(policyPropertiesFile = Paths.get(this.directory.toString(), "xacml.policy.properties"), new LinkOption[0])) {
            try {
                Files.createFile(policyPropertiesFile, new FileAttribute[0]);
                fire = true;
                this.status.addLoadWarning("Created missing Policy properties file");
            }
            catch (IOException e) {
                logger.error((Object)e);
                this.status.addLoadError("Failed to create missing Policy properties file");
                this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
            }
        }
        this.resetStatus();
        if (fire) {
            this.fireChanged();
        }
    }

    private void readPolicyProperties(Path directory, Properties properties) {
        String[] lists = new String[]{properties.getProperty("xacml.rootPolicies"), properties.getProperty("xacml.referencedPolicies")};
        boolean isRoot = true;
        for (String list : lists) {
            if (list == null || list.length() == 0) {
                isRoot = false;
                continue;
            }
            Iterable policyList = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)list);
            if (policyList == null) {
                isRoot = false;
                continue;
            }
            for (String id : policyList) {
                StdPDPPolicy policy;
                Path policyPath = Paths.get(directory.toString(), id);
                try {
                    policy = new StdPDPPolicy(id, isRoot, policyPath.toUri(), properties);
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to create policy object", (Throwable)e);
                    policy = null;
                }
                if (policy != null && policy.isValid()) {
                    this.policies.add(policy);
                    this.status.addLoadedPolicy(policy);
                } else {
                    this.status.addFailedPolicy(policy);
                    this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
                }
                if (policy.getName() != null) continue;
                policy.setName(policy.getId());
            }
            isRoot = false;
        }
    }

    private void readPIPProperties(Properties properties) {
        String list = properties.getProperty("xacml.pip.engines");
        if (list == null || list.length() == 0) {
            return;
        }
        for (String id : list.split("[,]")) {
            StdPDPPIPConfig config = new StdPDPPIPConfig(id, properties);
            if (config.isConfigured()) {
                this.pipConfigs.add(config);
                this.status.addLoadedPipConfig(config);
                continue;
            }
            this.status.addFailedPipConfig(config);
            this.status.setStatus(PDPGroupStatus.Status.LOAD_ERRORS);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StdPDPGroup other = (StdPDPGroup)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "StdPDPGroup [id=" + this.id + ", isDefault=" + this.isDefault + ", name=" + this.name + ", description=" + this.description + ", status=" + this.status + ", pdps=" + this.pdps + ", policies=" + this.policies + ", pipConfigs=" + this.pipConfigs + ", directory=" + this.directory + "]";
    }

    @Override
    public void changed() {
        try {
            this.saveGroupConfiguration();
        }
        catch (IOException | PAPException e) {
            logger.error((Object)"Unable to save group configuration change");
            return;
        }
        this.firePDPGroupChanged(this);
    }

    @Override
    public void groupChanged(PDPGroup group) {
        this.changed();
    }

    @Override
    public void pdpChanged(PDP pdp) {
        this.changed();
    }

    public StdPDPGroup() {
    }

    public StdPDPGroup(PDPGroup group) {
        this.id = group.getId();
        this.name = group.getName();
        this.description = group.getDescription();
        this.isDefault = group.isDefaultGroup();
        this.pdps = group.getPdps();
        this.policies = group.getPolicies();
        this.pipConfigs = group.getPipConfigs();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setStatus(PDPGroupStatus status) {
        this.status = new StdPDPGroupStatus(status);
    }

    public void setPolicies(Set<PDPPolicy> policies) {
        this.policies = policies;
    }

    public void saveGroupConfiguration() throws PAPException, IOException {
        Properties policyProperties = this.getPolicyProperties();
        for (PDPPolicy policy : this.policies) {
            policyProperties.put(policy.getId() + ".name", policy.getName());
        }
        Path file = Paths.get(this.directory.toString(), "xacml.policy.properties");
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            policyProperties.store(os, "");
        }
        catch (Exception e) {
            logger.error((Object)("Group Policies Config save failed: " + e), (Throwable)e);
            throw new PAPException("Failed to save policy properties file '" + file + "'");
        }
        Properties pipProperties = this.getPipConfigProperties();
        file = Paths.get(this.directory.toString(), "xacml.pip.properties");
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            pipProperties.store(os, "");
        }
        catch (Exception e) {
            logger.error((Object)("Group PIP Config save failed: " + e), (Throwable)e);
            throw new PAPException("Failed to save pip properties file '" + file + "'");
        }
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 == null) {
            return -1;
        }
        if (!(arg0 instanceof StdPDPGroup)) {
            return -1;
        }
        if (((StdPDPGroup)arg0).name == null) {
            return -1;
        }
        if (this.name == null) {
            return 1;
        }
        return this.name.compareTo(((StdPDPGroup)arg0).name);
    }
}

