/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySetType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicyType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PAPException;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.util.XACMLPolicyScanner;

public class StdPDPPolicy
implements PDPPolicy,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StdPDPPolicy.class);
    private String id = null;
    private String name = null;
    private String policyId = null;
    private String description = null;
    private int[] version = null;
    private boolean isRoot = false;
    private boolean isValid = false;
    private URI location = null;

    public StdPDPPolicy(String id, boolean isRoot) {
        this.id = id;
        this.isRoot = isRoot;
    }

    public StdPDPPolicy(String id, boolean isRoot, String name) {
        this(id, isRoot);
        this.name = name;
    }

    public StdPDPPolicy(String id, boolean isRoot, String name, URI location) throws IOException {
        this(id, isRoot);
        this.name = name;
        this.location = location;
        String theID = this.readPolicyData();
        if (this.id == null) {
            this.id = theID;
        }
    }

    public StdPDPPolicy(String id, boolean isRoot, URI location, Properties properties) throws IOException {
        this(id, isRoot);
        this.location = location;
        this.readPolicyData();
        for (Object key : properties.keySet()) {
            if (!key.toString().equals(id + ".name")) continue;
            this.name = properties.getProperty(key.toString());
            break;
        }
    }

    private String readPolicyData() throws IOException {
        ArrayList foo;
        URL url = this.location.toURL();
        Object rootElement = XACMLPolicyScanner.readPolicy(url.openStream());
        if (rootElement == null || !(rootElement instanceof PolicySetType) && !(rootElement instanceof PolicyType)) {
            logger.warn((Object)("No root policy element in URI: " + this.location.toString() + " : " + rootElement));
            this.isValid = false;
        } else {
            this.version = StdPDPPolicy.versionStringToArray(XACMLPolicyScanner.getVersion(rootElement));
            if (rootElement instanceof PolicySetType) {
                this.policyId = ((PolicySetType)rootElement).getPolicySetId();
                this.description = ((PolicySetType)rootElement).getDescription();
                this.isValid = true;
                this.version = StdPDPPolicy.versionStringToArray(((PolicySetType)rootElement).getVersion());
            } else if (rootElement instanceof PolicyType) {
                this.policyId = ((PolicyType)rootElement).getPolicyId();
                this.description = ((PolicyType)rootElement).getDescription();
                this.version = StdPDPPolicy.versionStringToArray(((PolicyType)rootElement).getVersion());
                this.isValid = true;
            } else {
                logger.error((Object)("Unknown root element: " + rootElement.getClass().getCanonicalName()));
            }
        }
        if (this.policyId != null && !(foo = Lists.newArrayList((Iterable)Splitter.on((char)':').split((CharSequence)this.policyId))).isEmpty()) {
            return (String)foo.get(foo.size() - 1);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPolicyId() {
        return this.policyId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return StdPDPPolicy.versionArrayToString(this.version);
    }

    @Override
    @JsonIgnore
    public int[] getVersionInts() {
        return this.version;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @JsonIgnore
    public InputStream getStream() throws PAPException, IOException {
        try {
            if (this.location != null) {
                URL url = this.location.toURL();
                return url.openStream();
            }
            return null;
        }
        catch (FileNotFoundException e) {
            throw new PAPException(e);
        }
    }

    @Override
    public URI getLocation() throws PAPException {
        return this.location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.policyId == null ? 0 : this.policyId.hashCode());
        result = 31 * result;
        if (this.version != null) {
            for (int i = 0; i < this.version.length; ++i) {
                result += this.version[i];
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StdPDPPolicy other = (StdPDPPolicy)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.policyId == null ? other.policyId != null : !this.policyId.equals(other.policyId)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "StdPDPPolicy [id=" + this.id + ", name=" + this.name + ", policyId=" + this.policyId + ", description=" + this.description + ", version=" + this.getVersion() + ", isRoot=" + this.isRoot + ", isValid=" + this.isValid + ", location=" + this.location + "]";
    }

    public static int[] versionStringToArray(String version) throws NumberFormatException {
        if (version == null || version.length() == 0) {
            return new int[0];
        }
        String[] stringArray = version.split("\\.");
        int[] resultArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            resultArray[i] = Integer.parseInt(stringArray[i]);
        }
        return resultArray;
    }

    public static String versionArrayToString(int[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        String versionString = "";
        if (array.length > 0) {
            versionString = "" + array[0];
            for (int i = 1; i < array.length; ++i) {
                versionString = versionString + "." + array[i];
            }
        }
        return versionString;
    }

    public StdPDPPolicy() {
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = StdPDPPolicy.versionStringToArray(version);
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setLocation(URI location) {
        this.location = location;
    }
}

