/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.openaz.xacml.api.pap.PDPPIPConfig;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.api.pap.PDPStatus;

public class StdPDPStatus
implements Serializable,
PDPStatus {
    private static final long serialVersionUID = 1L;
    private PDPStatus.Status status = PDPStatus.Status.UNKNOWN;
    private Set<String> loadErrors = new HashSet<String>();
    private Set<String> loadWarnings = new HashSet<String>();
    private Set<PDPPolicy> loadedPolicies = new HashSet<PDPPolicy>();
    private Set<PDPPolicy> loadedRootPolicies = new HashSet<PDPPolicy>();
    private Set<PDPPolicy> failedPolicies = new HashSet<PDPPolicy>();
    private Set<PDPPIPConfig> loadedPIPConfigs = new HashSet<PDPPIPConfig>();
    private Set<PDPPIPConfig> failedPIPConfigs = new HashSet<PDPPIPConfig>();

    public void set(StdPDPStatus newStatus) {
        this.status = newStatus.status;
        this.loadErrors.clear();
        this.loadErrors.addAll(newStatus.getLoadErrors());
        this.loadWarnings.clear();
        this.loadWarnings.addAll(newStatus.getLoadWarnings());
        this.loadedPolicies.clear();
        this.loadedPolicies.addAll(newStatus.getLoadedPolicies());
        this.loadedRootPolicies.clear();
        this.loadedRootPolicies.addAll(newStatus.getLoadedRootPolicies());
        this.failedPolicies.clear();
        this.failedPolicies.addAll(newStatus.getFailedPolicies());
        this.loadedPIPConfigs.clear();
        this.loadedPIPConfigs.addAll(newStatus.getLoadedPipConfigs());
        this.failedPIPConfigs.clear();
        this.failedPIPConfigs.addAll(newStatus.getFailedPipConfigs());
    }

    @Override
    public PDPStatus.Status getStatus() {
        return this.status;
    }

    public void setStatus(PDPStatus.Status status) {
        this.status = status;
    }

    @Override
    public Set<String> getLoadErrors() {
        return Collections.unmodifiableSet(this.loadErrors);
    }

    public void setLoadErrors(Set<String> errors) {
        this.loadErrors = errors;
    }

    public void addLoadError(String error) {
        this.loadErrors.add(error);
    }

    @Override
    public Set<String> getLoadWarnings() {
        return Collections.unmodifiableSet(this.loadWarnings);
    }

    public void setLoadWarnings(Set<String> warnings) {
        this.loadWarnings = warnings;
    }

    public void addLoadWarning(String warning) {
        this.loadWarnings.add(warning);
    }

    @Override
    public Set<PDPPolicy> getLoadedPolicies() {
        return Collections.unmodifiableSet(this.loadedPolicies);
    }

    public void setLoadedPolicies(Set<PDPPolicy> policies) {
        this.loadedPolicies = policies;
    }

    public void addLoadedPolicy(PDPPolicy policy) {
        this.loadedPolicies.add(policy);
    }

    @Override
    public Set<PDPPolicy> getLoadedRootPolicies() {
        return Collections.unmodifiableSet(this.loadedRootPolicies);
    }

    public void setLoadedRootPolicies(Set<PDPPolicy> policies) {
        this.loadedRootPolicies = policies;
    }

    public void addRootPolicy(PDPPolicy policy) {
        this.loadedRootPolicies.add(policy);
    }

    public void addAllLoadedRootPolicies(Set<PDPPolicy> policies) {
        this.loadedRootPolicies.addAll(policies);
    }

    @Override
    public Set<PDPPolicy> getFailedPolicies() {
        return Collections.unmodifiableSet(this.failedPolicies);
    }

    public void setFailedPolicies(Set<PDPPolicy> policies) {
        this.failedPolicies = policies;
    }

    public void addFailedPolicy(PDPPolicy policy) {
        this.failedPolicies.add(policy);
    }

    @Override
    public boolean policiesOK() {
        return this.failedPolicies.size() <= 0;
    }

    @Override
    public Set<PDPPIPConfig> getLoadedPipConfigs() {
        return Collections.unmodifiableSet(this.loadedPIPConfigs);
    }

    public void setLoadedPipConfigs(Set<PDPPIPConfig> configs) {
        this.loadedPIPConfigs = configs;
    }

    public void addLoadedPipConfig(PDPPIPConfig config) {
        this.loadedPIPConfigs.add(config);
    }

    @Override
    public Set<PDPPIPConfig> getFailedPipConfigs() {
        return Collections.unmodifiableSet(this.failedPIPConfigs);
    }

    public void setFailedPipConfigs(Set<PDPPIPConfig> configs) {
        this.failedPIPConfigs = configs;
    }

    public void addFailedPipConfig(PDPPIPConfig config) {
        this.failedPIPConfigs.add(config);
    }

    @Override
    public boolean pipConfigOK() {
        return this.failedPIPConfigs.size() <= 0;
    }

    @Override
    @JsonIgnore
    public boolean isOk() {
        if (!this.policiesOK()) {
            return false;
        }
        if (!this.pipConfigOK()) {
            return false;
        }
        return this.status == PDPStatus.Status.UP_TO_DATE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.failedPIPConfigs.hashCode();
        result = 31 * result + this.failedPolicies.hashCode();
        result = 31 * result + this.loadErrors.hashCode();
        result = 31 * result + this.loadWarnings.hashCode();
        result = 31 * result + this.loadedPIPConfigs.hashCode();
        result = 31 * result + this.loadedPolicies.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StdPDPStatus other = (StdPDPStatus)obj;
        if (!this.failedPIPConfigs.equals(other.failedPIPConfigs)) {
            return false;
        }
        if (!this.failedPolicies.equals(other.failedPolicies)) {
            return false;
        }
        if (!this.loadErrors.equals(other.loadErrors)) {
            return false;
        }
        if (!this.loadWarnings.equals(other.loadWarnings)) {
            return false;
        }
        if (!this.loadedPIPConfigs.equals(other.loadedPIPConfigs)) {
            return false;
        }
        if (!this.loadedPolicies.equals(other.loadedPolicies)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return "StdPDPStatus [status=" + (Object)((Object)this.status) + ", loadErrors=" + this.loadErrors + ", loadWarnings=" + this.loadWarnings + ", loadedPolicies=" + this.loadedPolicies + ", loadedRootPolicies=" + this.loadedRootPolicies + ", failedPolicies=" + this.failedPolicies + ", loadedPIPConfigs=" + this.loadedPIPConfigs + ", failedPIPConfigs=" + this.failedPIPConfigs + "]";
    }
}

