/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pep;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPEngineFactory;
import org.apache.openaz.xacml.api.pdp.PDPException;
import org.apache.openaz.xacml.api.pep.PEPEngine;
import org.apache.openaz.xacml.api.pep.PEPException;
import org.apache.openaz.xacml.util.FactoryException;

public class StdEngine
implements PEPEngine {
    private Log logger = LogFactory.getLog(this.getClass());
    protected Properties properties = null;

    public StdEngine() {
    }

    public StdEngine(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Response decide(Request pepRequest) throws PEPException {
        PDPEngineFactory pdpEngineFactory = null;
        try {
            pdpEngineFactory = PDPEngineFactory.newInstance();
        }
        catch (FactoryException ex) {
            this.logger.error((Object)"FactoryException creating the PDPEngineFactory", (Throwable)ex);
            throw new PEPException("FactoryException creating the PDPEngineFactory", ex);
        }
        assert (pdpEngineFactory != null);
        PDPEngine pdpEngine = null;
        try {
            pdpEngine = pdpEngineFactory.newEngine();
        }
        catch (FactoryException ex) {
            this.logger.error((Object)"PDPException creating the PDPEngine", (Throwable)ex);
            throw new PEPException("PDPException creating the PDPEngine", ex);
        }
        assert (pdpEngine != null);
        Response response = null;
        try {
            response = pdpEngine.decide(pepRequest);
        }
        catch (PDPException ex) {
            this.logger.error((Object)"PDPException deciding on Request", (Throwable)ex);
            throw new PEPException("PDPException deciding on Request", ex);
        }
        return response;
    }
}

