/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip;

import java.util.Collection;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdPIPRequest
implements PIPRequest {
    private Identifier category;
    private Identifier attributeId;
    private Identifier dataTypeId;
    private String issuer;

    private static Identifier getDataType(Attribute attribute) {
        Collection<AttributeValue<?>> values = attribute.getValues();
        if (values != null && values.size() > 0) {
            return values.iterator().next().getDataTypeId();
        }
        return null;
    }

    public StdPIPRequest(Identifier identifierCategory, Identifier identifierAttribute, Identifier identifierDataType) {
        this.category = identifierCategory;
        this.attributeId = identifierAttribute;
        this.dataTypeId = identifierDataType;
    }

    public StdPIPRequest(Identifier identifierCategory, Identifier identifierAttribute, Identifier identifierDataType, String issuerIn) {
        this(identifierCategory, identifierAttribute, identifierDataType);
        this.issuer = issuerIn;
    }

    public StdPIPRequest(Attribute attribute, Identifier identifierDataType) {
        this(attribute.getCategory(), attribute.getAttributeId(), identifierDataType, attribute.getIssuer());
    }

    public StdPIPRequest(Attribute attribute) {
        this(attribute, StdPIPRequest.getDataType(attribute));
    }

    public StdPIPRequest(PIPRequest req) {
        this(req.getCategory(), req.getAttributeId(), req.getDataTypeId(), req.getIssuer());
    }

    @Override
    public Identifier getCategory() {
        return this.category;
    }

    @Override
    public Identifier getAttributeId() {
        return this.attributeId;
    }

    @Override
    public Identifier getDataTypeId() {
        return this.dataTypeId;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    public int hashCode() {
        String thisIssuer;
        int hc = 1;
        Identifier identifier = this.getCategory();
        if (identifier != null) {
            hc += identifier.hashCode();
        }
        if ((identifier = this.getAttributeId()) != null) {
            hc += identifier.hashCode();
        }
        if ((identifier = this.getDataTypeId()) != null) {
            hc += identifier.hashCode();
        }
        if ((thisIssuer = this.getIssuer()) != null) {
            hc += thisIssuer.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PIPRequest)) {
            return false;
        }
        PIPRequest pipRequest = (PIPRequest)obj;
        return ObjUtil.equalsAllowNull(this.getCategory(), pipRequest.getCategory()) && ObjUtil.equalsAllowNull(this.getAttributeId(), pipRequest.getAttributeId()) && ObjUtil.equalsAllowNull(this.getDataTypeId(), pipRequest.getDataTypeId()) && ObjUtil.equalsAllowNull(this.getIssuer(), pipRequest.getIssuer());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getCategory();
        if (objectToDump != null) {
            stringBuilder.append("category=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getAttributeId()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getDataTypeId()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("dataTypeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getIssuer()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("issuer=");
            stringBuilder.append((String)objectToDump);
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

