/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.util.Wrapper;

public class StdPIPResponse
extends Wrapper<PIPResponse>
implements PIPResponse {
    public static final PIPResponse PIP_RESPONSE_EMPTY = new StdPIPResponse(StdStatus.STATUS_OK);

    public StdPIPResponse(PIPResponse wrappedObjectIn) {
        super(wrappedObjectIn);
    }

    public StdPIPResponse(Status status) {
        this(new StdMutablePIPResponse(status));
    }

    public StdPIPResponse(Attribute attribute) {
        this(new StdMutablePIPResponse(attribute));
    }

    public StdPIPResponse(Collection<Attribute> attributes) {
        this(new StdMutablePIPResponse(attributes));
    }

    @Override
    public Status getStatus() {
        return ((PIPResponse)this.getWrappedObject()).getStatus();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return ((PIPResponse)this.getWrappedObject()).getAttributes();
    }

    public static boolean matches(PIPRequest pipRequest, Attribute attribute) {
        if (!pipRequest.getCategory().equals(attribute.getCategory())) {
            return false;
        }
        if (!pipRequest.getAttributeId().equals(attribute.getAttributeId())) {
            return false;
        }
        return pipRequest.getIssuer() == null || pipRequest.getIssuer().equals(attribute.getIssuer());
    }

    public static Collection<AttributeValue<?>> matchingValues(PIPRequest pipRequest, Collection<AttributeValue<?>> listAttributeValues) {
        if (listAttributeValues.size() == 0) {
            return listAttributeValues;
        }
        boolean allMatch = true;
        Iterator<AttributeValue<?>> iterAttributeValues = listAttributeValues.iterator();
        while (allMatch && iterAttributeValues.hasNext()) {
            AttributeValue<?> attributeValue = iterAttributeValues.next();
            allMatch = attributeValue.getDataTypeId().equals(pipRequest.getDataTypeId());
        }
        if (allMatch) {
            return listAttributeValues;
        }
        if (listAttributeValues.size() == 1) {
            return null;
        }
        ArrayList listAttributeValuesMatching = new ArrayList();
        for (AttributeValue<?> attributeValue : listAttributeValues) {
            if (!attributeValue.getDataTypeId().equals(pipRequest.getDataTypeId())) continue;
            listAttributeValuesMatching.add(attributeValue);
        }
        if (listAttributeValuesMatching.size() == 0) {
            return null;
        }
        return listAttributeValuesMatching;
    }

    public static PIPResponse getMatchingResponse(PIPRequest pipRequest, PIPResponse pipResponse) throws PIPException {
        if (!pipResponse.getStatus().isOk() || pipResponse.getAttributes().size() == 0) {
            return pipResponse;
        }
        if (pipResponse.isSimple()) {
            Attribute attributeResponse = pipResponse.getAttributes().iterator().next();
            if (StdPIPResponse.matches(pipRequest, attributeResponse)) {
                Collection<AttributeValue<?>> attributeValues = attributeResponse.getValues();
                if (attributeValues == null || attributeValues.size() == 0) {
                    return pipResponse;
                }
                AttributeValue<?> attributeValueResponse = attributeResponse.getValues().iterator().next();
                if (attributeValueResponse.getDataTypeId().equals(pipRequest.getDataTypeId())) {
                    return pipResponse;
                }
                return PIP_RESPONSE_EMPTY;
            }
            return PIP_RESPONSE_EMPTY;
        }
        StdMutableAttribute attributeMatch = null;
        for (Attribute attributeResponse : pipResponse.getAttributes()) {
            Collection<AttributeValue<?>> listAttributeValuesMatch;
            if (!StdPIPResponse.matches(pipRequest, attributeResponse) || (listAttributeValuesMatch = StdPIPResponse.matchingValues(pipRequest, attributeResponse.getValues())) == null || listAttributeValuesMatch.size() <= 0) continue;
            if (attributeMatch == null) {
                attributeMatch = new StdMutableAttribute(pipRequest.getCategory(), pipRequest.getAttributeId(), listAttributeValuesMatch, pipRequest.getIssuer(), false);
                continue;
            }
            attributeMatch.addValues(listAttributeValuesMatch);
        }
        if (attributeMatch == null) {
            return PIP_RESPONSE_EMPTY;
        }
        return new StdPIPResponse(attributeMatch);
    }

    private static List<Attribute> simplifyAttribute(Attribute attribute) {
        ArrayList<Attribute> listAttributes = new ArrayList<Attribute>();
        if (attribute.getValues() == null || attribute.getValues().size() <= 1) {
            listAttributes.add(attribute);
        } else {
            for (AttributeValue<?> attributeValue : attribute.getValues()) {
                listAttributes.add(new StdAttribute(attribute.getCategory(), attribute.getAttributeId(), attributeValue, attribute.getIssuer(), attribute.getIncludeInResults()));
            }
        }
        return listAttributes;
    }

    private static Collection<? extends Attribute> collapseAttributes(List<Attribute> listAttributes) {
        if (listAttributes.size() <= 0) {
            return listAttributes;
        }
        HashMap<StdPIPRequest, StdMutableAttribute> map = new HashMap<StdPIPRequest, StdMutableAttribute>();
        for (Attribute attribute : listAttributes) {
            StdPIPRequest pipRequest = new StdPIPRequest(attribute);
            if (map.containsKey(pipRequest)) {
                StdMutableAttribute mutableAttribute = (StdMutableAttribute)map.get(pipRequest);
                mutableAttribute.addValues(attribute.getValues());
                continue;
            }
            map.put(pipRequest, new StdMutableAttribute(attribute));
        }
        if (map.size() == 0) {
            return null;
        }
        return map.values();
    }

    public static Map<PIPRequest, PIPResponse> splitResponse(PIPResponse pipResponse) throws PIPException {
        HashMap<PIPRequest, PIPResponse> map = new HashMap<PIPRequest, PIPResponse>();
        if (!pipResponse.getStatus().isOk() || pipResponse.isSimple()) {
            map.put(new StdPIPRequest(pipResponse.getAttributes().iterator().next()), pipResponse);
        } else {
            ArrayList<Attribute> listAllAttributesSimple = new ArrayList<Attribute>();
            for (Attribute attribute : pipResponse.getAttributes()) {
                List<Attribute> list = StdPIPResponse.simplifyAttribute(attribute);
                if (list == null || list.size() <= 0) continue;
                listAllAttributesSimple.addAll(list);
            }
            if (listAllAttributesSimple.size() > 0) {
                Collection<? extends Attribute> listAttributesCollapsed = StdPIPResponse.collapseAttributes(listAllAttributesSimple);
                for (Attribute attribute : listAttributesCollapsed) {
                    map.put(new StdPIPRequest(attribute), new StdPIPResponse(attribute));
                }
            }
        }
        return map;
    }

    @Override
    public boolean isSimple() {
        return ((PIPResponse)this.getWrappedObject()).isSimple();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        if (this.getStatus() != null) {
            stringBuilder.append(this.getStatus().toString());
            needsComma = true;
        }
        if (!this.getAttributes().isEmpty()) {
            if (needsComma) {
                stringBuilder.append(",");
            }
            needsComma = false;
        }
        stringBuilder.append("[");
        for (Attribute attribute : this.getAttributes()) {
            if (needsComma) {
                stringBuilder.append(",");
            }
            stringBuilder.append(attribute.toString());
            needsComma = true;
        }
        stringBuilder.append("]");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

