/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Properties;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.pip.engines.ConfigurableEngine;

public abstract class StdConfigurableEngine
implements ConfigurableEngine {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_ISSUER = "issuer";
    public static final String PROP_CACHESPEC = "cacheSpec";
    private String name;
    private String description;
    private String issuer;
    private Cache<String, PIPResponse> cache;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionIn) {
        this.description = descriptionIn;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuerIn) {
        this.issuer = issuerIn;
    }

    public Cache<String, PIPResponse> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, PIPResponse> cache) {
        this.cache = cache;
    }

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        this.setName(properties.getProperty(id + "." + PROP_NAME, id));
        this.setDescription(properties.getProperty(id + "." + PROP_DESCRIPTION));
        this.setIssuer(properties.getProperty(id + "." + PROP_ISSUER));
        if (properties.getProperty(id + "." + PROP_CACHESPEC) != null) {
            this.cache = CacheBuilder.from((String)properties.getProperty(id + "." + PROP_CACHESPEC)).build();
        }
    }
}

