/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.csv;

import java.nio.file.FileSystems;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.std.pip.engines.jdbc.JDBCEngine;

public class HyperCSVEngine
extends JDBCEngine {
    public static final String PROP_SOURCE = "source";
    public static final String PROP_TARGET = "target";
    public static final String PROP_DEFINITION = "definition";
    public static final String HYPER_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String HYPER_URL = "jdbc:hsqldb:mem:xacml";
    public static final String HYPER_USER = "sa";
    public static final String HYPER_PASS = "";
    private String source;
    private String target;
    private String definition;
    private HyperInitState hyperInitState = HyperInitState.init;

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        System.getProperties().setProperty("textdb.allow_full_path", "true");
        String prop = null;
        prop = id + "." + "jdbc.driver";
        properties.setProperty(prop, HYPER_DRIVER);
        prop = id + "." + "jdbc.url";
        properties.setProperty(prop, HYPER_URL);
        prop = id + "." + "jdbc.conn.user";
        properties.setProperty(prop, HYPER_USER);
        prop = id + "." + "jdbc.conn.password";
        properties.setProperty(prop, HYPER_PASS);
        super.configure(id, properties);
        prop = id + "." + PROP_DEFINITION;
        this.definition = properties.getProperty(prop);
        if (this.definition == null) {
            this.logger.error((Object)("Missing '" + prop + "' property"));
            throw new PIPException("Missing '" + prop + "' property");
        }
        prop = id + "." + PROP_SOURCE;
        this.source = properties.getProperty(prop);
        if (this.source == null) {
            this.logger.error((Object)("Missing '" + prop + "' property"));
            throw new PIPException("Missing '" + prop + "' property");
        }
        prop = id + "." + PROP_TARGET;
        this.target = properties.getProperty(prop);
        if (this.target == null) {
            this.target = FileSystems.getDefault().getPath(this.source, new String[0]).getFileName().toString();
            this.target = this.target.substring(0, this.target.indexOf(46));
            this.logger.info((Object)("Target set to '" + this.target + "'"));
        }
        try {
            this.getConnection().close();
        }
        catch (SQLException sqlx) {
            throw new PIPException("The HyperSQL initialization failed");
        }
    }

    @Override
    protected Connection getConnection() throws PIPException {
        switch (this.hyperInitState) {
            case init: {
                try {
                    this.hyperInit();
                    this.hyperInitState = HyperInitState.completed;
                }
                catch (PIPException pipx) {
                    this.hyperInitState = HyperInitState.failed;
                    throw pipx;
                }
            }
            case completed: {
                return super.getConnection();
            }
            case failed: {
                throw new PIPException("The HyperSQL initialization failed");
            }
        }
        throw new PIPException("?? How did we get here");
    }

    public void hyperReset() {
        this.hyperInitState = HyperInitState.init;
    }

    private void hyperInit() throws PIPException {
        this.logger.info((Object)("Starting csv load from '" + this.source + "' in '" + this.target + "'"));
        StringBuilder createTable = new StringBuilder();
        createTable.append("CREATE TEXT TABLE IF NOT EXISTS ").append(this.target).append("(").append(this.definition).append(")");
        StringBuilder linkTable = new StringBuilder();
        linkTable.append("SET TABLE ").append(this.target).append(" SOURCE ").append("\"").append(this.source).append(";ignore_first=true;all_quoted=true\"");
        Connection conn = super.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(createTable.toString());
            stmt.execute(linkTable.toString());
        }
        catch (SQLException sqlx) {
            throw new PIPException("Failed to inititialize HyperSQL", sqlx);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.logger.info((Object)("Loading '" + this.target + "' from '" + this.source + "' completed"));
    }

    private static enum HyperInitState {
        init,
        completed,
        failed;

    }
}

