/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.jdbc;

import com.google.common.base.Splitter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.StdConfigurableEngine;
import org.apache.openaz.xacml.std.pip.engines.jdbc.JDBCResolver;
import org.apache.openaz.xacml.util.AttributeUtils;

public class JDBCEngine
extends StdConfigurableEngine {
    public static final String PROP_TYPE = "type";
    public static final String PROP_JDBC_DRIVER = "jdbc.driver";
    public static final String PROP_JDBC_URL = "jdbc.url";
    public static final String PROP_JDBC_CONN = "jdbc.conn";
    public static final String PROP_JDBC_CONN_USER = "jdbc.conn.user";
    public static final String PROP_JDBC_CONN_PASS = "jdbc.conn.password";
    public static final String PROP_RESOLVERS = "resolvers";
    public static final String PROP_RESOLVER = "resolver";
    public static final String PROP_CLASSNAME = "classname";
    public static final String TYPE_JDBC = "jdbc";
    public static final String TYPE_JNDI = "jndi";
    protected Log logger = LogFactory.getLog(this.getClass());
    private String type;
    private String jndiDataSource;
    private String jdbcDriverClass;
    private boolean jdbcDriverClassLoaded;
    private String jdbcUrl;
    private Properties jdbcConnProperties = new Properties();
    private List<JDBCResolver> jdbcResolvers = new ArrayList<JDBCResolver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDriverClass() throws ClassNotFoundException {
        if (!this.jdbcDriverClassLoaded) {
            JDBCEngine jDBCEngine = this;
            synchronized (jDBCEngine) {
                if (!this.jdbcDriverClassLoaded) {
                    Class.forName(this.jdbcDriverClass);
                    this.jdbcDriverClassLoaded = true;
                }
            }
        }
    }

    protected Connection getConnection() throws PIPException {
        if (this.type.equals(TYPE_JDBC)) {
            return this.getJDBCConnection();
        }
        return this.getJNDIConnection();
    }

    protected Connection getJDBCConnection() throws PIPException {
        try {
            this.loadDriverClass();
        }
        catch (ClassNotFoundException ex) {
            this.logger.error((Object)("ClassNotFoundException loading JDBC driver class '" + this.jdbcDriverClass + "'"), (Throwable)ex);
            throw new PIPException("ClassNotFoundException loading JDBC driver class '" + this.jdbcDriverClass + "'", ex);
        }
        Connection connectionResult = null;
        try {
            connectionResult = DriverManager.getConnection(this.jdbcUrl, this.jdbcConnProperties);
        }
        catch (SQLException ex) {
            this.logger.error((Object)"SQLException creating Connection", (Throwable)ex);
            throw new PIPException("SQLException creating Connection", ex);
        }
        return connectionResult;
    }

    protected Connection getJNDIConnection() throws PIPException {
        try {
            InitialContext initialContext = new InitialContext();
            DataSource datasource = (DataSource)initialContext.lookup(this.jndiDataSource);
            if (datasource == null) {
                throw new PIPException("");
            }
            return datasource.getConnection();
        }
        catch (SQLException | NamingException e) {
            this.logger.error((Object)"JNDIException creating Connection", (Throwable)e);
            throw new PIPException("JNDIException creating Connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAttributes(PIPRequest pipRequest, PIPFinder pipFinder, JDBCResolver jdbcResolver, StdMutablePIPResponse pipResponse) throws PIPException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = jdbcResolver.getPreparedStatement(this, pipRequest, pipFinder, connection);
        if (preparedStatement == null) {
            this.logger.debug((Object)(this.getName() + " does not handle " + pipRequest.toString()));
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.logger.debug((Object)preparedStatement.toString());
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException ex) {
            this.logger.error((Object)("SQLException executing query: " + ex.toString()), (Throwable)ex);
        }
        if (resultSet == null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)("SQLException closing preparedStatment: " + e.toString()), (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        try {
            while (resultSet.next()) {
                List<Attribute> listAttributes = jdbcResolver.decodeResult(resultSet);
                if (listAttributes == null) continue;
                pipResponse.addAttributes(listAttributes);
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)("SQLException decoding results: " + ex.toString()));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)("SQLException closing resultSet: " + e.toString() + "  (May be memory leak)"));
                }
            }
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)("SQLException closing preparedStatement: " + e.toString() + "  (May be memory leak)"));
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)("SQLException closing connection: " + e.toString() + "  (May be memory leak)"));
            }
        }
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (this.jdbcResolvers.size() == 0) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + " is not configured");
        }
        StdMutablePIPResponse mutablePIPResponse = new StdMutablePIPResponse();
        for (JDBCResolver jdbcResolver : this.jdbcResolvers) {
            this.getAttributes(pipRequest, pipFinder, jdbcResolver, mutablePIPResponse);
        }
        if (mutablePIPResponse.getAttributes().size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"returning empty response");
            }
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("Returning " + mutablePIPResponse.getAttributes().size() + " attributes"));
            for (Attribute attribute : mutablePIPResponse.getAttributes()) {
                this.logger.debug((Object)AttributeUtils.prettyPrint(attribute));
            }
        }
        return new StdPIPResponse(mutablePIPResponse);
    }

    protected void createResolver(String resolverId, Properties properties) throws PIPException {
        String propPrefix = resolverId + ".";
        String resolverClassName = properties.getProperty(propPrefix + PROP_CLASSNAME);
        if (resolverClassName == null || resolverClassName.length() == 0) {
            this.logger.error((Object)("No '" + propPrefix + PROP_CLASSNAME + "' property."));
            throw new PIPException("No '" + propPrefix + PROP_CLASSNAME + "' property.");
        }
        try {
            Class<?> resolverClass = Class.forName(resolverClassName);
            if (!JDBCResolver.class.isAssignableFrom(resolverClass)) {
                this.logger.error((Object)("JDBCResolver class " + propPrefix + " does not implement " + JDBCResolver.class.getCanonicalName()));
                throw new PIPException("JDBCResolver class " + propPrefix + " does not implement " + JDBCResolver.class.getCanonicalName());
            }
            JDBCResolver jdbcResolver = (JDBCResolver)JDBCResolver.class.cast(resolverClass.newInstance());
            jdbcResolver.configure(resolverId, properties, this.getIssuer());
            this.jdbcResolvers.add(jdbcResolver);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception creating JDBCResolver: " + ex.getMessage()), (Throwable)ex);
            throw new PIPException("Exception creating JDBCResolver", ex);
        }
    }

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        String jdbcConnPrefix;
        super.configure(id, properties);
        String propPrefix = id + ".";
        this.type = properties.getProperty(propPrefix + PROP_TYPE, TYPE_JDBC);
        this.jdbcDriverClass = properties.getProperty(propPrefix + PROP_JDBC_DRIVER);
        if (this.jdbcDriverClass == null) {
            this.logger.error((Object)("No '" + propPrefix + PROP_JDBC_DRIVER + "' property"));
            throw new PIPException("No '" + propPrefix + PROP_JDBC_DRIVER + "' property");
        }
        try {
            Class.forName(this.jdbcDriverClass);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception instantiating JDBC driver class '" + this.jdbcDriverClass + "'"), (Throwable)ex);
            throw new PIPException("Exception instantiating JDBC driver class '" + this.jdbcDriverClass + "'", ex);
        }
        this.jdbcUrl = properties.getProperty(propPrefix + PROP_JDBC_URL);
        if (this.jdbcUrl == null) {
            this.logger.error((Object)("No '" + propPrefix + PROP_JDBC_URL + "' property"));
            throw new PIPException("No '" + propPrefix + PROP_JDBC_URL + "' property");
        }
        String propResolverPrefix = propPrefix + PROP_RESOLVERS;
        String stringProp = properties.getProperty(propResolverPrefix);
        if (stringProp == null || stringProp.isEmpty()) {
            this.logger.error((Object)("No '" + propResolverPrefix + "' property"));
            throw new PIPException("No '" + propResolverPrefix + "' property");
        }
        for (String resolverId : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)stringProp)) {
            this.createResolver(propPrefix + PROP_RESOLVER + "." + resolverId, properties);
        }
        stringProp = properties.getProperty(propPrefix + PROP_JDBC_CONN_USER);
        if (stringProp != null) {
            this.jdbcConnProperties.setProperty("user", stringProp);
        }
        if ((stringProp = properties.getProperty(propPrefix + PROP_JDBC_CONN_PASS)) != null) {
            this.jdbcConnProperties.setProperty("password", stringProp);
        }
        if ((stringProp = properties.getProperty(jdbcConnPrefix = propPrefix + PROP_JDBC_CONN)) != null) {
            String[] connProperties;
            jdbcConnPrefix = jdbcConnPrefix + ".";
            for (String connProperty : connProperties = stringProp.split("[,]", 0)) {
                stringProp = properties.getProperty(jdbcConnPrefix + connProperty);
                if (stringProp == null) continue;
                this.jdbcConnProperties.setProperty(connProperty, stringProp);
            }
        }
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        HashSet<PIPRequest> attributes = new HashSet<PIPRequest>();
        for (JDBCResolver jdbcResolver : this.jdbcResolvers) {
            jdbcResolver.attributesRequired(attributes);
        }
        return attributes;
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        HashSet<PIPRequest> attributes = new HashSet<PIPRequest>();
        for (JDBCResolver jdbcResolver : this.jdbcResolvers) {
            jdbcResolver.attributesProvided(attributes);
        }
        return attributes;
    }
}

