/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.trace;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.trace.TraceEngine;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;

public class LoggingTraceEngine
implements TraceEngine {
    private static final LoggingTraceEngine loggingTraceEngine = new LoggingTraceEngine();
    private Log logger = LogFactory.getLog(this.getClass());

    protected LoggingTraceEngine() {
    }

    public static LoggingTraceEngine newInstance() {
        return loggingTraceEngine;
    }

    public static LoggingTraceEngine newInstance(Properties properties) {
        return loggingTraceEngine;
    }

    @Override
    public void trace(TraceEvent<?> traceEvent) {
        String message = traceEvent.getMessage();
        Traceable cause = traceEvent.getCause();
        this.logger.debug((Object)(traceEvent.getTimestamp().toString() + ": " + "\"" + (message == null ? "" : message) + "\"" + (cause == null ? "" : " from \"" + cause.getTraceId() + "\"")));
        Object traceObject = traceEvent.getValue();
        if (traceObject != null) {
            this.logger.debug(traceObject);
        }
    }

    @Override
    public boolean isTracing() {
        return this.logger.isDebugEnabled();
    }
}

