/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.RequestDefaults;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.api.pip.PIPRequest;

public class AttributeUtils {
    public static String prettyPrint(Attribute attribute) {
        String tab = "\t";
        StringBuilder builder = new StringBuilder();
        builder.append(attribute.getAttributeId());
        builder.append(System.lineSeparator());
        builder.append(tab + attribute.getCategory());
        builder.append(System.lineSeparator());
        builder.append(tab + attribute.getIssuer());
        builder.append(System.lineSeparator());
        tab = tab + "\t";
        for (AttributeValue<?> value : attribute.getValues()) {
            builder.append(tab + value.getDataTypeId());
            builder.append(tab + value.getValue().toString());
        }
        return builder.toString();
    }

    public static String prettyPrint(PIPRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getCategory());
        builder.append(System.lineSeparator());
        builder.append(request.getAttributeId());
        builder.append(System.lineSeparator());
        builder.append(request.getDataTypeId());
        builder.append(System.lineSeparator());
        builder.append(request.getIssuer());
        return builder.toString();
    }

    public static String prettyPrint(Request request) {
        StringBuilder builder = new StringBuilder();
        String tab = "\t";
        builder.append("Combined Decision=" + request.getCombinedDecision() + " returnPolicyIdList=" + request.getReturnPolicyIdList());
        builder.append(System.lineSeparator());
        for (RequestAttributes attribute : request.getRequestAttributes()) {
            builder.append(attribute.getCategory());
            builder.append(System.lineSeparator());
            for (Attribute a : attribute.getAttributes()) {
                builder.append(tab + a.getAttributeId() + " issuer=" + a.getIssuer());
                builder.append(System.lineSeparator());
                for (AttributeValue<?> value : a.getValues()) {
                    builder.append(tab + tab + value.getDataTypeId() + " " + value.getValue().toString());
                    builder.append(System.lineSeparator());
                }
            }
        }
        for (RequestReference ref : request.getMultiRequests()) {
            builder.append(System.lineSeparator());
            builder.append("Reference=" + ref);
        }
        RequestDefaults defs = request.getRequestDefaults();
        if (defs != null) {
            builder.append(System.lineSeparator());
            builder.append("Defaults=" + defs.getXPathVersion());
        }
        return builder.toString();
    }
}

