/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.util.Calendar;
import java.util.TimeZone;

public class CalendarTest {
    private static CField[] calFields = new CField[]{new CField("Era", 0), new CField("TimeZone", 15), new CField("Year", 1), new CField("Month", 2), new CField("Day", 5), new CField("Hour", 11), new CField("Minute", 12), new CField("Second", 13), new CField("Millisecond", 14)};

    private static void dumpCalendar(Calendar calendar) {
        System.out.println("Current timestamp=" + calendar.getTimeInMillis());
        System.out.println("Current Date=" + calendar.getTime());
        System.out.println("Current TimeZone=" + calendar.getTimeZone());
        System.out.print("Fields=");
        boolean needsComma = false;
        for (CField cfield : calFields) {
            if (needsComma) {
                System.out.print(",");
            }
            System.out.print(cfield.getFieldName() + "=" + calendar.get(cfield.getCalId()));
            needsComma = true;
        }
        System.out.println();
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        System.out.println("Current Time");
        CalendarTest.dumpCalendar(calendar);
        try {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            System.out.println("GMT Time");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception using timezone GMT: " + ex);
        }
        try {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT-06:00"));
            System.out.println("GMT Time-06:00");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception using timezone GMT: " + ex);
        }
        try {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT-06:10"));
            System.out.println("GMT Time-06:10");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception using timezone GMT: " + ex);
        }
        try {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(1, 10012);
            System.out.println("GMT Time in 10012");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception setting year to 10012 " + ex);
        }
        try {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(1, 1812);
            System.out.println("GMT Time in 1812");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception setting year to 1812 " + ex);
        }
        try {
            calendar.add(6, 60);
            System.out.println("GMT Time in 1812 + 60 days");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception adding 60 days " + ex);
        }
        try {
            calendar.add(6, -900);
            System.out.println("GMT Time in 1812 -900 days");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception subtracting 900 days " + ex);
        }
        try {
            calendar.add(2, 11);
            System.out.println("GMT Time in 1812 + 11 months");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception adding 11 months " + ex);
        }
        try {
            calendar.set(2, 10);
            calendar.set(5, 31);
            System.out.println("GMT Time for Nov 31, 1812");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception setting year to 1812 " + ex);
        }
        try {
            calendar.setTimeInMillis(-8888888888L);
            System.out.println("GMT Time for -8888888888");
            CalendarTest.dumpCalendar(calendar);
        }
        catch (Exception ex) {
            System.err.println("Exception setting time-in-millis to -8888888888 " + ex);
        }
    }

    private static class CField {
        private String fieldName;
        private int calId;

        public CField(String fieldNameIn, int calIdIn) {
            this.fieldName = fieldNameIn;
            this.calId = calIdIn;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getCalId() {
            return this.calId;
        }
    }
}

