/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;

public class FactoryFinder {
    private static final Log logger = LogFactory.getLog(FactoryFinder.class);

    private FactoryFinder() {
    }

    private static Class<?> getProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException {
        try {
            if (cl == null) {
                cl = Thread.class.getClassLoader();
                if (cl == null) {
                    cl = FactoryFinder.class.getClassLoader();
                    if (cl == null) {
                        throw new ClassNotFoundException("No ClassLoader() in current context");
                    }
                    return cl.loadClass(className);
                }
                return cl.loadClass(className);
            }
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (doFallback) {
                return Class.forName(className, true, FactoryFinder.class.getClassLoader());
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T findJarServiceProvider(String factoryId, Class<T> classExtends, Properties xacmlProperties) throws FactoryException {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(serviceId);
            if (is == null) {
                cl = FactoryFinder.class.getClassLoader();
                is = cl.getResourceAsStream(serviceId);
            }
        } else {
            cl = FactoryFinder.class.getClassLoader();
            is = cl.getResourceAsStream(serviceId);
        }
        if (is == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found jar resource=" + serviceId + " using ClassLoader: " + cl));
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
        }
        catch (IOException ex) {
            logger.error((Object)("IOException reading resource stream: " + ex.getMessage()), (Throwable)ex);
            T t = null;
            return t;
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Unable to close stream: " + e), (Throwable)e);
            }
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found in resource, value=" + factoryClassName));
            }
            return FactoryFinder.newInstance(factoryClassName, classExtends, cl, false, xacmlProperties);
        }
        return null;
    }

    public static <T> T newInstance(String className, Class<T> classExtends, ClassLoader cl, boolean doFallback) throws FactoryException {
        return FactoryFinder.newInstance(className, classExtends, cl, doFallback, null);
    }

    public static <T> T newInstance(String className, Class<T> classExtends, ClassLoader cl, boolean doFallback, Properties xacmlProperties) throws FactoryException {
        try {
            Class<?> providerClass = FactoryFinder.getProviderClass(className, cl, doFallback);
            if (classExtends.isAssignableFrom(providerClass)) {
                Object instance = null;
                if (xacmlProperties == null) {
                    instance = providerClass.newInstance();
                } else {
                    for (Constructor<?> constructor : providerClass.getDeclaredConstructors()) {
                        Class<?>[] params = constructor.getParameterTypes();
                        if (params.length != 1 || !params[0].isAssignableFrom(Properties.class)) continue;
                        instance = constructor.newInstance(xacmlProperties);
                    }
                    if (instance == null) {
                        logger.warn((Object)"No constructor that takes a Properties object.");
                        instance = providerClass.newInstance();
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Created new instance of " + providerClass + " using ClassLoader: " + cl));
                }
                return classExtends.cast(instance);
            }
            throw new ClassNotFoundException("Provider " + className + " does not extend " + classExtends.getCanonicalName());
        }
        catch (ClassNotFoundException ex) {
            throw new FactoryException("Provider " + className + " not found", ex);
        }
        catch (Exception ex) {
            throw new FactoryException("Provider " + className + " could not be instantiated: " + ex.getMessage(), ex);
        }
    }

    public static <T> T find(String factoryId, String fallbackClassName, Class<T> classExtends) throws FactoryException {
        return FactoryFinder.find(factoryId, fallbackClassName, classExtends, null);
    }

    public static <T> T find(String factoryId, String fallbackClassName, Class<T> classExtends, Properties xacmlProperties) throws FactoryException {
        String systemProp;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Find factoryId=" + factoryId));
        }
        if ((systemProp = System.getProperty(factoryId)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found system property, value=" + systemProp));
            }
            return FactoryFinder.newInstance(systemProp, classExtends, null, true, xacmlProperties);
        }
        try {
            String factoryClassName = null;
            factoryClassName = xacmlProperties == null ? XACMLProperties.getProperty(factoryId) : xacmlProperties.getProperty(factoryId);
            if (factoryClassName != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found factoryId xacml.properties, value=" + factoryClassName));
                }
                return FactoryFinder.newInstance(factoryClassName, classExtends, null, true, xacmlProperties);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception reading xacml.properties", (Throwable)ex);
        }
        T provider = FactoryFinder.findJarServiceProvider(factoryId, classExtends, xacmlProperties);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new FactoryException("Provider for " + factoryId + " cannot be found", null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loaded from fallback value: " + fallbackClassName));
        }
        return FactoryFinder.newInstance(fallbackClassName, classExtends, null, true, xacmlProperties);
    }
}

