/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.openaz.xacml.util.ObjUtil;

public class ListUtil {
    protected ListUtil() {
    }

    public static <T> void addAll(Iterator<T> iteratorFrom, Collection<T> collectionTo) {
        if (iteratorFrom != null) {
            while (iteratorFrom.hasNext()) {
                collectionTo.add(iteratorFrom.next());
            }
        }
    }

    public static <T> boolean equalsAllowNulls(Iterator<T> iterator1, Iterator<T> iterator2) {
        if (iterator1 == null || !iterator1.hasNext()) {
            return iterator2 == null || !iterator2.hasNext();
        }
        if (iterator2 == null || !iterator2.hasNext()) {
            return false;
        }
        boolean result = true;
        while (result && iterator1.hasNext() && iterator2.hasNext()) {
            result = ObjUtil.equalsAllowNull(iterator1.next(), iterator2.next());
        }
        return result && !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static <T> boolean equalsAllowNulls(Collection<T> collection1, Collection<T> collection2) {
        if (collection1 == collection2) {
            return true;
        }
        if (collection1 == null || collection2 == null) {
            return false;
        }
        if (collection1.size() != collection2.size()) {
            return false;
        }
        Iterator<T> i1 = collection1.iterator();
        Iterator<T> i2 = collection2.iterator();
        while (i1.hasNext()) {
            if (ObjUtil.equalsAllowNull(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> String toString(Collection<T> collection) {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean first = true;
        for (T t : collection) {
            if (!first) {
                stringBuilder.append(',');
            } else {
                first = true;
            }
            if (t == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(t.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

