/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.util.Iterator;

public class StringUtils {
    protected StringUtils() {
    }

    public static String toString(Iterator<?> iterObjects, boolean allowEmptyLists) {
        if (iterObjects == null || !allowEmptyLists && !iterObjects.hasNext()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        if (iterObjects.hasNext()) {
            stringBuilder.append(iterObjects.next().toString());
            while (iterObjects.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterObjects.next().toString());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(short[] a) {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (a != null && a.length > 0) {
            stringBuilder.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                stringBuilder.append(',');
                stringBuilder.append(a[i]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(byte[] a) {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (a != null && a.length > 0) {
            stringBuilder.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                stringBuilder.append(',');
                stringBuilder.append(a[i]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(Iterator<?> iterObjects) {
        return StringUtils.toString(iterObjects, false);
    }

    protected static void indent(StringBuilder stringBuilder, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            stringBuilder.append(' ');
        }
    }

    public static String prettyPrint(String string, int indentSize) {
        if (string == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int stringLen = string.length();
        int curIndent = 0;
        boolean bstart = false;
        int i = 0;
        block8: while (i < stringLen) {
            char charAt = string.charAt(i);
            switch (charAt) {
                case '{': {
                    if (i + 1 < stringLen) {
                        if (string.charAt(i + 1) == '}') {
                            stringBuilder.append("{}");
                            i += 2;
                        } else {
                            if (i > 0) {
                                stringBuilder.append('\n');
                                StringUtils.indent(stringBuilder, ++curIndent * indentSize);
                                stringBuilder.append(charAt);
                            } else {
                                stringBuilder.append(charAt);
                            }
                            ++i;
                        }
                    } else {
                        stringBuilder.append(charAt);
                        ++i;
                    }
                    bstart = true;
                    continue block8;
                }
                case '}': {
                    stringBuilder.append('\n');
                    StringUtils.indent(stringBuilder, curIndent * indentSize);
                    stringBuilder.append('}');
                    if (curIndent > 0) {
                        --curIndent;
                    }
                    ++i;
                    bstart = true;
                    continue block8;
                }
                case '[': {
                    if (i + 1 < stringLen) {
                        if (string.charAt(i + 1) == ']') {
                            stringBuilder.append("[]");
                            i += 2;
                        } else {
                            if (i > 0) {
                                stringBuilder.append('\n');
                                StringUtils.indent(stringBuilder, ++curIndent * indentSize);
                                stringBuilder.append(charAt);
                            } else {
                                stringBuilder.append(charAt);
                            }
                            ++i;
                        }
                    } else {
                        stringBuilder.append(charAt);
                        ++i;
                    }
                    bstart = true;
                    continue block8;
                }
                case ']': {
                    stringBuilder.append('\n');
                    StringUtils.indent(stringBuilder, curIndent * indentSize);
                    stringBuilder.append(']');
                    if (curIndent > 0) {
                        --curIndent;
                    }
                    ++i;
                    bstart = true;
                    continue block8;
                }
                case ',': {
                    stringBuilder.append(charAt);
                    ++i;
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append(charAt);
                    StringUtils.indent(stringBuilder, curIndent * indentSize);
                    ++i;
                    continue block8;
                }
            }
            if (bstart) {
                stringBuilder.append('\n');
                StringUtils.indent(stringBuilder, (curIndent + 1) * indentSize);
                bstart = false;
            }
            stringBuilder.append(charAt);
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String prettyPrint(String string) {
        return StringUtils.prettyPrint(string, 3);
    }
}

