/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AdviceExpressionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ApplyType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeDesignatorType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeSelectorType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ConditionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.EffectType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ObligationExpressionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicyType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.RuleType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.VariableDefinitionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.VariableReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.util.XACMLPolicyScanner;

public class XACMLPolicyAggregator
extends XACMLPolicyScanner.SimpleCallback {
    private static Log logger = LogFactory.getLog(XACMLPolicyAggregator.class);
    protected Map<Identifier, Map<Identifier, Map<Identifier, Set<AttributeValue<?>>>>> attributeMap;
    protected Map<Identifier, Map<EffectType, List<Obligation>>> obligationMap;
    protected Map<Identifier, Map<EffectType, List<Advice>>> adviceMap;
    protected Map<PolicyType, List<VariableDefinitionType>> variableDefinitionMap;
    protected List<VariableReferenceType> variableReferences;

    @Override
    public XACMLPolicyScanner.CallbackResult onAttribute(Object parent, Object container, Attribute attribute) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        if (!this.attributeMap.containsKey(attribute.getCategory())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New category: " + attribute.getCategory()));
            }
            this.attributeMap.put(attribute.getCategory(), new HashMap());
        }
        Map<Identifier, Map<Identifier, Set<AttributeValue<?>>>> map = this.attributeMap.get(attribute.getCategory());
        for (AttributeValue<?> value : attribute.getValues()) {
            Object val;
            if (!map.containsKey(value.getDataTypeId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New Datatype: " + value.getDataTypeId()));
                }
                map.put(value.getDataTypeId(), new HashMap());
            }
            if (!map.get(value.getDataTypeId()).containsKey(attribute.getAttributeId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New attribute: " + attribute.getAttributeId()));
                }
                map.get(value.getDataTypeId()).put(attribute.getAttributeId(), new HashSet());
            }
            if ((val = value.getValue()) == null || val instanceof Collection && ((Collection)val).isEmpty()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("No actual attribute values: " + attribute.getAttributeId() + " " + value.getDataTypeId()));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding attribute value: " + value));
            }
            map.get(value.getDataTypeId()).get(attribute.getAttributeId()).add(value);
        }
        return super.onAttribute(parent, container, attribute);
    }

    @Override
    public XACMLPolicyScanner.CallbackResult onCondition(RuleType rule, ConditionType condition) {
        if (condition.getExpression() != null) {
            this.evaluteExpression(condition.getExpression().getValue(), rule, condition);
        }
        return super.onCondition(rule, condition);
    }

    @Override
    public XACMLPolicyScanner.CallbackResult onObligation(Object parent, ObligationExpressionType expression, Obligation obligation) {
        if (this.obligationMap == null) {
            this.obligationMap = new HashMap<Identifier, Map<EffectType, List<Obligation>>>();
        }
        if (!this.obligationMap.containsKey(obligation.getId())) {
            this.obligationMap.put(obligation.getId(), new HashMap());
        }
        if (this.obligationMap.get(obligation.getId()).get((Object)expression.getFulfillOn()) == null) {
            this.obligationMap.get(obligation.getId()).put(expression.getFulfillOn(), new ArrayList());
        }
        if (!this.obligationMap.get(obligation.getId()).get((Object)expression.getFulfillOn()).contains(obligation)) {
            this.obligationMap.get(obligation.getId()).get((Object)expression.getFulfillOn()).add(obligation);
        }
        return super.onObligation(parent, expression, obligation);
    }

    @Override
    public XACMLPolicyScanner.CallbackResult onAdvice(Object parent, AdviceExpressionType expression, Advice advice) {
        if (this.adviceMap == null) {
            this.adviceMap = new HashMap<Identifier, Map<EffectType, List<Advice>>>();
        }
        if (!this.adviceMap.containsKey(advice.getId())) {
            this.adviceMap.put(advice.getId(), new HashMap());
        }
        if (this.adviceMap.get(advice.getId()).get((Object)expression.getAppliesTo()) == null) {
            this.adviceMap.get(advice.getId()).put(expression.getAppliesTo(), new ArrayList());
        }
        if (!this.adviceMap.get(advice.getId()).get((Object)expression.getAppliesTo()).contains(advice)) {
            this.adviceMap.get(advice.getId()).get((Object)expression.getAppliesTo()).add(advice);
        }
        return super.onAdvice(parent, expression, advice);
    }

    @Override
    public XACMLPolicyScanner.CallbackResult onVariable(PolicyType policy, VariableDefinitionType variable) {
        if (this.variableDefinitionMap == null) {
            this.variableDefinitionMap = new HashMap<PolicyType, List<VariableDefinitionType>>();
        }
        if (!this.variableDefinitionMap.containsKey(policy)) {
            this.variableDefinitionMap.put(policy, new ArrayList());
        }
        this.variableDefinitionMap.get(policy).add(variable);
        if (variable.getExpression() != null) {
            this.evaluteExpression(variable.getExpression().getValue(), policy, variable);
        }
        return super.onVariable(policy, variable);
    }

    protected void evaluteExpression(Object obj, Object parent, Object container) {
        if (obj instanceof AttributeDesignatorType) {
            AttributeDesignatorType designator = (AttributeDesignatorType)obj;
            StdAttribute attribute = new StdAttribute((Identifier)new IdentifierImpl(designator.getCategory()), (Identifier)new IdentifierImpl(designator.getAttributeId()), new StdAttributeValue(new IdentifierImpl(designator.getDataType()), Collections.emptyList()), designator.getIssuer(), false);
            this.onAttribute(parent, container, attribute);
        } else if (obj instanceof VariableReferenceType) {
            if (this.variableReferences == null) {
                this.variableReferences = new ArrayList<VariableReferenceType>();
            }
            this.variableReferences.add((VariableReferenceType)obj);
        } else if (obj instanceof ApplyType) {
            ApplyType apply = (ApplyType)obj;
            for (JAXBElement<?> element : apply.getExpression()) {
                if (element.getValue() == null) continue;
                this.evaluteExpression(element.getValue(), parent, container);
            }
        } else if (obj instanceof AttributeSelectorType) {
            AttributeSelectorType selector = (AttributeSelectorType)obj;
            StdAttribute attribute = new StdAttribute((Identifier)new IdentifierImpl(selector.getCategory()), (Identifier)new IdentifierImpl(selector.getContextSelectorId()), new StdAttributeValue(new IdentifierImpl(selector.getDataType()), Collections.emptyList()), null, false);
            this.onAttribute(parent, container, attribute);
        }
    }

    public Map<Identifier, Map<Identifier, Map<Identifier, Set<AttributeValue<?>>>>> getAttributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public Map<Identifier, Map<EffectType, List<Obligation>>> getObligationMap() {
        if (this.obligationMap == null) {
            this.obligationMap = new HashMap<Identifier, Map<EffectType, List<Obligation>>>();
        }
        return Collections.unmodifiableMap(this.obligationMap);
    }

    public Map<Identifier, Map<EffectType, List<Advice>>> getAdviceMap() {
        if (this.adviceMap == null) {
            this.adviceMap = new HashMap<Identifier, Map<EffectType, List<Advice>>>();
        }
        return Collections.unmodifiableMap(this.adviceMap);
    }

    public Map<PolicyType, List<VariableDefinitionType>> getVariableDefinitionMap() {
        return Collections.unmodifiableMap(this.variableDefinitionMap);
    }

    public List<VariableReferenceType> getVariableReferences() {
        return Collections.unmodifiableList(this.variableReferences);
    }
}

