/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XACMLProperties {
    private static final Log logger = LogFactory.getLog(XACMLProperties.class);
    public static final String XACML_PROPERTIES_NAME = "xacml.properties";
    public static final String XACML_PROPERTIES_FILE = System.getProperty("java.home") + File.separator + "lib" + File.separator + "xacml.properties";
    public static final String PROP_DATATYPEFACTORY = "xacml.dataTypeFactory";
    public static final String PROP_PDPENGINEFACTORY = "xacml.pdpEngineFactory";
    public static final String PROP_PEPENGINEFACTORY = "xacml.pepEngineFactory";
    public static final String PROP_PIPFINDERFACTORY = "xacml.pipFinderFactory";
    public static final String PROP_TRACEENGINEFACTORY = "xacml.traceEngineFactory";
    public static final String PROP_ROOTPOLICIES = "xacml.rootPolicies";
    public static final String PROP_REFERENCEDPOLICIES = "xacml.referencedPolicies";
    public static final String PROP_PDP_BEHAVIOR = "xacml.pdp.behavior";
    public static final String PROP_PIP_ENGINES = "xacml.pip.engines";
    public static final String PROP_PAP_PAPENGINEFACTORY = "xacml.PAP.papEngineFactory";
    public static final String PROP_AC_PAPENGINEFACTORY = "xacml.AC.papEngineFactory";
    private static volatile Properties properties = new Properties();
    private static boolean needCache = true;

    private static File getPropertiesFile() {
        String propertiesFileName = System.getProperty(XACML_PROPERTIES_NAME);
        if (propertiesFileName == null) {
            propertiesFileName = XACML_PROPERTIES_FILE;
        }
        return new File(propertiesFileName);
    }

    protected XACMLProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() throws IOException {
        if (needCache) {
            Properties properties = XACMLProperties.properties;
            synchronized (properties) {
                if (needCache) {
                    File fileProperties = XACMLProperties.getPropertiesFile();
                    if (fileProperties.exists() && fileProperties.canRead()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Loading properties from " + fileProperties.getAbsolutePath()));
                        }
                        try (FileInputStream is = new FileInputStream(fileProperties);){
                            XACMLProperties.properties.load(is);
                        }
                    } else {
                        logger.warn((Object)("Properties file " + fileProperties.getAbsolutePath() + " cannot be read."));
                    }
                    needCache = false;
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadProperties() {
        Properties properties = XACMLProperties.properties;
        synchronized (properties) {
            XACMLProperties.properties = new Properties();
            needCache = true;
        }
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            Properties properties = null;
            try {
                properties = XACMLProperties.getProperties();
                value = properties.getProperty(propertyName);
            }
            catch (IOException ex) {
                logger.debug((Object)("Error getting property: " + propertyName), (Throwable)ex);
            }
        }
        return value == null ? defaultValue : value;
    }

    public static void setProperty(String propertyName, String propertyValue) {
        try {
            XACMLProperties.getProperties().setProperty(propertyName, propertyValue);
        }
        catch (IOException ex) {
            logger.debug((Object)("Error setting property: " + propertyName), (Throwable)ex);
        }
    }

    public static String getProperty(String propertyName) {
        return XACMLProperties.getProperty(propertyName, null);
    }

    public static Properties getPolicyProperties(Properties current, boolean checkURLs) throws Exception {
        Properties props = new Properties();
        String[] lists = new String[]{current.getProperty(PROP_ROOTPOLICIES), current.getProperty(PROP_REFERENCEDPOLICIES)};
        if (lists[0] == null) {
            logger.error((Object)"Missing property: xacml.rootPolicies");
            throw new Exception("Missing property: xacml.rootPolicies");
        }
        props.setProperty(PROP_ROOTPOLICIES, lists[0]);
        if (lists[1] == null) {
            logger.error((Object)"Missing property: xacml.referencedPolicies");
            throw new Exception("Missing property: xacml.referencedPolicies");
        }
        props.setProperty(PROP_REFERENCEDPOLICIES, lists[1]);
        Set<Object> keys = current.keySet();
        for (String list : lists) {
            Iterable policies;
            if (list == null || list.length() == 0 || (policies = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)list)) == null) continue;
            for (String policy : policies) {
                for (Object key : keys) {
                    if (!key.toString().startsWith(policy)) continue;
                    props.setProperty(key.toString(), current.getProperty(key.toString()));
                }
                if (!checkURLs) continue;
                String urlString = (String)props.get(policy + ".url");
                if (urlString == null) {
                    logger.error((Object)("Policy '" + policy + "' has no .url property"));
                    throw new Exception("Policy '" + policy + "' has no .url property");
                }
                try {
                    new URL(urlString);
                }
                catch (MalformedURLException e) {
                    logger.error((Object)("Policy '" + policy + "' has bad .url property"));
                    throw new Exception("Policy '" + policy + "' has bad .url property");
                }
            }
        }
        return props;
    }

    public static Properties getPolicyProperties() throws Exception {
        return XACMLProperties.getPolicyProperties(XACMLProperties.getPolicyProperties(), false);
    }

    public static Set<String> getRootPolicyIDs(Properties props) {
        HashSet<String> ids = new HashSet<String>();
        String roots = props.getProperty(PROP_ROOTPOLICIES);
        if (roots == null) {
            return ids;
        }
        Iterable policies = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)roots);
        for (String id : policies) {
            ids.add(id);
        }
        return ids;
    }

    public static Set<String> getReferencedPolicyIDs(Properties props) {
        HashSet<String> ids = new HashSet<String>();
        String refs = props.getProperty(PROP_REFERENCEDPOLICIES);
        if (refs == null) {
            return ids;
        }
        Iterable policies = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)refs);
        for (String id : policies) {
            ids.add(id);
        }
        return ids;
    }

    public static Set<String> getPolicyIDs(Properties props) {
        Set<String> ids = XACMLProperties.getRootPolicyIDs(props);
        ids.addAll(XACMLProperties.getReferencedPolicyIDs(props));
        return ids;
    }

    public static Properties getPipProperties(Properties current) throws Exception {
        Properties props = new Properties();
        String list = current.getProperty(PROP_PIP_ENGINES);
        if (list == null) {
            throw new Exception("Missing property: xacml.pip.engines");
        }
        props.setProperty(PROP_PIP_ENGINES, list);
        if (list == null || list.length() == 0) {
            return props;
        }
        Iterable pips = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)list);
        if (pips == null) {
            return props;
        }
        Set<Object> keys = current.keySet();
        for (String pip : pips) {
            for (Object key : keys) {
                if (!key.toString().startsWith(pip)) continue;
                props.setProperty(key.toString(), current.getProperty(key.toString()));
            }
        }
        return props;
    }

    public static Properties getPipProperties() throws Exception {
        return XACMLProperties.getPipProperties(XACMLProperties.getPipProperties());
    }
}

