/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.std.dom.DOMDocumentRepair;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;

public class XACMLRepair {
    private static final Log logger = LogFactory.getLog(XACMLRepair.class);
    public static final String PROP_DOCUMENT_REPAIR_CLASSNAME = "xacml.documentRepairClassName";
    private List<File> listInputFilesOrDirectories = new ArrayList<File>();
    private File outputFileOrDirectory;
    private boolean forceOutput;
    private String documentRepairClassName;
    private DOMDocumentRepair domDocumentRepair;
    private boolean verbose;

    private DOMDocumentRepair getDOMDocumentRepair() {
        if (this.domDocumentRepair == null) {
            if (this.documentRepairClassName == null) {
                this.documentRepairClassName = System.getProperty(PROP_DOCUMENT_REPAIR_CLASSNAME);
            }
            if (this.documentRepairClassName == null) {
                this.domDocumentRepair = new DOMDocumentRepair();
            } else {
                try {
                    Class<?> classDocumentRepair = Class.forName(this.documentRepairClassName);
                    if (!DOMDocumentRepair.class.isAssignableFrom(classDocumentRepair)) {
                        throw new IllegalArgumentException("Not a DOMDocumentRepair class");
                    }
                    this.domDocumentRepair = (DOMDocumentRepair)classDocumentRepair.newInstance();
                }
                catch (Exception ex) {
                    System.err.println("Warning: Could not find Class " + this.documentRepairClassName + ":" + ex.getMessage() + ": using " + DOMDocumentRepair.class.getCanonicalName());
                    this.domDocumentRepair = new DOMDocumentRepair();
                }
            }
        }
        return this.domDocumentRepair;
    }

    private boolean init(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--input") || args[i].equals("-i")) {
                if (i + 1 < args.length) {
                    ++i;
                    while (i < args.length && !args[i].startsWith("-")) {
                        this.listInputFilesOrDirectories.add(new File(args[i++]));
                    }
                    continue;
                }
                System.err.println("Missing argument to " + args[i] + " command line option");
                return false;
            }
            if (args[i].equals("--output") || args[i].equals("-o")) {
                if (i + 1 < args.length) {
                    this.outputFileOrDirectory = new File(args[i + 1]);
                    i += 2;
                    continue;
                }
                System.err.println("Missing argument to " + args[i] + " command line option");
                return false;
            }
            if (args[i].equals("--force") || args[i].equals("-f")) {
                if (i + 1 < args.length) {
                    this.forceOutput = true;
                    ++i;
                    continue;
                }
                System.err.println("Missing argument to " + args[i] + " command line option");
                return false;
            }
            if (args[i].equals("--repairClass")) {
                if (i + 1 < args.length) {
                    this.documentRepairClassName = args[i + 1];
                    i += 2;
                    continue;
                }
                System.err.println("Missing argument to " + args[i] + " command line option");
                return false;
            }
            if (args[i].equals("--verbose") || args[i].equals("-i")) {
                this.verbose = true;
                ++i;
                continue;
            }
            System.err.println("Unknown command line option " + args[i]);
            return false;
        }
        this.getDOMDocumentRepair();
        return true;
    }

    private boolean run(InputStream inputStream, File fileOrig, OutputStream outputStream, File fileDest) throws Exception {
        String msg = "Repairing " + (fileOrig == null ? "stdin" : fileOrig.getAbsoluteFile());
        if (this.verbose) {
            System.out.println(msg);
        }
        logger.info((Object)msg);
        Document documentFile = null;
        try {
            documentFile = DOMUtil.loadDocument(inputStream);
        }
        catch (DOMStructureException ex) {
            msg = "Error loading " + (fileOrig == null ? "from stdin" : fileOrig.getAbsoluteFile()) + ": " + ex.getMessage();
            System.err.println(msg);
            logger.error((Object)msg);
            return false;
        }
        if (documentFile == null) {
            msg = "No document " + (fileOrig == null ? "from stdin" : fileOrig.getAbsoluteFile());
            System.err.println(msg);
            logger.error((Object)msg);
            return false;
        }
        boolean bUpdated = false;
        DOMDocumentRepair domDocumentRepair = this.getDOMDocumentRepair();
        try {
            bUpdated = domDocumentRepair.repair(documentFile);
        }
        catch (DOMStructureException ex) {
            msg = "Error repairing " + (fileOrig == null ? "from stdin" : fileOrig.getAbsoluteFile()) + ": " + ex.getMessage();
            System.err.println(msg);
            logger.error((Object)msg);
            return false;
        }
        catch (DOMDocumentRepair.UnsupportedDocumentTypeException ex) {
            msg = "Unknown document type in " + (fileOrig == null ? "stdin" : fileOrig.getAbsoluteFile()) + ": skipping";
            if (this.verbose) {
                System.err.println(msg);
            }
            logger.debug((Object)msg);
            return false;
        }
        if (bUpdated) {
            msg = "Repairs made in " + (fileOrig == null ? "stdin" : fileOrig.getAbsoluteFile());
            if (this.verbose) {
                System.out.println(msg);
            }
            logger.debug((Object)msg);
        }
        if (bUpdated || this.forceOutput) {
            msg = "Writing to " + (fileDest == null ? "stdout" : fileDest.getAbsoluteFile());
            System.out.println(msg);
            logger.info((Object)msg);
            String newDocument = DOMUtil.toString(documentFile);
            outputStream.write(newDocument.getBytes());
            outputStream.flush();
            return true;
        }
        return false;
    }

    private void run(InputStream inputStream, File fileOrig) throws Exception {
        if (this.outputFileOrDirectory == null) {
            this.run(inputStream, fileOrig, System.out, null);
        } else if (this.outputFileOrDirectory.exists()) {
            if (this.outputFileOrDirectory.isDirectory()) {
                File fileOutput = new File(this.outputFileOrDirectory, fileOrig.getName());
                boolean bWritten = false;
                try (FileOutputStream fileOutputStream = new FileOutputStream(fileOutput);){
                    bWritten = this.run(inputStream, fileOrig, fileOutputStream, fileOutput);
                }
                if (!bWritten) {
                    fileOutput.delete();
                }
            } else {
                boolean bWritten = false;
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.outputFileOrDirectory);){
                    bWritten = this.run(inputStream, fileOrig, fileOutputStream, this.outputFileOrDirectory);
                }
                if (!bWritten) {
                    this.outputFileOrDirectory.delete();
                }
            }
        }
    }

    private void run(File inputFile) throws Exception {
        block15: {
            block14: {
                if (!inputFile.exists()) {
                    String msg = "Input file " + inputFile.getAbsolutePath() + " does not exist.";
                    System.err.println(msg);
                    logger.error((Object)msg);
                    return;
                }
                if (!inputFile.isDirectory()) break block14;
                File[] directoryContents = inputFile.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                });
                if (directoryContents == null || directoryContents.length <= 0) break block15;
                for (File file : directoryContents) {
                    this.run(file);
                }
                break block15;
            }
            try (FileInputStream fileInputStream = new FileInputStream(inputFile);){
                this.run(fileInputStream, inputFile);
            }
        }
    }

    private void run() throws Exception {
        if (this.listInputFilesOrDirectories.size() == 0) {
            this.run(System.in, null);
        } else {
            for (File inputFile : this.listInputFilesOrDirectories) {
                this.run(inputFile);
            }
        }
    }

    public static void main(String[] args) {
        XACMLRepair xacmlRepair = new XACMLRepair();
        try {
            if (xacmlRepair.init(args)) {
                xacmlRepair.run();
            }
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex.getMessage());
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

