/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.maven.plugin.AbstractAddressMojo;
import org.apache.openejb.maven.plugin.TomEEException;
import org.apache.openejb.maven.plugin.cli.Args;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.util.QuickServerXmlParser;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractTomEEMojo
extends AbstractAddressMojo {
    private static final String NAME_STR = "?name=";
    private static final String UNZIP_PREFIX = "unzip:";
    private static final String REMOVE_PREFIX = "remove:";
    public static final String QUIT_CMD = "quit";
    public static final String EXIT_CMD = "exit";
    public static final String TOM_EE = "TomEE";
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Parameter(property="tomee-plugin.skipCurrentProject", defaultValue="false")
    protected boolean skipCurrentProject;
    @Parameter(property="tomee-plugin.version", defaultValue="-1")
    protected String tomeeVersion;
    @Parameter(property="tomee-plugin.groupId", defaultValue="org.apache.openejb")
    protected String tomeeGroupId;
    @Parameter(property="tomee-plugin.artifactId", defaultValue="apache-tomee")
    protected String tomeeArtifactId;
    @Parameter(property="tomee-plugin.type", defaultValue="zip", readonly=true)
    protected String tomeeType;
    @Parameter(property="tomee-plugin.apache-repos", defaultValue="snapshots")
    protected String apacheRepos;
    @Parameter(property="tomee-plugin.classifier", defaultValue="webprofile")
    protected String tomeeClassifier;
    @Parameter(property="tomee-plugin.shutdown", defaultValue="8005")
    protected int tomeeShutdownPort;
    @Parameter(property="tomee-plugin.shutdown.attempts", defaultValue="60")
    protected int tomeeShutdownAttempts;
    @Parameter(property="tomee-plugin.shutdown-command", defaultValue="SHUTDOWN")
    protected String tomeeShutdownCommand;
    @Parameter(property="tomee-plugin.ajp", defaultValue="8009")
    protected int tomeeAjpPort;
    @Parameter(property="tomee-plugin.https")
    protected Integer tomeeHttpsPort;
    @Parameter(property="tomee-plugin.args")
    protected String args;
    @Parameter(property="tomee-plugin.debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="tomee-plugin.simple-log", defaultValue="false")
    protected boolean simpleLog;
    @Parameter(property="tomee-plugin.debugPort", defaultValue="5005")
    protected int debugPort;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp", property="tomee-plugin.webappResources")
    protected File webappResources;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="tomee-plugin.webappClasses")
    protected File webappClasses;
    @Parameter(defaultValue="${project.build.directory}/apache-tomee", property="tomee-plugin.catalina-base")
    protected File catalinaBase;
    @Parameter
    protected String context;
    @Parameter(defaultValue="webapps")
    protected String webappDir;
    @Parameter(defaultValue="apps")
    protected String appDir;
    @Parameter(defaultValue="lib")
    protected String libDir;
    @Parameter(defaultValue="${project.basedir}/src/main")
    protected File mainDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File target;
    @Parameter(property="tomee-plugin.conf", defaultValue="${project.basedir}/src/main/tomee/conf")
    protected File config;
    @Parameter(property="tomee-plugin.bin", defaultValue="${project.basedir}/src/main/tomee/bin")
    protected File bin;
    @Parameter(property="tomee-plugin.lib", defaultValue="${project.basedir}/src/main/tomee/lib")
    protected File lib;
    @Parameter
    protected Map<String, String> systemVariables;
    @Parameter
    protected List<String> classpaths;
    @Parameter
    protected List<String> customizers;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="tomee-plugin.webappDefaultConfig", defaultValue="false")
    protected boolean webappDefaultConfig;
    @Parameter(property="tomee-plugin.quick-session", defaultValue="true")
    protected boolean quickSession;
    @Parameter(property="tomee-plugin.force-reloadable", defaultValue="false")
    protected boolean forceReloadable;
    @Parameter(property="tomee-plugin.jsp-development", defaultValue="true")
    protected boolean forceJspDevelopment;
    @Parameter
    protected List<String> libs;
    @Parameter
    protected List<String> endorsedLibs;
    @Parameter
    protected List<String> javaagents;
    @Parameter(property="tomee-plugin.persist-javaagents", defaultValue="false")
    protected boolean persistJavaagents;
    @Parameter
    protected List<String> webapps;
    @Parameter
    protected List<String> apps;
    @Parameter(property="tomee-plugin.classes", defaultValue="${project.build.outputDirectory}", readonly=true)
    protected File classes;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    protected File warFile;
    @Parameter(property="tomee-plugin.remove-default-webapps", defaultValue="true")
    protected boolean removeDefaultWebapps;
    @Parameter(property="tomee-plugin.deploy-openejb-internal-application", defaultValue="false")
    protected boolean deployOpenEjbApplication;
    @Parameter(property="tomee-plugin.remove-tomee-webapps", defaultValue="true")
    protected boolean removeTomeeWebapp;
    @Parameter(property="tomee-plugin.ejb-remote", defaultValue="true")
    protected boolean ejbRemote;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    protected String packaging;
    @Parameter(property="tomee-plugin.keep-server-xml", defaultValue="false")
    protected boolean keepServerXmlAsthis;
    @Parameter(property="tomee-plugin.check-started", defaultValue="false")
    protected boolean checkStarted;
    @Parameter(property="tomee-plugin.use-console", defaultValue="true")
    protected boolean useConsole;
    @Parameter(property="tomee-plugin.exiting", defaultValue="false")
    protected boolean tomeeAlreadyInstalled;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="tomee-plugin.openejb", defaultValue="false")
    protected boolean useOpenEJB;
    @Parameter
    protected List<File> docBases;
    @Parameter
    protected List<File> externalRepositories;
    @Parameter
    protected PlexusConfiguration inlinedServerXml;
    @Parameter
    protected PlexusConfiguration inlinedTomEEXml;
    @Parameter(property="tomee-plugin.override-on-unzip", defaultValue="true")
    protected boolean overrideOnUnzip;
    protected File deployedFile = null;
    protected RemoteServer server = null;
    protected String container = "TomEE";

    /*
     * Exception decompiling
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClassLoader createClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + artifact.toString()));
            }
        }
        if (this.classes != null && this.classes.exists()) {
            try {
                urls.add(this.classes.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use path " + this.classes.getAbsolutePath()));
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    protected void fixConfig() {
        if (this.useOpenEJB) {
            this.tomeeGroupId = "org.apache.openejb";
            this.tomeeArtifactId = "openejb-standalone";
            this.tomeeClassifier = null;
            this.tomeeShutdownCommand = "Q";
            if (8005 == this.tomeeShutdownPort) {
                this.tomeeShutdownPort = 4200;
            }
            if (this.tomeeVersion.startsWith("2.")) {
                this.tomeeVersion = OpenEjbVersion.get().getVersion();
            }
            if (this.catalinaBase.getName().equals("apache-tomee") && this.catalinaBase.getParentFile().equals(this.target)) {
                this.catalinaBase = new File(this.target, "apache-openejb");
            }
            if (this.config.getParentFile().getName().equals("tomee") && this.config.getParentFile().getParentFile().equals(this.mainDir)) {
                this.config = new File(this.mainDir, "openejb/conf");
            }
            if (this.lib.getParentFile().getName().equals("tomee") && this.lib.getParentFile().getParentFile().equals(this.mainDir)) {
                this.lib = new File(this.mainDir, "openejb/lib");
            }
            if (this.bin.getParentFile().getName().equals("tomee") && this.bin.getParentFile().getParentFile().equals(this.mainDir)) {
                this.bin = new File(this.mainDir, "openejb/bin");
            }
        }
    }

    protected String getAdditionalClasspath() {
        if (!this.classpaths.isEmpty()) {
            StringBuilder cpBuilder = new StringBuilder();
            for (String cp : this.classpaths) {
                cpBuilder.append(cp);
                cpBuilder.append(File.pathSeparatorChar);
            }
            return cpBuilder.substring(0, cpBuilder.length() - 1);
        }
        return null;
    }

    private List<String> webappsAlreadyAdded() {
        File[] files;
        ArrayList<String> list = new ArrayList<String>();
        File webapps = new File(this.catalinaBase, this.webappDir);
        if (webapps.exists() && webapps.isDirectory() && (files = webapps.listFiles()) != null) {
            for (File f : files) {
                list.add(f.getName());
            }
        }
        return list;
    }

    private void activateSimpleLog() {
        File loggingProperties = new File(this.catalinaBase, "conf/logging.properties");
        if (loggingProperties.exists() && !new File(this.config, "conf/logging.properties").exists()) {
            try {
                String content = IO.slurp((File)loggingProperties);
                content = !content.contains("java.util.logging.ConsoleHandler.formatter") ? content + System.getProperty("line.separator") + "java.util.logging.ConsoleHandler.formatter = org.apache.tomee.jul.formatter.SimpleTomEEFormatter" : content.replace(SimpleFormatter.class.getName(), "org.apache.tomee.jul.formatter.SimpleTomEEFormatter");
                AbstractTomEEMojo.doWrite(loggingProperties, content);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Can't set SimpleTomEEFormatter", (Throwable)e);
            }
        }
    }

    private void removeDefaultWebapps(boolean removeTomee, Collection<String> providedWebapps) {
        File[] files;
        File webapps = new File(this.catalinaBase, this.webappDir);
        if (webapps.isDirectory() && null != (files = webapps.listFiles())) {
            for (File webapp : files) {
                String name = webapp.getName();
                if (!webapp.isDirectory() || providedWebapps.contains(name) || !removeTomee && name.equals("tomee")) continue;
                try {
                    FileUtils.deleteDirectory((File)webapp);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        this.getLog().info((CharSequence)"Removed not mandatory default webapps");
    }

    private void copyLibs(List<String> files, File destParent, String defaultType) {
        if (files == null || files.isEmpty()) {
            return;
        }
        if (!destParent.exists() && !destParent.mkdirs()) {
            this.getLog().warn((CharSequence)("can't create '" + destParent.getPath() + "'"));
        }
        for (String file : files) {
            this.updateLib(file, destParent, defaultType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLib(String rawLib, File destParent, String defaultType) {
        BufferedOutputStream os;
        BufferedInputStream is;
        block11: {
            is = null;
            os = null;
            String lib = rawLib;
            String extractedName = null;
            if (lib.contains(NAME_STR)) {
                lib = lib.substring(0, rawLib.indexOf(NAME_STR));
                extractedName = rawLib.substring(rawLib.indexOf(NAME_STR) + NAME_STR.length(), rawLib.length());
                if (!(extractedName.endsWith(".jar") || extractedName.endsWith(".war") || extractedName.endsWith(".ear") || extractedName.endsWith(".rar"))) {
                    extractedName = extractedName + "." + defaultType;
                }
            }
            boolean unzip = false;
            if (lib.startsWith(UNZIP_PREFIX)) {
                lib = lib.substring(UNZIP_PREFIX.length());
                unzip = true;
            }
            if (lib.startsWith(REMOVE_PREFIX)) {
                final String prefix = lib.substring(REMOVE_PREFIX.length());
                File[] files = destParent.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                if (files == null) return;
                for (File file : files) {
                    if (!IO.delete((File)file)) {
                        file.deleteOnExit();
                    }
                    this.getLog().info((CharSequence)("Deleted " + file.getPath()));
                }
                return;
            }
            try {
                File file = this.mvnToFile(lib, defaultType);
                if (!unzip) {
                    File dest = extractedName == null ? new File(destParent, file.getName()) : new File(destParent, extractedName);
                    is = new BufferedInputStream(new FileInputStream(file));
                    os = new BufferedOutputStream(new FileOutputStream(dest));
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                    this.getLog().info((CharSequence)("Copied '" + lib + "' in '" + dest.getAbsolutePath()));
                    break block11;
                }
                Zips.unzip((File)file, (File)destParent, (boolean)true);
                this.getLog().info((CharSequence)("Unzipped '" + lib + "' in '" + destParent.getAbsolutePath()));
            }
            catch (Exception e) {
                try {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    throw new TomEEException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    IOUtil.close(os);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)os);
        return;
    }

    private File mvnToFile(String lib, String defaultType) throws ArtifactResolutionException, ArtifactNotFoundException {
        String[] infos = lib.split(":");
        if (infos.length < 3) {
            throw new TomEEException("format for librairies should be <groupId>:<artifactId>:<version>[:<type>[:<classifier>]]");
        }
        String type = infos.length >= 4 ? infos[3] : defaultType;
        String classifier = infos.length == 5 ? infos[4] : null;
        Artifact artifact = this.factory.createDependencyArtifact(infos[0], infos[1], VersionRange.createFromVersion((String)infos[2]), type, classifier, "compile");
        this.resolver.resolve(artifact, this.remoteRepos, this.local);
        return artifact.getFile();
    }

    private void copyWar() {
        File out;
        block13: {
            block12: {
                if ("pom".equals(this.packaging)) {
                    return;
                }
                boolean war = "war".equals(this.packaging);
                String name = this.destinationName();
                if (war) {
                    out = new File(this.catalinaBase, this.webappDir + "/" + name);
                } else {
                    File parent = new File(this.catalinaBase, this.appDir);
                    if (!parent.exists() && !parent.mkdirs()) {
                        this.getLog().warn((CharSequence)("can't create '" + parent.getPath() + "'"));
                    }
                    out = new File(parent, name);
                }
                JarExtractor.delete((File)out);
                if (!this.warFile.isDirectory() && name.endsWith("." + this.packaging)) {
                    String dir = name.substring(0, name.lastIndexOf(46));
                    File unpacked = war ? new File(this.catalinaBase, this.webappDir + "/" + dir) : new File(this.catalinaBase, this.appDir + "/" + dir);
                    JarExtractor.delete((File)unpacked);
                }
                if (this.warFile.exists() && this.warFile.isDirectory()) {
                    try {
                        IO.copyDirectory((File)this.warFile, (File)out);
                    }
                    catch (IOException e) {
                        throw new TomEEException(e.getMessage(), e);
                    }
                }
                if (!this.warFile.exists()) break block12;
                FileInputStream is = null;
                FileOutputStream os = null;
                try {
                    is = new FileInputStream(this.warFile);
                    os = new FileOutputStream(out);
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                    this.getLog().info((CharSequence)("Installed '" + this.warFile.getAbsolutePath() + "' in " + out.getAbsolutePath()));
                }
                catch (Exception e) {
                    try {
                        throw new TomEEException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(is);
                        IOUtil.close(os);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)os);
                break block13;
            }
            this.getLog().warn((CharSequence)("'" + this.warFile + "' doesn't exist, ignoring (maybe run mvn package before this plugin)"));
        }
        this.deployedFile = out;
    }

    protected String destinationName() {
        if (this.context != null) {
            if (!this.context.contains(".") && !this.warFile.isDirectory()) {
                return this.context + "." + this.packaging;
            }
            return this.context;
        }
        return this.warFile.getName();
    }

    private void overrideAddresses() {
        String keystoreFilePath;
        File serverXml = new File(this.catalinaBase, "conf/server.xml");
        if (!serverXml.exists()) {
            return;
        }
        QuickServerXmlParser parser = QuickServerXmlParser.parse((File)serverXml);
        String value = AbstractTomEEMojo.read(serverXml);
        File keystoreFile = new File(parser.keystore());
        if (!keystoreFile.exists()) {
            keystoreFile = new File(System.getProperty("user.home"), ".keystore");
        }
        if (!keystoreFile.exists()) {
            keystoreFile = new File("target", ".keystore");
        }
        String string = keystoreFilePath = keystoreFile.exists() ? keystoreFile.getAbsolutePath() : "";
        if (this.tomeeHttpsPort != null && this.tomeeHttpsPort > 0 && parser.value("HTTPS", null) == null) {
            value = value.replace("<Service name=\"Catalina\">", "<Service name=\"Catalina\">\n    <Connector port=\"" + this.tomeeHttpsPort + "\" protocol=\"HTTP/1.1\" SSLEnabled=\"true\"\n" + "                scheme=\"https\" secure=\"true\"\n" + "                clientAuth=\"false\" sslProtocol=\"TLS\" keystoreFile=\"" + keystoreFilePath + "\" />\n");
        }
        if (this.tomeeHttpsPort == null) {
            this.tomeeHttpsPort = 8443;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(serverXml);
            writer.write(value.replace(parser.http(), Integer.toString(this.tomeeHttpPort)).replace(parser.https(), Integer.toString(this.tomeeHttpsPort)).replace(parser.ajp(), Integer.toString(this.tomeeAjpPort)).replace(parser.stop(), Integer.toString(this.tomeeShutdownPort)).replace(parser.host(), this.tomeeHost).replace(parser.appBase(), this.webappDir));
        }
        catch (IOException e) {
            try {
                throw new TomEEException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private static String read(File file) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            StringBuilder sb = new StringBuilder();
            int i = in.read();
            while (i != -1) {
                sb.append((char)i);
                i = in.read();
            }
            string = sb.toString();
        }
        catch (Exception e) {
            try {
                throw new TomEEException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        return string;
    }

    private Collection<File> overrideConf(File dir, String baseDir) {
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            ArrayList<File> copied = new ArrayList<File>();
            for (File f : files) {
                if (f.isHidden()) continue;
                String file = baseDir + "/" + f.getName();
                File destination = new File(this.catalinaBase, file);
                if (f.isDirectory()) {
                    Files.mkdirs((File)destination);
                    try {
                        IO.copyDirectory((File)f, (File)destination);
                        continue;
                    }
                    catch (IOException e) {
                        throw new TomEEException(e.getMessage(), e);
                    }
                }
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(f);
                    out = new FileOutputStream(destination);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                    copied.add(f);
                    this.getLog().info((CharSequence)("Override '" + file + "'"));
                }
                catch (Exception e) {
                    try {
                        throw new TomEEException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        IOUtil.close(out);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)in);
                IOUtil.close((OutputStream)out);
            }
            return copied;
        }
        return Collections.emptyList();
    }

    protected void run() {
        if (this.classpaths == null) {
            this.classpaths = new ArrayList<String>();
        }
        List<String> strings = this.generateJVMArgs();
        System.setProperty("openejb.home", this.catalinaBase.getAbsolutePath());
        if (this.debug) {
            System.setProperty("openejb.server.debug", "true");
            System.setProperty("server.debug.port", Integer.toString(this.debugPort));
        }
        System.setProperty("server.shutdown.port", Integer.toString(this.tomeeShutdownPort));
        System.setProperty("server.shutdown.command", this.tomeeShutdownCommand);
        this.server = new RemoteServer(this.getConnectAttempts(), this.debug);
        this.server.setAdditionalClasspath(this.getAdditionalClasspath());
        this.addShutdownHooks(this.server);
        if (TOM_EE.equals(this.container)) {
            this.server.setPortStartup(this.tomeeHttpPort);
            this.getLog().info((CharSequence)("Running '" + ((Object)((Object)this)).getClass().getName().replace("TomEEMojo", "").toLowerCase(Locale.ENGLISH) + "'. Configured TomEE in plugin is " + this.tomeeHost + ":" + this.tomeeHttpPort + " (plugin shutdown port is " + this.tomeeShutdownPort + " and https port is " + this.tomeeHttpsPort + ")"));
        } else {
            this.getLog().info((CharSequence)("Running '" + ((Object)((Object)this)).getClass().getSimpleName().replace("TomEEMojo", "").toLowerCase(Locale.ENGLISH)));
        }
        InputStream originalIn = System.in;
        this.serverCmd(this.server, strings);
        if (this.getWaitTomEE()) {
            final CountDownLatch stopCondition = new CountDownLatch(1);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    AbstractTomEEMojo.this.stopServer(stopCondition);
                }
            });
            if (this.useConsole) {
                String line;
                Scanner reader = new Scanner(originalIn);
                System.out.flush();
                this.getLog().info((CharSequence)("Waiting for command: " + this.availableCommands()));
                while ((line = this.getNextLine(reader)) != null && !AbstractTomEEMojo.isQuit(line)) {
                    if ("ignore".equals(line) || this.handleLine(line.trim())) continue;
                    System.out.flush();
                    this.getLog().warn((CharSequence)("Command '" + line + "' not understood. Use one of " + this.availableCommands()));
                }
                reader.close();
                this.stopServer(stopCondition);
            }
            try {
                stopCondition.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private String getNextLine(Scanner reader) {
        try {
            return reader.nextLine();
        }
        catch (NoSuchElementException e) {
            return "ignore";
        }
    }

    protected List<String> generateJVMArgs() {
        boolean deactivateStrictServletCompliance;
        String deployOpenEjbAppKey = "openejb.system.apps";
        String servletCompliance = "org.apache.catalina.STRICT_SERVLET_COMPLIANCE";
        boolean bl = deactivateStrictServletCompliance = this.args == null || !this.args.contains("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
        if (this.webappDefaultConfig) {
            this.forceDefaultForNiceWebAppDevelopment();
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (this.systemVariables != null) {
            for (Map.Entry<String, String> entry : this.systemVariables.entrySet()) {
                String value;
                String key = entry.getKey();
                if ("org.apache.catalina.STRICT_SERVLET_COMPLIANCE".equals(key)) {
                    deactivateStrictServletCompliance = false;
                }
                if ((value = entry.getValue()) == null) {
                    strings.add("-D" + key);
                } else if (value.contains(" ")) {
                    strings.add(String.format("'-D%s=%s'", key, value));
                } else {
                    strings.add(String.format("-D%s=%s", key, value));
                }
                if (!"openejb.system.apps".equals(key)) continue;
                this.deployOpenEjbApplication = true;
            }
        }
        if (deactivateStrictServletCompliance) {
            strings.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=false");
        }
        if (this.quickSession) {
            strings.add("-Dopenejb.session.manager=org.apache.tomee.catalina.session.QuickSessionManager");
        }
        if (this.removeTomeeWebapp && this.ejbRemote) {
            strings.add("-Dtomee.remote.support=true");
        }
        if (!(this.deployOpenEjbApplication || this.args != null && this.args.contains("-Dopenejb.system.apps"))) {
            strings.add("-Dopenejb.system.apps=false");
        }
        if (this.args != null) {
            strings.addAll(Args.parse(this.args));
        }
        if (this.javaagents != null) {
            this.addJavaagents(strings);
        }
        if (this.forceReloadable) {
            strings.add("-Dtomee.force-reloadable=true");
        }
        if (!this.getWaitTomEE()) {
            strings.add("-Dtomee.noshutdownhook=true");
        }
        String appName = null;
        if (this.docBases != null && !this.docBases.isEmpty()) {
            if ("war".equals(this.packaging)) {
                appName = this.destinationName().replace(".war", "");
                if (appName.startsWith("/")) {
                    appName = appName.substring(1);
                }
                strings.add("-Dtomee." + appName + ".docBases=" + AbstractTomEEMojo.filesToString(this.docBases));
            } else {
                this.getLog().warn((CharSequence)"docBases parameter only valid for a war");
            }
        }
        if (this.externalRepositories != null && !this.externalRepositories.isEmpty()) {
            if ("war".equals(this.packaging)) {
                String string = appName = appName == null ? this.destinationName().replace(".war", "") : appName;
                if (appName.startsWith("/")) {
                    appName = appName.substring(1);
                }
                strings.add("-Dtomee." + appName + ".externalRepositories=" + AbstractTomEEMojo.filesToString(this.externalRepositories));
            } else {
                this.getLog().warn((CharSequence)"externalRepositories parameter only valid for a war");
            }
        }
        if (this.forceJspDevelopment) {
            this.getLog().info((CharSequence)"TomEE will run in development mode");
            strings.add("-Dtomee.jsp-development=true");
        }
        return strings;
    }

    private void addJavaagents(List<String> strings) {
        String existingJavaagent = "\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"";
        StringBuilder javaagentString = new StringBuilder("\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"");
        for (String rawJavaagent : this.javaagents) {
            String args;
            String javaagent;
            int argsIdx = rawJavaagent.indexOf(61);
            if (argsIdx < 0) {
                argsIdx = rawJavaagent.indexOf(63);
            }
            if (argsIdx > 0) {
                javaagent = rawJavaagent.substring(0, argsIdx);
                args = rawJavaagent.substring(argsIdx);
            } else {
                javaagent = rawJavaagent;
                args = "";
            }
            String path = javaagent;
            if (!new File(javaagent).isFile()) {
                try {
                    File jar = this.mvnToFile(javaagent, "jar");
                    if (this.persistJavaagents) {
                        File javaagentFolder = new File(this.catalinaBase, "javaagent");
                        Files.mkdirs((File)javaagentFolder);
                        String name = jar.getName();
                        path = "$CATALINA_HOME/javaagent/" + name;
                        IO.copy((File)jar, (File)new File(javaagentFolder, name));
                    }
                    strings.add("-javaagent:" + jar.getAbsolutePath() + args);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Can't find " + javaagent));
                    strings.add("-javaagent:" + javaagent);
                }
            } else {
                strings.add("-javaagent:" + javaagent);
            }
            if (!this.persistJavaagents) continue;
            javaagentString.append(" -javaagent:").append(path).append(args);
        }
        if (this.persistJavaagents) {
            try {
                File catalinaSh = new File(this.catalinaBase, "bin/catalina.sh");
                String content = IO.slurp((File)catalinaSh).replace("\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"", javaagentString.toString());
                AbstractTomEEMojo.doWrite(catalinaSh, content);
                File catalinaBat = new File(this.catalinaBase, "bin/catalina.bat");
                content = IO.slurp((File)catalinaBat).replace("\"-javaagent:%CATALINA_HOME%\\lib\\openejb-javaagent.jar\"", javaagentString.toString().replace('\'', '\"').replace('/', '\\').replace("$CATALINA_HOME", "%CATALINA_HOME%"));
                AbstractTomEEMojo.doWrite(catalinaBat, content);
            }
            catch (IOException ioe) {
                throw new OpenEJBRuntimeException((Exception)ioe);
            }
        }
    }

    private void forceDefaultForNiceWebAppDevelopment() {
        if (!this.deployOpenEjbApplication) {
            this.getLog().info((CharSequence)"Forcing deployOpenEjbApplication=true to be able to type 'reload[ENTER]' when classes are updated");
            this.deployOpenEjbApplication = true;
        }
        if (!this.forceReloadable) {
            this.getLog().info((CharSequence)"Forcing forceReloadable=true to be able to type 'reload[ENTER]' when classes are updated");
            this.forceReloadable = true;
        }
        if (this.docBases == null) {
            this.docBases = new ArrayList<File>();
        }
        if (this.docBases.isEmpty() && this.webappResources.exists()) {
            this.getLog().info((CharSequence)("adding " + this.webappResources.toString() + " docBase"));
            this.docBases.add(this.webappResources);
        }
        if (this.externalRepositories == null) {
            this.externalRepositories = new ArrayList<File>();
        }
        if (this.externalRepositories.isEmpty() && this.webappClasses.exists()) {
            this.getLog().info((CharSequence)("adding " + this.webappClasses.toString() + " externalRepository"));
            this.externalRepositories.add(this.webappClasses);
        }
        if (this.systemVariables == null) {
            this.systemVariables = new HashMap<String, String>();
        }
        if (!this.systemVariables.containsKey("openejb.classloader.resources.deeper-first")) {
            this.systemVariables.put("openejb.classloader.force-maven", "true");
        }
    }

    private static String filesToString(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>(files.size());
        for (File path : files) {
            paths.add(path.getAbsolutePath());
        }
        return Join.join((String)",", paths);
    }

    protected Collection<String> availableCommands() {
        return Arrays.asList(QUIT_CMD, EXIT_CMD);
    }

    protected synchronized void stopServer(CountDownLatch stopCondition) {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.server.getServer().waitFor();
            this.getLog().info((CharSequence)(this.container + " stopped"));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Can't stop " + this.container), (Throwable)e);
        }
        this.server = null;
        stopCondition.countDown();
    }

    private static boolean isQuit(String line) {
        if (QUIT_CMD.equalsIgnoreCase(line) || EXIT_CMD.equalsIgnoreCase(line)) {
            return true;
        }
        return QUIT_CMD.equalsIgnoreCase(line = new StringBuilder(line).reverse().toString()) || EXIT_CMD.equalsIgnoreCase(line);
    }

    protected boolean handleLine(String line) {
        return false;
    }

    protected void serverCmd(RemoteServer server, List<String> strings) {
        server.start(strings, this.getCmd(), this.checkStarted);
    }

    protected void addShutdownHooks(RemoteServer server) {
    }

    protected int getConnectAttempts() {
        return this.tomeeShutdownAttempts == 0 ? 60 : this.tomeeShutdownAttempts;
    }

    protected boolean getWaitTomEE() {
        return true;
    }

    private File resolve() {
        block11: {
            if (!this.settings.isOffline()) {
                try {
                    if ("snapshots".equals(this.apacheRepos) || "true".equals(this.apacheRepos)) {
                        this.remoteRepos.add((ArtifactRepository)new DefaultArtifactRepository("apache", "https://repository.apache.org/content/repositories/snapshots/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(true, "daily", "warn"), new ArtifactRepositoryPolicy(false, "never", "warn")));
                        break block11;
                    }
                    try {
                        new URI(this.apacheRepos);
                        this.remoteRepos.add((ArtifactRepository)new DefaultArtifactRepository("additional-repo-tomee-mvn-plugin", this.apacheRepos, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(true, "daily", "warn"), new ArtifactRepositoryPolicy(true, "never", "warn")));
                    }
                    catch (URISyntaxException e) {
                    }
                }
                catch (UnsupportedOperationException uoe) {}
            } else if (this.remoteRepos != null && this.remoteRepos.isEmpty()) {
                this.remoteRepos = new ArrayList<ArtifactRepository>();
            }
        }
        if (this.tomeeClassifier != null && (this.tomeeClassifier.isEmpty() || this.tomeeClassifier.equals("ignore")) || "org.apache.openejb".equals(this.tomeeGroupId) && "openejb-standalone".equals(this.tomeeArtifactId)) {
            this.tomeeClassifier = null;
        }
        try {
            Artifact artifact = this.factory.createDependencyArtifact(this.tomeeGroupId, this.tomeeArtifactId, VersionRange.createFromVersion((String)this.tomeeVersion), this.tomeeType, this.tomeeClassifier, "compile");
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
            return artifact.getFile();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomEEException(e.getMessage(), e);
        }
    }

    private void unzip(File mvnTomEE) {
        ZipFile in = null;
        try {
            in = new ZipFile(mvnTomEE);
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int idx = name.indexOf("/");
                if (idx < 0) {
                    idx = name.indexOf(File.separator);
                }
                if (idx < 0) continue;
                name = name.substring(idx + 1);
                File dest = new File(this.catalinaBase.getAbsolutePath(), name);
                if (!dest.exists()) {
                    File parent = dest.getParentFile();
                    if (!parent.exists() && !parent.mkdirs() || !parent.canWrite() && !parent.setWritable(true) || !parent.canRead() && !parent.setReadable(true)) {
                        throw new RuntimeException("Failed to create or set permissions on: " + parent);
                    }
                } else if (!this.overrideOnUnzip) continue;
                if (entry.isDirectory()) {
                    if (dest.exists() || dest.mkdir()) continue;
                    throw new RuntimeException("Failed to create: " + dest);
                }
                FileOutputStream fos = new FileOutputStream(dest);
                try {
                    IOUtil.copy((InputStream)in.getInputStream(entry), (OutputStream)fos);
                }
                catch (IOException e) {
                    // empty catch block
                }
                IOUtil.close((OutputStream)fos);
                if (!dest.canRead() && !dest.setReadable(true)) {
                    throw new RuntimeException("Failed to set readable on: " + dest);
                }
                if (!dest.getName().endsWith(".sh") || dest.canExecute() || dest.setExecutable(true)) continue;
                throw new RuntimeException("Failed to set executable on: " + dest);
            }
            File file = new File(this.catalinaBase, "conf/tomee.xml");
            if (file.exists()) {
                this.container = TOM_EE;
            } else {
                this.container = "OpenEJB";
                file = new File(this.catalinaBase, "conf/openejb.xml");
                if (file.exists()) {
                    this.webappDir = "apps";
                }
            }
            this.ensureAppsFolderExistAndIsConfiguredByDefault(file);
            this.getLog().info((CharSequence)(this.container + " was unzipped in '" + this.catalinaBase.getAbsolutePath() + "'"));
        }
        catch (Exception e) {
            throw new TomEEException(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void ensureAppsFolderExistAndIsConfiguredByDefault(File file) throws IOException {
        if ("openejb".equals(this.container.toLowerCase(Locale.ENGLISH)) || file.exists() && (this.apps != null && !this.apps.isEmpty() || !"pom".equals(this.packaging) && !"war".equals(this.packaging))) {
            rootTag = this.container.toLowerCase(Locale.ENGLISH);
            if (file.isFile()) {
                try {
                    jaxb = JaxbOpenejb.readConfig((String)file.getAbsolutePath());
                    needAdd = true;
                    for (Deployments d : jaxb.getDeployments()) {
                        if (!"apps".equals(d.getDir())) continue;
                        needAdd = false;
                        break;
                    }
                    if (!needAdd) ** GOTO lbl23
                    content = IO.slurp((File)file);
                    writer = new FileWriter(file);
                    end = "</" + rootTag + ">";
                    writer.write(content.replace(end, "  <Deployments dir=\"apps\" />\n" + end));
                    writer.close();
                }
                catch (OpenEJBException e) {
                    throw new IllegalStateException("illegal tomee.xml:\n" + IO.slurp((File)file), e);
                }
            } else {
                writer = new FileWriter(file);
                writer.write("<?xml version=\"1.0\"?>\n<" + rootTag + ">\n" + "  <Deployments dir=\"apps\" />\n" + "</" + rootTag + ">\n");
                writer.close();
            }
lbl23:
            // 3 sources

            appsFolder = new File(this.catalinaBase, "apps");
            if (!appsFolder.exists() && !appsFolder.mkdirs()) {
                throw new RuntimeException("Failed to create: " + appsFolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWrite(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
        }
        finally {
            IO.close((Closeable)writer);
        }
    }

    public abstract String getCmd();
}

