/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.maven.plugin.AbstractCommandMojo;
import org.apache.openejb.table.Line;
import org.apache.openejb.table.Lines;

@Mojo(name="list")
public class ListEjbMojo
extends AbstractCommandMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Deployer deployer = (Deployer)this.lookup("openejb/DeployerBusinessRemote");
        Collection infos = deployer.getDeployedApps();
        Lines lines = new Lines();
        lines.add(new Line(new String[]{"Name", "Class", "Interface Type", "Bean Type"}));
        for (AppInfo info : infos) {
            for (EjbJarInfo ejbJar : info.ejbJars) {
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    lines.add(new Line(new String[]{bean.ejbDeploymentId, bean.ejbClass, ListEjbMojo.getType(bean), ListEjbMojo.componentType(bean)}));
                }
            }
        }
        lines.print((PrintStream)new LogPrinterStream(this.getLog()));
    }

    private static String componentType(EnterpriseBeanInfo bean) {
        return bean.getClass().getSimpleName().replace("Info", "").replace("Bean", " Bean");
    }

    private static String getType(EnterpriseBeanInfo bc) {
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        if (bc.localbean) {
            sb.append("Local Bean");
            empty = false;
        }
        if (bc.businessLocal != null && !bc.businessLocal.isEmpty()) {
            if (!empty) {
                sb.append(", ");
            }
            sb.append("Local").append(Arrays.asList(bc.businessLocal));
            empty = false;
        }
        if (bc.businessRemote != null && !bc.businessRemote.isEmpty()) {
            if (!empty) {
                sb.append(", ");
            }
            sb.append("Remote").append(Arrays.asList(bc.businessRemote));
        }
        return sb.toString();
    }

    private static class LogPrinterStream
    extends PrintStream {
        private Log logger;

        public LogPrinterStream(Log log) {
            super(new NullOuputStream());
            this.logger = log;
        }

        @Override
        public void print(String s) {
            this.logger.info((CharSequence)s.replace(System.getProperty("line.separator"), ""));
        }

        private static class NullOuputStream
        extends OutputStream {
            private NullOuputStream() {
            }

            @Override
            public void write(int b) throws IOException {
            }
        }
    }
}

