/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.openejb.loader.IO;

public final class Zips {
    private static final int BUFFER_SIZE = 1024;

    private Zips() {
    }

    public static void zip(File dir, File zipName) throws IOException, IllegalArgumentException {
        String[] entries = dir.list();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipName));
        String prefix = dir.getAbsolutePath();
        if (!prefix.endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        for (String entry : entries) {
            File f = new File(dir, entry);
            Zips.zip(out, f, prefix);
        }
        IO.close((Closeable)out);
    }

    private static void zip(ZipOutputStream out, File f, String prefix) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    Zips.zip(out, child, prefix);
                }
            }
        } else {
            int bytesRead;
            byte[] buffer = new byte[1024];
            String path = f.getPath().replace(prefix, "");
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(path);
            out.putNextEntry(entry);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            IO.close((Closeable)in);
        }
    }
}

