/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandle;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;

public class StatefulEJBHomeHandler
extends EJBHomeHandler {
    public StatefulEJBHomeHandler() {
    }

    public StatefulEJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    @Override
    protected Object findX(Method method, Object[] args, Object proxy) throws Throwable {
        throw new SystemException(new UnsupportedOperationException("Session beans may not have find methods"));
    }

    @Override
    protected Object removeByPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        throw new ApplicationException((Throwable)new RemoveException("Session objects are private resources and do not have primary keys"));
    }

    @Override
    protected Object removeWithHandle(Method method, Object[] args, Object proxy) throws Throwable {
        EJBObjectHandle handle = (EJBObjectHandle)args[0];
        if (handle == null) {
            throw new NullPointerException("The handle is null");
        }
        EJBObjectHandler handler = handle.handler;
        Object primKey = handler.primaryKey;
        if (!handler.ejb.deploymentID.equals(this.ejb.deploymentID)) {
            throw new SystemException(new IllegalArgumentException("The handle is not from the same deployment"));
        }
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_HOME_REMOVE_BY_HANDLE, this.ejb, method, args, primKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                StatefulEJBHomeHandler.invalidateAllHandlers(handler.getRegistryId());
                handler.invalidateReference();
                return null;
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }
}

