/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanBuilder;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InterceptorBindingBuilder;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarBuilder {
    protected static final Messages messages = new Messages("org.apache.openejb.util.resources");
    private final ClassLoader classLoader;
    private final Properties props;

    public EjbJarBuilder(Properties props, ClassLoader classLoader) {
        this.props = props;
        this.classLoader = classLoader;
    }

    public HashMap<String, DeploymentInfo> build(EjbJarInfo ejbJar) throws OpenEJBException {
        HashMap<String, DeploymentInfo> deployments = new HashMap<String, DeploymentInfo>();
        InterceptorBindingBuilder interceptorBindingBuilder = new InterceptorBindingBuilder(this.classLoader, ejbJar);
        for (EnterpriseBeanInfo ejbInfo : ejbJar.enterpriseBeans) {
            try {
                EnterpriseBeanBuilder deploymentBuilder = new EnterpriseBeanBuilder(this.classLoader, ejbInfo, ejbJar.moduleId, new ArrayList<String>());
                CoreDeploymentInfo deployment = (CoreDeploymentInfo)deploymentBuilder.build();
                interceptorBindingBuilder.build(deployment, ejbInfo);
                deployment.setJarPath(ejbJar.jarPath);
                deployments.put(ejbInfo.ejbDeploymentId, deployment);
                Container container = (Container)this.props.get(ejbInfo.containerId);
                if (container == null) {
                    throw new IllegalStateException("Container does not exist: " + ejbInfo.containerId + ".  Referenced by deployment: " + deployment.getDeploymentID());
                }
                deployment.setContainer(container);
            }
            catch (Throwable e) {
                throw new OpenEJBException("Error building bean '" + ejbInfo.ejbName + "'.  Exception: " + e.getClass() + ": " + e.getMessage(), e);
            }
        }
        return deployments;
    }
}

