/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.CallbackInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InterceptorBindingInfo;
import org.apache.openejb.assembler.classic.InterceptorInfo;
import org.apache.openejb.assembler.classic.NamedMethodInfo;
import org.apache.openejb.assembler.classic.StatefulBeanInfo;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, InterceptorBindingBuilder.class.getPackage().getName());
    private final List<InterceptorBindingInfo> packageAndClassBindings;
    private final EjbJarInfo ejbJarInfo;
    private final ArrayList<InterceptorBindingInfo> bindings;
    private final Map<String, InterceptorData> interceptors = new HashMap<String, InterceptorData>();

    public InterceptorBindingBuilder(ClassLoader cl, EjbJarInfo ejbJarInfo) throws OpenEJBException {
        this.ejbJarInfo = ejbJarInfo;
        this.bindings = new ArrayList<InterceptorBindingInfo>(ejbJarInfo.interceptorBindings);
        Collections.sort(this.bindings, new IntercpetorBindingComparator());
        Collections.reverse(this.bindings);
        this.packageAndClassBindings = new ArrayList<InterceptorBindingInfo>();
        for (InterceptorBindingInfo binding : this.bindings) {
            Level level = InterceptorBindingBuilder.level(binding);
            if (level != Level.PACKAGE && level != Level.CLASS) continue;
            this.packageAndClassBindings.add(binding);
        }
        for (InterceptorInfo info : ejbJarInfo.interceptors) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(info.clazz, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException("Interceptor class cannot be loaded: " + info.clazz);
            }
            InterceptorData interceptor = new InterceptorData(clazz);
            this.toMethods(clazz, info.aroundInvoke, interceptor.getAroundInvoke());
            this.toMethods(clazz, info.postActivate, interceptor.getPostActivate());
            this.toMethods(clazz, info.prePassivate, interceptor.getPrePassivate());
            this.toMethods(clazz, info.postConstruct, interceptor.getPostConstruct());
            this.toMethods(clazz, info.preDestroy, interceptor.getPreDestroy());
            this.interceptors.put(info.clazz, interceptor);
        }
    }

    public void build(CoreDeploymentInfo deploymentInfo, EnterpriseBeanInfo beanInfo) {
        Class clazz = deploymentInfo.getBeanClass();
        InterceptorData beanAsInterceptor = new InterceptorData(clazz);
        this.toMethods(clazz, beanInfo.aroundInvoke, beanAsInterceptor.getAroundInvoke());
        this.toCallback(clazz, beanInfo.postConstruct, beanAsInterceptor.getPostConstruct());
        this.toCallback(clazz, beanInfo.preDestroy, beanAsInterceptor.getPreDestroy());
        if (beanInfo instanceof StatefulBeanInfo) {
            StatefulBeanInfo stateful = (StatefulBeanInfo)beanInfo;
            this.toCallback(clazz, stateful.postActivate, beanAsInterceptor.getPostActivate());
            this.toCallback(clazz, stateful.prePassivate, beanAsInterceptor.getPrePassivate());
        }
        for (Method method : deploymentInfo.getBeanClass().getMethods()) {
            List<InterceptorData> methodInterceptors = this.createInterceptorDatas(method, beanInfo.ejbName, this.bindings);
            methodInterceptors.add(beanAsInterceptor);
            deploymentInfo.setMethodInterceptors(method, methodInterceptors);
        }
        List<InterceptorData> callbackInterceptorDatas = this.createInterceptorDatas(null, beanInfo.ejbName, this.packageAndClassBindings);
        callbackInterceptorDatas.add(beanAsInterceptor);
        deploymentInfo.setCallbackInterceptors(callbackInterceptorDatas);
    }

    private List<InterceptorData> createInterceptorDatas(Method method, String ejbName, List<InterceptorBindingInfo> bindings) {
        List<InterceptorBindingInfo> methodBindings = this.processBindings(method, ejbName, bindings);
        Collections.reverse(methodBindings);
        ArrayList<InterceptorData> methodInterceptors = new ArrayList<InterceptorData>();
        for (InterceptorBindingInfo info : methodBindings) {
            List<String> classes = info.interceptorOrder.size() > 0 ? info.interceptorOrder : info.interceptors;
            for (String interceptorClassName : classes) {
                InterceptorData interceptorData = this.interceptors.get(interceptorClassName);
                if (interceptorData == null) {
                    logger.warning("InterceptorBinding references non-existent (undeclared) interceptor: " + interceptorClassName);
                    continue;
                }
                methodInterceptors.add(interceptorData);
            }
        }
        return methodInterceptors;
    }

    private List<InterceptorBindingInfo> processBindings(Method method, String ejbName, List<InterceptorBindingInfo> bindings) {
        ArrayList<InterceptorBindingInfo> methodBindings = new ArrayList<InterceptorBindingInfo>();
        HashSet<Level> excludes = new HashSet<Level>();
        for (InterceptorBindingInfo info : bindings) {
            Level level = InterceptorBindingBuilder.level(info);
            if (!this.implies(method, ejbName, level, info)) continue;
            Type type = InterceptorBindingBuilder.type(level, info);
            if (type == Type.EXPLICIT_ORDERING && !excludes.contains((Object)level)) {
                methodBindings.add(info);
                return methodBindings;
            }
            if (type == Type.SAME_AND_LOWER_EXCLUSION) {
                return methodBindings;
            }
            if (type == Type.SAME_LEVEL_EXCLUSION) {
                excludes.add(level);
            }
            if (!excludes.contains((Object)level)) {
                methodBindings.add(info);
            }
            if (info.excludeClassInterceptors) {
                excludes.add(Level.CLASS);
            }
            if (!info.excludeDefaultInterceptors) continue;
            excludes.add(Level.PACKAGE);
        }
        return methodBindings;
    }

    private boolean implies(Method method, String ejbName, Level level, InterceptorBindingInfo info) {
        if (level == Level.PACKAGE) {
            return true;
        }
        if (!ejbName.equals(info.ejbName)) {
            return false;
        }
        if (level == Level.CLASS) {
            return true;
        }
        NamedMethodInfo methodInfo = info.method;
        if (!methodInfo.methodName.equals(method.getName())) {
            return false;
        }
        List<String> params = methodInfo.methodParams;
        if (params == null) {
            return true;
        }
        if (params.size() != method.getParameterTypes().length) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String methodParam = params.get(i);
            try {
                Class param = Classes.forName(methodParam, parameterType.getClassLoader());
                if (param.equals(parameterType)) continue;
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    private void toMethods(Class clazz, List<CallbackInfo> callbackInfos, List<Method> methods) {
        for (CallbackInfo callbackInfo : callbackInfos) {
            try {
                Class c;
                Method method = this.getMethod(clazz, callbackInfo.method, InvocationContext.class);
                if (callbackInfo.className == null && method.getDeclaringClass().equals(clazz)) {
                    methods.add(method);
                }
                if (method.getDeclaringClass().getName().equals(callbackInfo.className)) {
                    methods.add(method);
                    continue;
                }
                for (c = clazz; c != null && !c.getName().equals(callbackInfo.className); c = c.getSuperclass()) {
                }
                if (c == null) continue;
                try {
                    method = this.getMethod(c, callbackInfo.method, InvocationContext.class);
                    if (!Modifier.isPrivate(method.getModifiers())) continue;
                    SetAccessible.on(method);
                    methods.add(method);
                }
                catch (NoSuchMethodException e) {
                }
            }
            catch (NoSuchMethodException e) {
                logger.warning("Interceptor method not found (skipping): public Object " + callbackInfo.method + "(InvocationContext); in class " + clazz.getName());
            }
        }
        Collections.sort(methods, new MethodCallbackComparator());
    }

    private void toCallback(Class clazz, List<CallbackInfo> callbackInfos, List<Method> methods) {
        for (CallbackInfo callbackInfo : callbackInfos) {
            try {
                Class c;
                Method method = this.getMethod(clazz, callbackInfo.method, new Class[0]);
                if (callbackInfo.className == null) {
                    methods.add(method);
                    continue;
                }
                if (method.getDeclaringClass().getName().equals(callbackInfo.className)) {
                    methods.add(method);
                    continue;
                }
                for (c = clazz; c != null && !c.getName().equals(callbackInfo.className); c = c.getSuperclass()) {
                }
                if (c == null) continue;
                try {
                    method = c.getDeclaredMethod(callbackInfo.method, new Class[0]);
                    if (!Modifier.isPrivate(method.getModifiers())) continue;
                    SetAccessible.on(method);
                    methods.add(method);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (NoSuchMethodException e) {
                String message = "Bean Callback method not found (skipping): public void " + callbackInfo.method + "(); in class " + clazz.getName();
                logger.warning(message);
                throw new IllegalStateException(message, e);
            }
        }
        Collections.sort(methods, new MethodCallbackComparator());
    }

    private Method getMethod(Class clazz, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return SetAccessible.on(method);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }

    private static Level level(InterceptorBindingInfo info) {
        if (info.ejbName.equals("*")) {
            return Level.PACKAGE;
        }
        if (info.method == null) {
            return Level.CLASS;
        }
        if (info.method.methodParams == null) {
            return Level.OVERLOADED_METHOD;
        }
        return Level.EXACT_METHOD;
    }

    private static Type type(Level level, InterceptorBindingInfo info) {
        if (info.interceptorOrder.size() > 0) {
            return Type.EXPLICIT_ORDERING;
        }
        if (level == Level.CLASS && info.excludeClassInterceptors && info.excludeDefaultInterceptors) {
            return Type.SAME_AND_LOWER_EXCLUSION;
        }
        if (level == Level.CLASS && info.excludeClassInterceptors) {
            return Type.SAME_LEVEL_EXCLUSION;
        }
        return Type.ADDITION_OR_LOWER_EXCLUSION;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodCallbackComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method m1, Method m2) {
            Class<?> c2;
            Class<?> c1 = m1.getDeclaringClass();
            if (c1.equals(c2 = m2.getDeclaringClass())) {
                return 0;
            }
            if (c1.isAssignableFrom(c2)) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntercpetorBindingComparator
    implements Comparator<InterceptorBindingInfo> {
        @Override
        public int compare(InterceptorBindingInfo a, InterceptorBindingInfo b) {
            Level levelB;
            Level levelA = InterceptorBindingBuilder.level(a);
            if (levelA != (levelB = InterceptorBindingBuilder.level(b))) {
                return levelA.ordinal() - levelB.ordinal();
            }
            return InterceptorBindingBuilder.type(levelA, a).ordinal() - InterceptorBindingBuilder.type(levelB, b).ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADDITION_OR_LOWER_EXCLUSION,
        SAME_LEVEL_EXCLUSION,
        SAME_AND_LOWER_EXCLUSION,
        EXPLICIT_ORDERING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        PACKAGE,
        CLASS,
        OVERLOADED_METHOD,
        EXACT_METHOD;

    }
}

