/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodConcurrencyBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, MethodConcurrencyBuilder.class);

    public void build(HashMap<String, DeploymentInfo> deployments, List<MethodConcurrencyInfo> methodConcurrencys) throws OpenEJBException {
        for (DeploymentInfo deploymentInfo : deployments.values()) {
            MethodConcurrencyBuilder.applyConcurrencyAttributes((CoreDeploymentInfo)deploymentInfo, methodConcurrencys);
        }
    }

    public static void applyConcurrencyAttributes(CoreDeploymentInfo deploymentInfo, List<MethodConcurrencyInfo> methodConcurrencyInfos) throws OpenEJBException {
        if (deploymentInfo.isBeanManagedConcurrency()) {
            return;
        }
        methodConcurrencyInfos = MethodConcurrencyBuilder.normalize(methodConcurrencyInfos);
        Map<Method, MethodAttributeInfo> attributes = MethodInfoUtil.resolveAttributes(methodConcurrencyInfos, deploymentInfo);
        Logger log = Logger.getInstance(LogCategory.OPENEJB_STARTUP.createChild("attributes"), MethodConcurrencyBuilder.class);
        if (log.isDebugEnabled()) {
            for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                Method method = entry.getKey();
                MethodConcurrencyInfo value = (MethodConcurrencyInfo)entry.getValue();
                log.debug("Concurrency Attribute: " + method + " -- " + MethodInfoUtil.toString(value));
            }
        }
        for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
            MethodConcurrencyInfo value = (MethodConcurrencyInfo)entry.getValue();
            deploymentInfo.setMethodConcurrencyAttribute(entry.getKey(), value.concurrencyAttribute);
        }
    }

    public static List<MethodConcurrencyInfo> normalize(List<MethodConcurrencyInfo> infos) {
        ArrayList<MethodConcurrencyInfo> normalized = new ArrayList<MethodConcurrencyInfo>();
        for (MethodConcurrencyInfo oldInfo : infos) {
            for (MethodInfo methodInfo : oldInfo.methods) {
                MethodConcurrencyInfo newInfo = new MethodConcurrencyInfo();
                newInfo.description = oldInfo.description;
                newInfo.methods.add(methodInfo);
                newInfo.concurrencyAttribute = oldInfo.concurrencyAttribute;
                normalized.add(newInfo);
            }
        }
        Collections.reverse(normalized);
        Collections.sort(normalized, new MethodConcurrencyComparator());
        return normalized;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodConcurrencyComparator
    extends MethodInfoUtil.BaseComparator<MethodConcurrencyInfo> {
        @Override
        public int compare(MethodConcurrencyInfo a, MethodConcurrencyInfo b) {
            return this.compare((MethodInfo)a.methods.get(0), (MethodInfo)b.methods.get(0));
        }
    }
}

