/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.Vendor;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.BmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.HandlerChainInfo;
import org.apache.openejb.assembler.classic.HandlerInfo;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.ManagedContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.SingletonSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AnnotationDeployer;
import org.apache.openejb.config.AppInfoBuilder;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ApplyOpenejbJar;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.ClearEmptyMappedName;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.CmpJpaConversion;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DebuggableVmHackery;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.GeneratedClientModules;
import org.apache.openejb.config.GeronimoMappedName;
import org.apache.openejb.config.InitEjbDeployments;
import org.apache.openejb.config.MappedNameBuilder;
import org.apache.openejb.config.NoSuchProviderException;
import org.apache.openejb.config.OpenEjb2Conversion;
import org.apache.openejb.config.OutputGeneratedDescriptors;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RemoveWebServices;
import org.apache.openejb.config.Service;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.SunConversion;
import org.apache.openejb.config.ValidateModules;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WlsConversion;
import org.apache.openejb.config.WsDeployer;
import org.apache.openejb.config.sys.AbstractService;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.TransactionManager;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChain;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFactory
implements OpenEjbConfigurationFactory {
    static final String CONFIGURATION_PROPERTY = "openejb.configuration";
    static final String CONF_FILE_PROPERTY = "openejb.conf.file";
    private static final String DEBUGGABLE_VM_HACKERY_PROPERTY = "openejb.debuggable-vm-hackery";
    private static final String DUCT_TAPE_PROPERTY = "duct tape";
    protected static final String VALIDATION_SKIP_PROPERTY = "openejb.validation.skip";
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ConfigurationFactory.class);
    private static final Messages messages = new Messages(ConfigurationFactory.class);
    private String configLocation;
    private OpenEjbConfiguration sys;
    private Openejb openejb;
    private DynamicDeployer deployer;
    private final DeploymentLoader deploymentLoader;
    private final boolean offline;
    public static final String CLASSPATH_AS_EAR = "openejb.deployments.classpath.ear";
    static final String WEBSERVICES_ENABLED = "openejb.webservices.enabled";
    private static final Map<Class<? extends ServiceInfo>, DefaultService> defaultProviders = new HashMap<Class<? extends ServiceInfo>, DefaultService>();
    private static final Map<Class<? extends ServiceInfo>, Class<? extends Service>> types = new HashMap<Class<? extends ServiceInfo>, Class<? extends Service>>();
    static Map<String, Class<? extends ContainerInfo>> containerTypes;

    public ConfigurationFactory() {
        this(false);
    }

    public ConfigurationFactory(boolean offline) {
        this(offline, (DynamicDeployer)null);
    }

    public ConfigurationFactory(boolean offline, DynamicDeployer preAutoConfigDeployer) {
        this.offline = offline;
        this.deploymentLoader = new DeploymentLoader();
        Options options = SystemInstance.get().getOptions();
        Chain chain = new Chain();
        chain.add(new GeneratedClientModules.Add());
        chain.add(new ReadDescriptors());
        chain.add(new AnnotationDeployer());
        chain.add(new GeneratedClientModules.Prune());
        chain.add(new ClearEmptyMappedName());
        if (!options.get(VALIDATION_SKIP_PROPERTY, false)) {
            chain.add(new ValidateModules());
        } else {
            DeploymentLoader.logger.info("validationDisabled", VALIDATION_SKIP_PROPERTY);
        }
        chain.add(new InitEjbDeployments());
        if (options.get(DEBUGGABLE_VM_HACKERY_PROPERTY, false)) {
            chain.add(new DebuggableVmHackery());
        }
        if (options.get(WEBSERVICES_ENABLED, true)) {
            chain.add(new WsDeployer());
        } else {
            chain.add(new RemoveWebServices());
        }
        chain.add(new CmpJpaConversion());
        Set support = SystemInstance.get().getOptions().getAll("openejb.vendor.config", (Enum[])Vendor.values());
        if (support.contains((Object)Vendor.GERONIMO) || System.getProperty(DUCT_TAPE_PROPERTY) != null) {
            chain.add(new OpenEjb2Conversion());
        }
        if (support.contains((Object)Vendor.GLASSFISH)) {
            chain.add(new SunConversion());
        }
        if (support.contains((Object)Vendor.WEBLOGIC)) {
            chain.add(new WlsConversion());
        }
        if (System.getProperty(DUCT_TAPE_PROPERTY) != null) {
            chain.add(new GeronimoMappedName());
        }
        if (null != preAutoConfigDeployer) {
            chain.add(preAutoConfigDeployer);
        }
        if (offline) {
            AutoConfig autoConfig = new AutoConfig(this);
            autoConfig.autoCreateResources(false);
            autoConfig.autoCreateContainers(false);
            chain.add(autoConfig);
        } else {
            chain.add(new AutoConfig(this));
        }
        chain.add(new ApplyOpenejbJar());
        chain.add(new MappedNameBuilder());
        chain.add(new OutputGeneratedDescriptors());
        this.deployer = chain;
    }

    public ConfigurationFactory(boolean offline, OpenEjbConfiguration configuration) {
        this(offline, null, configuration);
    }

    public ConfigurationFactory(boolean offline, DynamicDeployer preAutoConfigDeployer, OpenEjbConfiguration configuration) {
        this(offline, preAutoConfigDeployer);
        this.sys = configuration;
    }

    public static List<HandlerChainInfo> toHandlerChainInfo(HandlerChains chains) {
        ArrayList<HandlerChainInfo> handlerChains = new ArrayList<HandlerChainInfo>();
        if (chains == null) {
            return handlerChains;
        }
        for (HandlerChain handlerChain : chains.getHandlerChain()) {
            HandlerChainInfo handlerChainInfo = new HandlerChainInfo();
            handlerChainInfo.serviceNamePattern = handlerChain.getServiceNamePattern();
            handlerChainInfo.portNamePattern = handlerChain.getPortNamePattern();
            handlerChainInfo.protocolBindings.addAll(handlerChain.getProtocolBindings());
            for (Handler handler : handlerChain.getHandler()) {
                HandlerInfo handlerInfo = new HandlerInfo();
                handlerInfo.handlerName = handler.getHandlerName();
                handlerInfo.handlerClass = handler.getHandlerClass();
                handlerInfo.soapHeaders.addAll(handler.getSoapHeader());
                handlerInfo.soapRoles.addAll(handler.getSoapRole());
                for (ParamValue param : handler.getInitParam()) {
                    handlerInfo.initParams.setProperty(param.getParamName(), param.getParamValue());
                }
                handlerChainInfo.handlers.add(handlerInfo);
            }
            handlerChains.add(handlerChainInfo);
        }
        return handlerChains;
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.configLocation = props.getProperty(CONF_FILE_PROPERTY);
        if (this.configLocation == null) {
            this.configLocation = props.getProperty(CONFIGURATION_PROPERTY);
        }
        this.configLocation = ConfigUtils.searchForConfiguration(this.configLocation, props);
        if (this.configLocation != null) {
            props.setProperty(CONFIGURATION_PROPERTY, this.configLocation);
        }
    }

    protected void install(ContainerInfo serviceInfo) throws OpenEJBException {
        if (this.sys != null) {
            this.sys.containerSystem.containers.add(serviceInfo);
        } else if (!this.offline) {
            Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
            assembler.createContainer(serviceInfo);
        }
    }

    protected void install(ResourceInfo serviceInfo) throws OpenEJBException {
        if (this.sys != null) {
            this.sys.facilities.resources.add(serviceInfo);
        } else if (!this.offline) {
            Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
            assembler.createResource(serviceInfo);
        }
    }

    @Override
    public OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        AppInfo appInfo;
        if (this.sys != null) {
            return this.sys;
        }
        this.openejb = this.configLocation != null ? JaxbOpenejb.readConfig(this.configLocation) : JaxbOpenejb.createOpenejb();
        this.loadPropertiesDeclaredConfiguration(this.openejb);
        this.sys = new OpenEjbConfiguration();
        this.sys.containerSystem = new ContainerSystemInfo();
        this.sys.facilities = new FacilitiesInfo();
        for (JndiProvider provider : this.openejb.getJndiProvider()) {
            JndiContextInfo info = this.configureService(provider, JndiContextInfo.class);
            this.sys.facilities.remoteJndiContexts.add(info);
        }
        this.sys.facilities.securityService = this.configureService(this.openejb.getSecurityService(), SecurityServiceInfo.class);
        this.sys.facilities.transactionService = this.configureService(this.openejb.getTransactionManager(), TransactionServiceInfo.class);
        ArrayList<ResourceInfo> resources = new ArrayList<ResourceInfo>();
        for (Resource resource : this.openejb.getResource()) {
            ResourceInfo resourceInfo = this.configureService(resource, ResourceInfo.class);
            resources.add(resourceInfo);
        }
        Collections.sort(resources, new ResourceInfoComparator(resources));
        this.sys.facilities.resources.addAll(resources);
        if (this.openejb.getProxyFactory() != null) {
            this.sys.facilities.intraVmServer = this.configureService(this.openejb.getProxyFactory(), ProxyFactoryInfo.class);
        }
        for (Container declaration : this.openejb.getContainer()) {
            ContainerInfo info = this.createContainerInfo(declaration);
            this.sys.containerSystem.containers.add(info);
        }
        List<Deployments> deployments = this.openejb.getDeployments();
        deployments = new ArrayList<Deployments>(deployments);
        FileUtils base = SystemInstance.get().getBase();
        ArrayList<String> declaredApps = new ArrayList<String>(deployments.size());
        try {
            for (Deployments deployment : deployments) {
                DeploymentsResolver.loadFrom(deployment, base, declaredApps);
            }
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (String pathname : declaredApps) {
            try {
                File jarFile = new File(pathname);
                appInfo = this.configureApplication(jarFile);
                this.sys.containerSystem.applications.add(appInfo);
            }
            catch (OpenEJBException alreadyHandled) {}
        }
        if (SystemInstance.get().getOptions().get("openejb.deployments.classpath", true)) {
            ArrayList<String> classpathApps = new ArrayList<String>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            DeploymentsResolver.loadFromClasspath(base, classpathApps, classLoader);
            ArrayList<File> jarFiles = new ArrayList<File>();
            for (String path : classpathApps) {
                if (declaredApps.contains(path)) continue;
                jarFiles.add(new File(path));
            }
            try {
                if (SystemInstance.get().getOptions().get(CLASSPATH_AS_EAR, true)) {
                    appInfo = this.configureApplication(classLoader, "classpath.ear", jarFiles);
                    this.sys.containerSystem.applications.add(appInfo);
                } else {
                    for (File jarFile : jarFiles) {
                        AppInfo appInfo2 = this.configureApplication(jarFile);
                        this.sys.containerSystem.applications.add(appInfo2);
                    }
                }
            }
            catch (OpenEJBException alreadyHandled) {
                // empty catch block
            }
        }
        OpenEjbConfiguration finished = this.sys;
        this.sys = null;
        this.openejb = null;
        return finished;
    }

    public ContainerInfo createContainerInfo(Container container) throws OpenEJBException {
        Class<? extends ContainerInfo> infoClass = ConfigurationFactory.getContainerInfoType(container.getType());
        if (infoClass == null) {
            throw new OpenEJBException(messages.format("unrecognizedContainerType", container.getType()));
        }
        ContainerInfo info = this.configureService(container, infoClass);
        return info;
    }

    private void loadPropertiesDeclaredConfiguration(Openejb openejb) {
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            Object o = entry.getValue();
            if (!(o instanceof String) || !((String)o).startsWith("new://")) continue;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                Object service = this.toConfigDeclaration(name, value);
                openejb.add(service);
            }
            catch (URISyntaxException e) {
                logger.error("Error declaring service '" + name + "'. Invalid Service URI '" + value + "'.  java.net.URISyntaxException: " + e.getMessage());
            }
            catch (OpenEJBException e) {
                logger.error(e.getMessage());
            }
        }
    }

    protected Object toConfigDeclaration(String name, String value) throws URISyntaxException, OpenEJBException {
        value = value.replaceFirst("(provider=[^#=&]+)#", "$1%23");
        URI uri = new URI(value);
        Object service = this.toConfigDeclaration(name, uri);
        return service;
    }

    public Object toConfigDeclaration(String id, URI uri) throws OpenEJBException {
        String serviceType = null;
        try {
            serviceType = uri.getHost();
            Object object = null;
            try {
                object = JaxbOpenejb.create(serviceType);
            }
            catch (Exception e) {
                throw new OpenEJBException("Invalid URI '" + uri + "'. " + e.getMessage());
            }
            Map<String, String> map = null;
            try {
                map = URISupport.parseParamters(uri);
            }
            catch (URISyntaxException e) {
                throw new OpenEJBException("Unable to parse URI parameters '" + uri + "'. URISyntaxException: " + e.getMessage());
            }
            if (object instanceof AbstractService) {
                AbstractService service = object;
                service.setId(id);
                service.setType(map.remove("type"));
                service.setProvider(map.remove("provider"));
                service.getProperties().putAll(map);
            } else if (object instanceof Deployments) {
                Deployments deployments = object;
                deployments.setDir(map.remove("dir"));
                deployments.setJar(map.remove("jar"));
                String cp = map.remove("classpath");
                if (cp != null) {
                    String[] paths = cp.split(File.pathSeparator);
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String path : paths) {
                        urls.add(new File(path).toURI().normalize().toURL());
                    }
                    deployments.setClasspath(new URLClassLoader(urls.toArray(new URL[0])));
                }
            }
            return object;
        }
        catch (Exception e) {
            throw new OpenEJBException("Error declaring service '" + id + "'. Unable to create Service definition from URI '" + uri.toString() + "'", e);
        }
    }

    public AppInfo configureApplication(File jarFile) throws OpenEJBException {
        AppInfo appInfo;
        logger.debug("Beginning load: " + jarFile.getAbsolutePath());
        try {
            AppModule appModule = this.deploymentLoader.load(jarFile);
            appInfo = this.configureApplication(appModule);
        }
        catch (ValidationFailedException e) {
            logger.warning("configureApplication.loadFailed", jarFile.getAbsolutePath(), e.getMessage());
            throw e;
        }
        catch (OpenEJBException e) {
            logger.warning("configureApplication.loadFailed", e, jarFile.getAbsolutePath(), e.getMessage());
            throw e;
        }
        return appInfo;
    }

    public AppInfo configureApplication(ClassLoader classLoader, String id, List<File> jarFiles) throws OpenEJBException {
        AppInfo appInfo;
        AppModule collection = new AppModule(classLoader, id);
        Map<String, Object> altDDs = collection.getAltDDs();
        for (File jarFile : jarFiles) {
            logger.info("Beginning load: " + jarFile.getAbsolutePath());
            try {
                AppModule module = this.deploymentLoader.load(jarFile);
                collection.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                collection.getClientModules().addAll(module.getClientModules());
                collection.getEjbModules().addAll(module.getEjbModules());
                collection.getPersistenceModules().addAll(module.getPersistenceModules());
                collection.getResourceModules().addAll(module.getResourceModules());
                collection.getWebModules().addAll(module.getWebModules());
                collection.getWatchedResources().addAll(module.getWatchedResources());
                for (Map.Entry<String, Object> entry : module.getAltDDs().entrySet()) {
                    Object values;
                    Object existingValue = altDDs.get(entry.getKey());
                    if (existingValue == null) {
                        altDDs.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Collection) {
                        if (!(existingValue instanceof Collection)) continue;
                        values = (Collection)existingValue;
                        values.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Map) || !(existingValue instanceof Map)) continue;
                    values = (Map)existingValue;
                    values.putAll((Map)entry.getValue());
                }
            }
            catch (ValidationFailedException e) {
                logger.warning("configureApplication.loadFailed", jarFile.getAbsolutePath(), e.getMessage());
                throw e;
            }
            catch (OpenEJBException e) {
                logger.warning("configureApplication.loadFailed", e, jarFile.getAbsolutePath(), e.getMessage());
                throw e;
            }
        }
        try {
            appInfo = this.configureApplication(collection);
        }
        catch (ValidationFailedException e) {
            logger.warning("configureApplication.loadFailed", id, e.getMessage());
            throw e;
        }
        catch (OpenEJBException e) {
            logger.warning("configureApplication.loadFailed", e, id, e.getMessage());
            throw e;
        }
        return appInfo;
    }

    public EjbJarInfo configureApplication(EjbJar ejbJar) throws OpenEJBException {
        EjbModule ejbModule = new EjbModule(ejbJar);
        return this.configureApplication(ejbModule);
    }

    public EjbJarInfo configureApplication(EjbModule ejbModule) throws OpenEJBException {
        AppModule appModule = new AppModule(ejbModule.getClassLoader(), ejbModule.getJarLocation());
        appModule.getEjbModules().add(ejbModule);
        AppInfo appInfo = this.configureApplication(appModule);
        return appInfo.ejbJars.get(0);
    }

    public ClientInfo configureApplication(ClientModule clientModule) throws OpenEJBException {
        AppModule appModule = new AppModule(clientModule.getClassLoader(), clientModule.getJarLocation());
        appModule.getClientModules().add(clientModule);
        AppInfo appInfo = this.configureApplication(appModule);
        return appInfo.clients.get(0);
    }

    public ConnectorInfo configureApplication(ConnectorModule connectorModule) throws OpenEJBException {
        AppModule appModule = new AppModule(connectorModule.getClassLoader(), connectorModule.getJarLocation());
        appModule.getResourceModules().add(connectorModule);
        AppInfo appInfo = this.configureApplication(appModule);
        return appInfo.connectors.get(0);
    }

    public WebAppInfo configureApplication(WebModule webModule) throws OpenEJBException {
        AppModule appModule = new AppModule(webModule.getClassLoader(), webModule.getJarLocation());
        appModule.getWebModules().add(webModule);
        AppInfo appInfo = this.configureApplication(appModule);
        return appInfo.webApps.get(0);
    }

    public AppInfo configureApplication(AppModule appModule) throws OpenEJBException {
        logger.info("config.configApp", appModule.getJarLocation());
        this.deployer.deploy(appModule);
        AppInfoBuilder appInfoBuilder = new AppInfoBuilder(this);
        return appInfoBuilder.build(appModule);
    }

    public <T extends ServiceInfo> T configureService(Class<? extends T> type) throws OpenEJBException {
        return this.configureService((Service)null, type);
    }

    private <T extends ServiceInfo> Service getDefaultService(Class<? extends T> type) throws OpenEJBException {
        Service service;
        DefaultService defaultService = defaultProviders.get(type);
        if (defaultService == null) {
            return null;
        }
        try {
            service = (Service)JaxbOpenejb.create(defaultService.type);
            service.setType(defaultService.id);
        }
        catch (Exception e) {
            String name = defaultService == null || defaultService.type == null ? "null" : defaultService.type.getName();
            throw new OpenEJBException("Cannot instantiate class " + name, e);
        }
        return service;
    }

    public <T extends ServiceInfo> T configureService(Service service, Class<? extends T> infoType) throws OpenEJBException {
        try {
            ServiceInfo info;
            if (infoType == null) {
                throw new NullPointerException("type");
            }
            if (service == null && (service = this.getDefaultService(infoType)) == null) {
                throw new OpenEJBException(messages.format("configureService.noDefaultService", infoType.getName()));
            }
            String providerType = service.getClass().getSimpleName();
            ServiceProvider provider = this.resolveServiceProvider(service, infoType);
            if (provider == null) {
                List<ServiceProvider> providers = ServiceUtils.getServiceProvidersByServiceType(providerType);
                StringBuilder sb = new StringBuilder();
                ArrayList<String> types = new ArrayList<String>();
                for (ServiceProvider p : providers) {
                    for (String type : p.getTypes()) {
                        if (types.contains(type)) continue;
                        types.add(type);
                        sb.append(System.getProperty("line.separator"));
                        sb.append("  <").append(p.getService());
                        sb.append(" id=\"").append(service.getId()).append('\"');
                        sb.append(" type=\"").append(type).append("\"/>");
                    }
                }
                String noProviderMessage = messages.format("configureService.noProviderForService", providerType, service.getId(), service.getType(), service.getProvider(), sb.toString());
                throw new NoSuchProviderException(noProviderMessage);
            }
            if (service.getId() == null) {
                service.setId(provider.getId());
            }
            Properties overrides = ConfigurationFactory.trim(ConfigurationFactory.getSystemProperties(service.getId(), provider.getService()));
            ConfigurationFactory.trim(service.getProperties());
            ConfigurationFactory.trim(provider.getProperties());
            logger.info("configureService.configuring", service.getId(), provider.getService(), provider.getId());
            if (logger.isDebugEnabled()) {
                Object value;
                Object key;
                for (Map.Entry<Object, Object> entry : service.getProperties().entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key instanceof String && "password".equalsIgnoreCase((String)key)) {
                        value = "<hidden>";
                    }
                    logger.debug("[" + key + "=" + value + "]");
                }
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key instanceof String && "password".equalsIgnoreCase((String)key)) {
                        value = "<hidden>";
                    }
                    logger.debug("Override [" + key + "=" + value + "]");
                }
            }
            SuperProperties props = new SuperProperties();
            ((Properties)props).putAll((Map<?, ?>)provider.getProperties());
            ((Properties)props).putAll((Map<?, ?>)service.getProperties());
            ((Properties)props).putAll((Map<?, ?>)overrides);
            if (providerType != null && !provider.getService().equals(providerType)) {
                throw new OpenEJBException(messages.format("configureService.wrongProviderType", service.getId(), providerType));
            }
            try {
                info = (ServiceInfo)infoType.newInstance();
            }
            catch (Exception e) {
                throw new OpenEJBException(messages.format("configureService.cannotInstantiateClass", infoType.getName()), e);
            }
            info.service = provider.getService();
            info.types.addAll(provider.getTypes());
            info.description = provider.getDescription();
            info.displayName = provider.getDisplayName();
            info.className = provider.getClassName();
            info.factoryMethod = provider.getFactoryName();
            info.id = service.getId();
            info.properties = props;
            info.constructorArgs.addAll(this.parseConstructorArgs(provider));
            this.specialProcessing(info);
            return (T)info;
        }
        catch (NoSuchProviderException e) {
            String message = logger.fatal("configureService.failed", e, service.getId());
            throw new OpenEJBException(message + ": " + e.getMessage());
        }
        catch (Throwable e) {
            String message = logger.fatal("configureService.failed", e, service.getId());
            throw new OpenEJBException(message, e);
        }
    }

    private static Properties trim(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object o = entry.getValue();
            if (!(o instanceof String)) continue;
            String value = (String)o;
            String trimmed = value.trim();
            if (value.length() == trimmed.length()) continue;
            properties.put(entry.getKey(), trimmed);
        }
        return properties;
    }

    private <T extends ServiceInfo> void specialProcessing(T info) {
        T serviceInfo = info;
        TopicOrQueueDefaults.process(serviceInfo);
    }

    private ServiceProvider resolveServiceProvider(Service service, Class infoType) throws OpenEJBException {
        Service defaultService;
        if (service.getProvider() != null) {
            return ServiceUtils.getServiceProvider(service.getProvider());
        }
        if (service.getType() != null) {
            return ServiceUtils.getServiceProviderByType(service.getClass().getSimpleName(), service.getType());
        }
        if (service.getId() != null) {
            try {
                return ServiceUtils.getServiceProvider(service.getId());
            }
            catch (NoSuchProviderException e) {
                // empty catch block
            }
        }
        if (infoType != null && (defaultService = this.getDefaultService(infoType)) != null) {
            return this.resolveServiceProvider(defaultService, null);
        }
        return null;
    }

    public <T extends ServiceInfo> T configureService(String id, Class<? extends T> type) throws OpenEJBException {
        return this.configureService(type, id, null, id, null);
    }

    public <T extends ServiceInfo> T configureService(Class<? extends T> type, String serviceId, Properties declaredProperties, String providerId, String serviceType) throws OpenEJBException {
        Service service;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class<? extends Service> serviceClass = types.get(type);
        if (serviceClass == null) {
            throw new OpenEJBException("Unsupported service info type: " + type.getName());
        }
        try {
            service = serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new OpenEJBException(messages.format("configureService.cannotInstantiateClass", serviceClass.getName()), e);
        }
        service.setId(serviceId);
        service.setProvider(providerId);
        if (declaredProperties != null) {
            service.getProperties().putAll((Map<?, ?>)declaredProperties);
        }
        return this.configureService(service, type);
    }

    protected static Properties getSystemProperties(String serviceId, String serviceType) {
        String fullPrefix = serviceType.toUpperCase() + "." + serviceId + ".";
        String fullPrefix2 = serviceType.toUpperCase() + "." + serviceId + "|";
        String shortPrefix = serviceId + ".";
        String shortPrefix2 = serviceId + "|";
        Properties serviceProperties = new Properties();
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        block0: for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String name = (String)entry.getKey();
            for (String prefix : Arrays.asList(fullPrefix, fullPrefix2, shortPrefix, shortPrefix2)) {
                if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                name = name.substring(prefix.length());
                String value = entry.getValue().toString();
                serviceProperties.setProperty(name, value);
                continue block0;
            }
        }
        return serviceProperties;
    }

    protected static Class<? extends ContainerInfo> getContainerInfoType(String ctype) {
        return containerTypes.get(ctype);
    }

    private List<String> parseConstructorArgs(ServiceProvider service) {
        String constructor = service.getConstructor();
        if (constructor == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(constructor.split("[ ,]+"));
    }

    protected List<String> getResourceIds() {
        return this.getResourceIds(null);
    }

    protected List<String> getResourceIds(String type) {
        return this.getResourceIds(type, null);
    }

    protected List<String> getResourceIds(String type, Properties required) {
        OpenEjbConfiguration runningConfig;
        ArrayList<String> resourceIds = new ArrayList<String>();
        if (required == null) {
            required = new Properties();
        }
        if ((runningConfig = this.getRunningConfig()) != null) {
            for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                if (!this.isResourceType(resourceInfo.service, resourceInfo.types, type) || !ServiceUtils.implies(required, resourceInfo.properties)) continue;
                resourceIds.add(resourceInfo.id);
            }
        }
        if (this.sys != null) {
            for (ResourceInfo resourceInfo : this.sys.facilities.resources) {
                if (!this.isResourceType(resourceInfo.service, resourceInfo.types, type) || !ServiceUtils.implies(required, resourceInfo.properties)) continue;
                resourceIds.add(resourceInfo.id);
            }
            if (this.openejb != null) {
                for (Resource resource : this.openejb.getResource()) {
                    ArrayList<String> types = new ArrayList<String>();
                    if (resource.getType() != null) {
                        types.add(resource.getType());
                    }
                    if (!this.isResourceType("Resource", types, type) || !ServiceUtils.implies(required, resource.getProperties())) continue;
                    resourceIds.add(resource.getId());
                }
            }
        }
        return resourceIds;
    }

    protected ResourceInfo getResourceInfo(String id) {
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                if (resourceInfo.id != id) continue;
                return resourceInfo;
            }
        }
        if (this.sys != null) {
            for (ResourceInfo resourceInfo : this.sys.facilities.resources) {
                if (resourceInfo.id != id) continue;
                return resourceInfo;
            }
        }
        return null;
    }

    private boolean isResourceType(String service, List<String> types, String type) {
        if (type == null) {
            return true;
        }
        if (service == null) {
            return false;
        }
        return types.contains(type);
    }

    protected List<String> getContainerIds() {
        ArrayList<String> containerIds = new ArrayList<String>();
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ContainerInfo containerInfo : runningConfig.containerSystem.containers) {
                containerIds.add(containerInfo.id);
            }
        }
        if (this.sys != null) {
            for (ContainerInfo containerInfo : this.sys.containerSystem.containers) {
                containerIds.add(containerInfo.id);
            }
            if (this.openejb != null) {
                for (Container container : this.openejb.getContainer()) {
                    containerIds.add(container.getId());
                }
            }
        }
        return containerIds;
    }

    protected List<ContainerInfo> getContainerInfos() {
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ContainerInfo containerInfo : runningConfig.containerSystem.containers) {
                containers.add(containerInfo);
            }
        }
        if (this.sys != null) {
            for (ContainerInfo containerInfo : this.sys.containerSystem.containers) {
                containers.add(containerInfo);
            }
        }
        return containers;
    }

    private OpenEjbConfiguration getRunningConfig() {
        return (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
    }

    static {
        defaultProviders.put(MdbContainerInfo.class, new DefaultService("MESSAGE", Container.class));
        defaultProviders.put(ManagedContainerInfo.class, new DefaultService("MANAGED", Container.class));
        defaultProviders.put(StatefulSessionContainerInfo.class, new DefaultService("STATEFUL", Container.class));
        defaultProviders.put(StatelessSessionContainerInfo.class, new DefaultService("STATELESS", Container.class));
        defaultProviders.put(SingletonSessionContainerInfo.class, new DefaultService("SINGLETON", Container.class));
        defaultProviders.put(CmpEntityContainerInfo.class, new DefaultService("CMP_ENTITY", Container.class));
        defaultProviders.put(BmpEntityContainerInfo.class, new DefaultService("BMP_ENTITY", Container.class));
        defaultProviders.put(SecurityServiceInfo.class, new DefaultService("SecurityService", SecurityService.class));
        defaultProviders.put(TransactionServiceInfo.class, new DefaultService("TransactionManager", TransactionManager.class));
        defaultProviders.put(ConnectionManagerInfo.class, new DefaultService("ConnectionManager", ConnectionManager.class));
        defaultProviders.put(ProxyFactoryInfo.class, new DefaultService("ProxyFactory", ProxyFactory.class));
        for (Map.Entry<Class<? extends ServiceInfo>, DefaultService> entry : defaultProviders.entrySet()) {
            types.put(entry.getKey(), entry.getValue().type);
        }
        types.put(ResourceInfo.class, Resource.class);
        containerTypes = new HashMap<String, Class<? extends ContainerInfo>>();
        containerTypes.put("SINGLETON", SingletonSessionContainerInfo.class);
        containerTypes.put("MANAGED", ManagedContainerInfo.class);
        containerTypes.put("STATELESS", StatelessSessionContainerInfo.class);
        containerTypes.put("STATEFUL", StatefulSessionContainerInfo.class);
        containerTypes.put("BMP_ENTITY", BmpEntityContainerInfo.class);
        containerTypes.put("CMP_ENTITY", CmpEntityContainerInfo.class);
        containerTypes.put("MESSAGE", MdbContainerInfo.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceInfoComparator
    implements Comparator<ResourceInfo> {
        private final List<String> ids = new ArrayList<String>();
        private static final int EQUAL = 0;
        private static final int GREATER = 1;
        private static final int LESS = -1;

        public ResourceInfoComparator(List<ResourceInfo> resources) {
            for (ResourceInfo info : resources) {
                this.ids.add(info.id);
            }
        }

        @Override
        public int compare(ResourceInfo a, ResourceInfo b) {
            String refA = this.getReference(a);
            String refB = this.getReference(b);
            if (refA == null && refB == null || refA != null && refA.equals(refB)) {
                return 0;
            }
            if (a.id.equals(refB)) {
                return -1;
            }
            if (b.id.equals(refA)) {
                return 1;
            }
            if (refA != null && refB == null) {
                return 1;
            }
            if (refB != null && refA == null) {
                return -1;
            }
            return 0;
        }

        public int hasReference(ResourceInfo info) {
            for (Object value : info.properties.values()) {
                if (!this.ids.contains(value)) continue;
                return 1;
            }
            return 0;
        }

        public String getReference(ResourceInfo info) {
            for (Object value : info.properties.values()) {
                if (!this.ids.contains(value = ((String)value).trim())) continue;
                return (String)value;
            }
            return null;
        }
    }

    private static class TopicOrQueueDefaults {
        private TopicOrQueueDefaults() {
        }

        public static void process(ServiceInfo provider) {
            if (!provider.service.equals("Resource")) {
                return;
            }
            if (!provider.types.contains("Topic") && !provider.types.contains("Queue")) {
                return;
            }
            if (!provider.className.matches("org.apache.activemq.command.ActiveMQ(Topic|Queue)")) {
                return;
            }
            String dest = provider.properties.getProperty("destination");
            if (dest == null || dest.length() == 0) {
                provider.properties.setProperty("destination", provider.id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultService {
        private final Class<? extends Service> type;
        private final String id;

        public DefaultService(String id, Class<? extends Service> type) {
            this.id = id;
            this.type = type;
        }
    }

    public static class Chain
    implements DynamicDeployer {
        private final List<DynamicDeployer> chain = new ArrayList<DynamicDeployer>();

        public boolean add(DynamicDeployer o) {
            return this.chain.add(o);
        }

        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (DynamicDeployer deployer : this.chain) {
                appModule = deployer.deploy(appModule);
            }
            return appModule;
        }
    }
}

