/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.Handle;
import javax.ejb.MessageDrivenBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.naming.Context;
import javax.persistence.EntityManagerFactory;
import org.apache.openejb.BeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.Injection;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.DeploymentContext;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.MethodSchedule;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreDeploymentInfo
implements DeploymentInfo {
    private boolean destroyed;
    private Class homeInterface;
    private Class remoteInterface;
    private Class localHomeInterface;
    private Class localInterface;
    private Class beanClass;
    private Class pkClass;
    private final List<Class> businessLocals = new ArrayList<Class>();
    private final List<Class> businessRemotes = new ArrayList<Class>();
    private Class mdbInterface;
    private Class serviceEndpointInterface;
    private final List<Method> aroundInvoke = new ArrayList<Method>();
    private final List<Method> postConstruct = new ArrayList<Method>();
    private final List<Method> preDestroy = new ArrayList<Method>();
    private final List<Method> postActivate = new ArrayList<Method>();
    private final List<Method> prePassivate = new ArrayList<Method>();
    private final List<Method> removeMethods = new ArrayList<Method>();
    private final Set<String> dependsOn = new LinkedHashSet<String>();
    private Method ejbTimeout;
    private EjbTimerService ejbTimerService;
    private boolean isBeanManagedTransaction;
    private boolean isBeanManagedConcurrency;
    private boolean isReentrant;
    private Container container;
    private EJBHome ejbHomeRef;
    private EJBLocalHome ejbLocalHomeRef;
    private String destinationId;
    private final Map<Class, Object> data = new HashMap<Class, Object>();
    private final Properties properties = new Properties();
    private String ejbName;
    private String moduleId;
    private String runAs;
    private Object containerData;
    private final DeploymentContext context;
    private Method createMethod = null;
    private final Map<Method, Method> postCreateMethodMap = new HashMap<Method, Method>();
    private final BeanType componentType;
    private final Map<Method, Collection<String>> methodPermissions = new HashMap<Method, Collection<String>>();
    private final Map<Method, Byte> methodConcurrencyAttributes = new HashMap<Method, Byte>();
    private final Map<Method, TransactionType> methodTransactionType = new HashMap<Method, TransactionType>();
    private TransactionPolicyFactory transactionPolicyFactory;
    private final List<MethodSchedule> methodSchedules = new ArrayList<MethodSchedule>();
    private final Map<Method, List<InterceptorData>> methodInterceptors = new HashMap<Method, List<InterceptorData>>();
    private final List<InterceptorData> callbackInterceptors = new ArrayList<InterceptorData>();
    private final Set<InterceptorData> instanceScopedInterceptors = new HashSet<InterceptorData>();
    private final List<InterceptorInstance> systemInterceptors = new ArrayList<InterceptorInstance>();
    private final Map<Method, Method> methodMap = new HashMap<Method, Method>();
    private final Map<String, String> securityRoleReferenceMap = new HashMap<String, String>();
    private String jarPath;
    private final Map<String, String> activationProperties = new HashMap<String, String>();
    private final List<Injection> injections = new ArrayList<Injection>();
    private Index<EntityManagerFactory, Map> extendedEntityManagerFactories;
    private final Map<Class, InterfaceType> interfaces = new HashMap<Class, InterfaceType>();
    private final Map<Class, ExceptionType> exceptions = new HashMap<Class, ExceptionType>();
    private boolean loadOnStartup;
    private boolean localbean;
    private final Map<Method, Boolean> removeExceptionPolicy = new HashMap<Method, Boolean>();
    private boolean cmp2;
    private KeyGenerator keyGenerator;
    private String primaryKeyField;
    private String[] cmrFields;
    private Class cmpImplClass;
    private String abstractSchemaName;
    private Map<Method, String> queryMethodMap = new HashMap<Method, String>();
    private Set<String> remoteQueryResults = new TreeSet<String>();

    @Override
    public Class getInterface(InterfaceType interfaceType) {
        switch (interfaceType) {
            case EJB_HOME: {
                return this.getHomeInterface();
            }
            case EJB_OBJECT: {
                return this.getRemoteInterface();
            }
            case EJB_LOCAL_HOME: {
                return this.getLocalHomeInterface();
            }
            case EJB_LOCAL: {
                return this.getLocalInterface();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterface();
            }
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterface();
            }
            case BUSINESS_REMOTE_HOME: {
                return DeploymentInfo.BusinessRemoteHome.class;
            }
            case BUSINESS_LOCAL_HOME: {
                return DeploymentInfo.BusinessLocalHome.class;
            }
            case SERVICE_ENDPOINT: {
                return this.getServiceEndpointInterface();
            }
            case LOCALBEAN: {
                return this.getBeanClass();
            }
            case BUSINESS_LOCALBEAN_HOME: {
                return DeploymentInfo.BusinessLocalBeanHome.class;
            }
        }
        throw new IllegalStateException("Unexpected enum constant: " + (Object)((Object)interfaceType));
    }

    @Override
    public List<Class> getInterfaces(InterfaceType interfaceType) {
        switch (interfaceType) {
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterfaces();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterfaces();
            }
        }
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.getInterface(interfaceType));
        return interfaces;
    }

    @Override
    public InterfaceType getInterfaceType(Class clazz) {
        InterfaceType type = this.interfaces.get(clazz);
        if (type != null) {
            return type;
        }
        if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL_HOME;
        }
        if (EJBLocalObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL;
        }
        if (EJBHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_HOME;
        }
        if (EJBObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_OBJECT;
        }
        return null;
    }

    public CoreDeploymentInfo(DeploymentContext context, Class beanClass, Class homeInterface, Class remoteInterface, Class localHomeInterface, Class localInterface, Class serviceEndpointInterface, List<Class> businessLocals, List<Class> businessRemotes, Class pkClass, BeanType componentType) throws SystemException {
        if (context == null || beanClass == null) {
            throw new NullPointerException("context or beanClass input parameter is null");
        }
        this.context = context;
        this.pkClass = pkClass;
        this.homeInterface = homeInterface;
        this.remoteInterface = remoteInterface;
        this.localInterface = localInterface;
        this.localHomeInterface = localHomeInterface;
        if (businessLocals != null) {
            this.businessLocals.addAll(businessLocals);
        }
        if (businessRemotes != null) {
            this.businessRemotes.addAll(businessRemotes);
        }
        this.remoteInterface = remoteInterface;
        this.beanClass = beanClass;
        this.pkClass = pkClass;
        this.serviceEndpointInterface = serviceEndpointInterface;
        this.componentType = componentType;
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.addInterface(this.getServiceEndpointInterface(), InterfaceType.SERVICE_ENDPOINT);
        this.addInterface(EJBHome.class, InterfaceType.EJB_HOME);
        this.addInterface(EJBObject.class, InterfaceType.EJB_OBJECT);
        this.addInterface(EJBLocalHome.class, InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(EJBLocalObject.class, InterfaceType.EJB_LOCAL);
        this.addInterface(this.getHomeInterface(), InterfaceType.EJB_HOME);
        this.addInterface(this.getRemoteInterface(), InterfaceType.EJB_OBJECT);
        this.addInterface(this.getLocalHomeInterface(), InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(this.getLocalInterface(), InterfaceType.EJB_LOCAL);
        this.addInterface(DeploymentInfo.BusinessRemoteHome.class, InterfaceType.BUSINESS_REMOTE_HOME);
        for (Class businessRemote : this.businessRemotes) {
            this.addInterface(businessRemote, InterfaceType.BUSINESS_REMOTE);
        }
        this.addInterface(DeploymentInfo.BusinessLocalHome.class, InterfaceType.BUSINESS_LOCAL_HOME);
        for (Class businessLocal : this.businessLocals) {
            this.addInterface(businessLocal, InterfaceType.BUSINESS_LOCAL);
        }
    }

    private void addInterface(Class interfce, InterfaceType type) {
        if (interfce == null) {
            return;
        }
        this.interfaces.put(interfce, type);
        for (Class<?> clazz : interfce.getInterfaces()) {
            this.addInterface(clazz, type);
        }
    }

    public void addApplicationException(Class exception, boolean rollback) {
        if (rollback) {
            this.exceptions.put(exception, ExceptionType.APPLICATION_ROLLBACK);
        } else {
            this.exceptions.put(exception, ExceptionType.APPLICATION);
        }
    }

    @Override
    public ExceptionType getExceptionType(Throwable e) {
        if (!(e instanceof Exception)) {
            return ExceptionType.SYSTEM;
        }
        ExceptionType type = this.exceptions.get(e.getClass());
        if (type != null) {
            return type;
        }
        if (e instanceof RuntimeException) {
            return ExceptionType.SYSTEM;
        }
        return ExceptionType.APPLICATION;
    }

    public CoreDeploymentInfo(DeploymentContext context, Class beanClass, Class mdbInterface, Map<String, String> activationProperties) throws SystemException {
        this.context = context;
        this.beanClass = beanClass;
        this.mdbInterface = mdbInterface;
        this.activationProperties.putAll(activationProperties);
        this.componentType = BeanType.MESSAGE_DRIVEN;
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.createMethodMap();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    @Override
    public <T> T get(Class<T> type) {
        return (T)this.data.get(type);
    }

    @Override
    public <T> T set(Class<T> type, T value) {
        return (T)this.data.put(type, value);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public List<Injection> getInjections() {
        return this.injections;
    }

    public Index<EntityManagerFactory, Map> getExtendedEntityManagerFactories() {
        return this.extendedEntityManagerFactories;
    }

    public void setExtendedEntityManagerFactories(Index<EntityManagerFactory, Map> extendedEntityManagerFactories) {
        this.extendedEntityManagerFactories = extendedEntityManagerFactories;
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object containerData) {
        this.containerData = containerData;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public BeanType getComponentType() {
        return this.componentType;
    }

    public byte getConcurrencyAttribute(Method method) {
        Byte byteWrapper = this.methodConcurrencyAttributes.get(method);
        if (byteWrapper == null) {
            Method beanMethod = this.getMatchingBeanMethod(method);
            byteWrapper = this.methodConcurrencyAttributes.get(beanMethod);
        }
        if (byteWrapper == null) {
            return 7;
        }
        return byteWrapper;
    }

    @Override
    public TransactionType getTransactionType(Method method) {
        TransactionType type = this.methodTransactionType.get(method);
        if (type != null) {
            return type;
        }
        if (this.isBeanManagedTransaction) {
            return TransactionType.BeanManaged;
        }
        Method beanMethod = this.getMatchingBeanMethod(method);
        if (beanMethod != null && (type = this.methodTransactionType.get(beanMethod)) != null) {
            return type;
        }
        Logger log = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
        log.debug("The following method doesn't have a transaction policy assigned: " + method);
        type = TransactionType.Required;
        this.methodTransactionType.put(method, type);
        return type;
    }

    @Override
    public TransactionPolicyFactory getTransactionPolicyFactory() {
        return this.transactionPolicyFactory;
    }

    public void setTransactionPolicyFactory(TransactionPolicyFactory transactionPolicyFactory) {
        this.transactionPolicyFactory = transactionPolicyFactory;
    }

    @Override
    public Collection<String> getAuthorizedRoles(Method method) {
        Collection<String> roleSet = this.methodPermissions.get(method);
        if (roleSet == null) {
            return Collections.emptySet();
        }
        return roleSet;
    }

    @Override
    public String[] getAuthorizedRoles(String action) {
        return null;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public Object getDeploymentID() {
        return this.context.getId();
    }

    @Override
    public boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    @Override
    public boolean isBeanManagedConcurrency() {
        return this.isBeanManagedConcurrency;
    }

    @Override
    public Class getHomeInterface() {
        return this.homeInterface;
    }

    @Override
    public Class getRemoteInterface() {
        return this.remoteInterface;
    }

    @Override
    public Class getLocalHomeInterface() {
        return this.localHomeInterface;
    }

    @Override
    public Class getLocalInterface() {
        return this.localInterface;
    }

    @Override
    public Class getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Class getBusinessLocalInterface() {
        return this.businessLocals.size() > 0 ? this.businessLocals.get(0) : null;
    }

    @Override
    public Class getBusinessRemoteInterface() {
        return this.businessRemotes.size() > 0 ? this.businessRemotes.get(0) : null;
    }

    @Override
    public List<Class> getBusinessLocalInterfaces() {
        return this.businessLocals;
    }

    @Override
    public List<Class> getBusinessRemoteInterfaces() {
        return this.businessRemotes;
    }

    @Override
    public Class getMdbInterface() {
        return this.mdbInterface;
    }

    @Override
    public Class getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    @Override
    public Map<String, String> getActivationProperties() {
        return this.activationProperties;
    }

    public void setActivationProperties(Map<String, String> activationProperties) {
        this.activationProperties.clear();
        this.activationProperties.putAll(activationProperties);
    }

    @Override
    public Class getPrimaryKeyClass() {
        return this.pkClass;
    }

    @Override
    public EJBHome getEJBHome() {
        if (this.getHomeInterface() == null) {
            throw new IllegalStateException("This component has no home interface: " + this.getDeploymentID());
        }
        if (this.ejbHomeRef == null) {
            this.ejbHomeRef = (EJBHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_HOME);
        }
        return this.ejbHomeRef;
    }

    @Override
    public EJBLocalHome getEJBLocalHome() {
        if (this.getLocalHomeInterface() == null) {
            throw new IllegalStateException("This component has no local home interface: " + this.getDeploymentID());
        }
        if (this.ejbLocalHomeRef == null) {
            this.ejbLocalHomeRef = (EJBLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_LOCAL_HOME);
        }
        return this.ejbLocalHomeRef;
    }

    @Override
    public DeploymentInfo.BusinessLocalHome getBusinessLocalHome() {
        return this.getBusinessLocalHome(this.getBusinessLocalInterfaces());
    }

    @Override
    public DeploymentInfo.BusinessLocalBeanHome getBusinessLocalBeanHome() {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.beanClass);
        return (DeploymentInfo.BusinessLocalBeanHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCALBEAN_HOME, interfaces);
    }

    @Override
    public DeploymentInfo.BusinessLocalHome getBusinessLocalHome(List<Class> interfaces) {
        if (this.getBusinessLocalInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business local interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessLocalInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (DeploymentInfo.BusinessLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCAL_HOME, interfaces);
    }

    @Override
    public DeploymentInfo.BusinessRemoteHome getBusinessRemoteHome() {
        return this.getBusinessRemoteHome(this.getBusinessRemoteInterfaces());
    }

    @Override
    public DeploymentInfo.BusinessRemoteHome getBusinessRemoteHome(List<Class> interfaces) {
        if (this.getBusinessRemoteInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business remote interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessRemoteInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (DeploymentInfo.BusinessRemoteHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_REMOTE_HOME, interfaces);
    }

    @Override
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public void setBeanManagedTransaction(boolean value) {
        this.isBeanManagedTransaction = value;
    }

    public void setBeanManagedConcurrency(boolean beanManagedConcurrency) {
        this.isBeanManagedConcurrency = beanManagedConcurrency;
    }

    @Override
    public Context getJndiEnc() {
        return this.context.getJndiContext();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    @Override
    public boolean isReentrant() {
        return this.isReentrant;
    }

    public void setIsReentrant(boolean reentrant) {
        this.isReentrant = reentrant;
    }

    public Method getMatchingBeanMethod(Method interfaceMethod) {
        Method method = this.methodMap.get(interfaceMethod);
        return method == null ? interfaceMethod : method;
    }

    public void appendMethodPermissions(Method m, List<String> roleNames) {
        Collection<String> hs = this.methodPermissions.get(m);
        if (hs == null) {
            hs = new HashSet<String>();
            this.methodPermissions.put(m, hs);
        }
        for (String roleName : roleNames) {
            hs.add(roleName);
        }
    }

    @Override
    public String getSecurityRole(String securityRoleReference) {
        return this.securityRoleReferenceMap.get(securityRoleReference);
    }

    public void addSecurityRoleReference(String securityRoleReference, String linkedRoleName) {
        this.securityRoleReferenceMap.put(securityRoleReference, linkedRoleName);
    }

    public void setMethodConcurrencyAttribute(Method method, String concurrencyAttribute) {
        if ("Read".equals(concurrencyAttribute)) {
            this.methodConcurrencyAttributes.put(method, (byte)6);
        } else if ("Write".equals(concurrencyAttribute)) {
            this.methodConcurrencyAttributes.put(method, (byte)7);
        } else {
            throw new IllegalArgumentException("Unsupported MethodConcurrencyAttribute '" + concurrencyAttribute + "'");
        }
    }

    public void setMethodTransactionAttribute(Method method, String transAttribute) throws OpenEJBException {
        TransactionType transactionType;
        if (transAttribute.equalsIgnoreCase("Supports")) {
            transactionType = TransactionType.Supports;
        } else if (transAttribute.equalsIgnoreCase("RequiresNew")) {
            transactionType = TransactionType.RequiresNew;
        } else if (transAttribute.equalsIgnoreCase("Mandatory")) {
            transactionType = TransactionType.Mandatory;
        } else if (transAttribute.equalsIgnoreCase("NotSupported")) {
            transactionType = TransactionType.NotSupported;
        } else if (transAttribute.equalsIgnoreCase("Required")) {
            transactionType = TransactionType.Required;
        } else if (transAttribute.equalsIgnoreCase("Never")) {
            transactionType = TransactionType.Never;
        } else {
            throw new IllegalArgumentException("Invalid transaction attribute \"" + transAttribute + "\" declared for method " + method.getName() + ". Please check your configuration.");
        }
        if (!(!this.componentType.isMessageDriven() || this.isBeanManagedTransaction || transactionType == TransactionType.NotSupported || transactionType == TransactionType.Required || method.equals(this.ejbTimeout) && transactionType == TransactionType.RequiresNew)) {
            throw new OpenEJBException("The transaction attribute " + (Object)((Object)transactionType) + " is not supported for the method " + method.getName() + " of the Message Driven Bean " + this.beanClass.getName());
        }
        this.methodTransactionType.put(method, transactionType);
    }

    @Override
    public List<Method> getAroundInvoke() {
        return this.aroundInvoke;
    }

    @Override
    public List<Method> getPostConstruct() {
        return this.postConstruct;
    }

    @Override
    public List<Method> getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public List<Method> getPostActivate() {
        return this.postActivate;
    }

    @Override
    public List<Method> getPrePassivate() {
        return this.prePassivate;
    }

    @Override
    public List<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public void setRetainIfExeption(Method removeMethod, boolean retain) {
        if (this.getRemoveMethods().contains(removeMethod)) {
            this.removeExceptionPolicy.put(removeMethod, retain);
        }
    }

    @Override
    public boolean retainIfExeption(Method removeMethod) {
        Boolean retain = this.removeExceptionPolicy.get(removeMethod);
        return retain != null && retain != false;
    }

    @Override
    public List<MethodSchedule> getMethodSchedules() {
        return this.methodSchedules;
    }

    public void setMethodSchedules(List<MethodSchedule> schedules) {
        this.methodSchedules.addAll(schedules);
    }

    public Set<InterceptorData> getInstanceScopedInterceptors() {
        return this.instanceScopedInterceptors;
    }

    public void addSystemInterceptor(Object interceptor) {
        this.systemInterceptors.add(new InterceptorInstance(interceptor));
    }

    public List<InterceptorInstance> getSystemInterceptors() {
        return this.systemInterceptors;
    }

    public List<InterceptorData> getCallbackInterceptors() {
        return this.addSystemInterceptorDatas(this.callbackInterceptors);
    }

    public void setCallbackInterceptors(List<InterceptorData> callbackInterceptors) {
        this.callbackInterceptors.clear();
        this.callbackInterceptors.addAll(callbackInterceptors);
        this.instanceScopedInterceptors.addAll(callbackInterceptors);
    }

    @Override
    public List<InterceptorData> getMethodInterceptors(Method method) {
        List<InterceptorData> interceptors = this.methodInterceptors.get(method);
        return this.addSystemInterceptorDatas(interceptors);
    }

    private List<InterceptorData> addSystemInterceptorDatas(List<InterceptorData> interceptors) {
        if (interceptors == null) {
            interceptors = Collections.EMPTY_LIST;
        }
        if (this.systemInterceptors.size() <= 0) {
            return interceptors;
        }
        ArrayList<InterceptorData> datas = new ArrayList<InterceptorData>(this.systemInterceptors.size() + interceptors.size());
        for (InterceptorInstance instance : this.systemInterceptors) {
            datas.add(instance.getData());
        }
        datas.addAll(interceptors);
        return datas;
    }

    public void setMethodInterceptors(Method method, List<InterceptorData> interceptors) {
        this.methodInterceptors.put(method, interceptors);
        this.instanceScopedInterceptors.addAll(interceptors);
    }

    public void createMethodMap() throws SystemException {
        if (this.remoteInterface != null) {
            this.mapObjectInterface(this.remoteInterface);
            this.mapHomeInterface(this.homeInterface);
        }
        if (this.localInterface != null) {
            this.mapObjectInterface(this.localInterface);
            this.mapHomeInterface(this.localHomeInterface);
        }
        if (this.serviceEndpointInterface != null) {
            this.mapObjectInterface(this.serviceEndpointInterface);
        }
        for (Class businessLocal : this.businessLocals) {
            this.mapObjectInterface(businessLocal);
        }
        for (Class businessRemote : this.businessRemotes) {
            this.mapObjectInterface(businessRemote);
        }
        if (this.componentType == BeanType.MESSAGE_DRIVEN && MessageDrivenBean.class.isAssignableFrom(this.beanClass)) {
            try {
                this.createMethod = this.beanClass.getMethod("ejbCreate", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        try {
            Method clientMethod;
            Method beanMethod;
            if (this.componentType == BeanType.STATEFUL || this.componentType == BeanType.MANAGED) {
                beanMethod = null;
                if (SessionBean.class.isAssignableFrom(this.beanClass)) {
                    beanMethod = SessionBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                } else {
                    for (Method method : this.getRemoveMethods()) {
                        if (method.getParameterTypes().length != 0) continue;
                        beanMethod = method;
                        break;
                    }
                    if (beanMethod == null && (this.homeInterface != null || this.localHomeInterface != null)) {
                        throw new IllegalStateException("Bean class has no @Remove methods to match EJBObject.remove() or EJBLocalObject.remove().  A no-arg remove method must be added: beanClass=" + this.beanClass.getName());
                    }
                }
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
            } else if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                beanMethod = EntityBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new SystemException(nsme);
        }
        if (this.mdbInterface != null) {
            this.mapObjectInterface(this.mdbInterface);
        }
    }

    private void mapHomeInterface(Class intrface) {
        Method[] homeMethods;
        for (Method method : homeMethods = intrface.getMethods()) {
            Class<?> owner = method.getDeclaringClass();
            if (owner == EJBHome.class || owner == EJBLocalHome.class) continue;
            try {
                String beanMethodName;
                Method beanMethod = null;
                if (method.getName().startsWith("create")) {
                    StringBuilder ejbCreateName = new StringBuilder(method.getName());
                    ejbCreateName.replace(0, 1, "ejbC");
                    this.createMethod = beanMethod = this.beanClass.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                    if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                        ejbCreateName.insert(3, "Post");
                        Class clazz = this.beanClass;
                        if (this.cmpImplClass != null) {
                            clazz = this.cmpImplClass;
                        }
                        Method postCreateMethod = clazz.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                        this.postCreateMethodMap.put(this.createMethod, postCreateMethod);
                    }
                } else if (method.getName().startsWith("find")) {
                    if (this.componentType == BeanType.BMP_ENTITY) {
                        beanMethodName = "ejbF" + method.getName().substring(1);
                        beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                    }
                } else {
                    beanMethodName = "ejbHome" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1);
                    beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                }
                if (beanMethod == null) continue;
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
    }

    public void mapMethods(Method interfaceMethod, Method beanMethod) {
        this.methodMap.put(interfaceMethod, beanMethod);
    }

    private void mapObjectInterface(Class intrface) {
        Method[] interfaceMethods;
        if (intrface == DeploymentInfo.BusinessLocalHome.class || intrface == DeploymentInfo.BusinessRemoteHome.class || intrface == DeploymentInfo.ServiceEndpoint.class) {
            return;
        }
        for (Method method : interfaceMethods = intrface.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == EJBObject.class || declaringClass == EJBLocalObject.class) continue;
            try {
                Method beanMethod = this.beanClass.getMethod(method.getName(), method.getParameterTypes());
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("Invalid method [" + method + "]. Not declared by " + this.beanClass.getName() + " class");
            }
        }
    }

    @Override
    public List<Class> getObjectInterface(Class homeInterface) {
        if (DeploymentInfo.BusinessLocalHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessLocalInterfaces();
        }
        if (DeploymentInfo.BusinessRemoteHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessRemoteInterfaces();
        }
        if (EJBLocalHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getLocalInterface());
            return classes;
        }
        if (EJBHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getRemoteInterface());
            return classes;
        }
        throw new IllegalArgumentException("Cannot determine object interface for " + homeInterface);
    }

    protected String extractHomeBeanMethodName(String methodName) {
        if (methodName.equals("create")) {
            return "ejbCreate";
        }
        if (methodName.startsWith("find")) {
            return "ejbF" + methodName.substring(1);
        }
        return "ejbH" + methodName.substring(1);
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public Method getMatchingPostCreateMethod(Method createMethod) {
        return this.postCreateMethodMap.get(createMethod);
    }

    public boolean isCmp2() {
        return this.cmp2;
    }

    public void setCmp2(boolean cmp2) {
        this.cmp2 = cmp2;
    }

    @Override
    public String getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public void setPrimaryKeyField(String primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public String[] getCmrFields() {
        return this.cmrFields;
    }

    public void setCmrFields(String[] cmrFields) {
        this.cmrFields = cmrFields;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void addQuery(Method queryMethod, String queryString) {
        this.queryMethodMap.put(queryMethod, queryString);
    }

    public String getQuery(Method queryMethod) {
        return this.queryMethodMap.get(queryMethod);
    }

    public void setRemoteQueryResults(String methodSignature) {
        this.remoteQueryResults.add(methodSignature);
    }

    public boolean isRemoteQueryResults(String methodSignature) {
        return this.remoteQueryResults.contains(methodSignature);
    }

    public Class getCmpImplClass() {
        return this.cmpImplClass;
    }

    public void setCmpImplClass(Class cmpImplClass) {
        this.cmpImplClass = cmpImplClass;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    @Override
    public Method getEjbTimeout() {
        return this.ejbTimeout;
    }

    public void setEjbTimeout(Method ejbTimeout) {
        this.ejbTimeout = ejbTimeout;
    }

    @Override
    public EjbTimerService getEjbTimerService() {
        return this.ejbTimerService;
    }

    public void setEjbTimerService(EjbTimerService ejbTimerService) {
        this.ejbTimerService = ejbTimerService;
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    @Override
    public String getModuleID() {
        return this.moduleId;
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public String toString() {
        return "DeploymentInfo(id=" + this.getDeploymentID() + ")";
    }

    public void setServiceEndpointInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
        this.mapObjectInterface(serviceEndpointInterface);
    }

    @Override
    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    @Override
    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    @Override
    public boolean isSessionSynchronized() {
        return !this.isBeanManagedTransaction() && SessionSynchronization.class.isAssignableFrom(this.beanClass);
    }

    public boolean isLocalbean() {
        return this.localbean;
    }

    public void setLocalbean(boolean localbean) {
        this.localbean = localbean;
    }

    @Override
    public Class getBusinessLocalBeanInterface() {
        if (this.isLocalbean()) {
            return this.beanClass;
        }
        return null;
    }
}

