/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.commons.EmptyVisitor;

public class TempClassLoader
extends URLClassLoader {
    private Set<Skip> skip;

    public TempClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        Options options = SystemInstance.get().getOptions();
        this.skip = options.getAll("openejb.tempclassloader.skip", (Enum[])new Skip[]{Skip.NONE});
    }

    public void skip(Skip s) {
        this.skip.add(s);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String packageName;
        byte[] bytes;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (!name.startsWith("javax.faces.") && (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("org.apache.openejb.api.") || name.startsWith("org.apache.openjpa.persistence."))) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        String resourceName = name.replace('.', '/') + ".class";
        InputStream in = this.getResourceAsStream(resourceName);
        if (in == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
        try {
            int count;
            byte[] buf = new byte[4096];
            while ((count = in.read(buf)) >= 0) {
                bout.write(buf, 0, count);
            }
            bytes = bout.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (this.skip.contains((Object)Skip.ANNOTATIONS) && TempClassLoader.isAnnotationClass(bytes)) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        if (this.skip.contains((Object)Skip.ENUMS) && TempClassLoader.isEnum(bytes)) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        int packageEndIndex = name.lastIndexOf(46);
        if (packageEndIndex != -1 && this.getPackage(packageName = name.substring(0, packageEndIndex)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        try {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (SecurityException e) {
            return super.loadClass(name, resolve);
        }
    }

    private static boolean isEnum(byte[] bytes) {
        IsEnumVisitor isEnumVisitor = new IsEnumVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isEnumVisitor, 2);
        return isEnumVisitor.isEnum;
    }

    private static boolean isAnnotationClass(byte[] bytes) {
        IsAnnotationVisitor isAnnotationVisitor = new IsAnnotationVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isAnnotationVisitor, 2);
        return isAnnotationVisitor.isAnnotation;
    }

    public static class IsEnumVisitor
    extends EmptyVisitor {
        public boolean isEnum = false;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isEnum = (access & 0x4000) != 0;
        }
    }

    public static class IsAnnotationVisitor
    extends EmptyVisitor {
        public boolean isAnnotation = false;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isAnnotation = (access & 0x2000) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Skip {
        NONE,
        ANNOTATIONS,
        ENUMS;

    }
}

