/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EntityBean;
import javax.ejb.NoSuchEntityException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.NoSuchObjectException;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.entity.EntityContainer;
import org.apache.openejb.core.entity.EntityContext;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionRolledbackException;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LinkedListStack;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Stack;

public class EntityInstanceManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private int poolsize = 0;
    private Map<Object, LinkedListStack> poolMap = null;
    private SecurityService securityService;

    public EntityInstanceManager(EntityContainer container, SecurityService securityService, int poolSize) {
        DeploymentInfo[] deploymentInfos;
        this.securityService = securityService;
        this.poolsize = poolSize;
        this.poolMap = new HashMap<Object, LinkedListStack>();
        for (DeploymentInfo deploymentInfo : deploymentInfos = container.deployments()) {
            this.deploy(deploymentInfo);
        }
    }

    public void deploy(DeploymentInfo deploymentInfo) {
        this.poolMap.put(deploymentInfo.getDeploymentID(), new LinkedListStack(this.poolsize / 2));
    }

    public void undeploy(DeploymentInfo deploymentInfo) {
        this.poolMap.remove(deploymentInfo.getDeploymentID());
    }

    public EntityBean obtainInstance(ThreadContext callContext) throws OpenEJBException {
        Object primaryKey = callContext.getPrimaryKey();
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (callContext.getPrimaryKey() != null && txPolicy != null && txPolicy.isTransactionActive()) {
            Key key = new Key(callContext.getDeploymentInfo().getDeploymentID(), primaryKey);
            SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
            if (wrapper != null) {
                if (!wrapper.isAssociated()) {
                    throw new InvalidateReferenceException(new NoSuchObjectException("Entity not found: " + primaryKey));
                }
                if (callContext.getCurrentOperation() == Operation.REMOVE) {
                    wrapper.disassociate();
                }
                if (wrapper.isAvailable() || wrapper.primaryKey.equals(primaryKey)) {
                    return wrapper.getEntityBean();
                }
                return wrapper.getEntityBean();
            }
            EntityBean bean = this.getPooledInstance(callContext);
            wrapper = new SynchronizationWrapper(callContext.getDeploymentInfo(), primaryKey, bean, false, key, txPolicy);
            if (callContext.getCurrentOperation() == Operation.REMOVE) {
                wrapper.disassociate();
            }
            txPolicy.registerSynchronization(wrapper);
            this.loadingBean(bean, callContext);
            Operation orginalOperation = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.LOAD);
            try {
                try {
                    bean.ejbLoad();
                }
                catch (NoSuchEntityException e) {
                    wrapper.disassociate();
                    throw new InvalidateReferenceException(new NoSuchObjectException("Entity not found: " + primaryKey, e));
                }
                catch (Exception e) {
                    logger.error("Exception encountered during ejbLoad():", e);
                    wrapper.disassociate();
                    throw new OpenEJBException(e);
                }
                Object var10_8 = null;
                callContext.setCurrentOperation(orginalOperation);
                callContext.setCurrentAllowedStates(EntityContext.getStates());
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                callContext.setCurrentOperation(orginalOperation);
                callContext.setCurrentAllowedStates(EntityContext.getStates());
                throw throwable;
            }
            txPolicy.putResource(key, wrapper);
            return bean;
        }
        return this.getPooledInstance(callContext);
    }

    protected void loadingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    protected void reusingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EntityBean getPooledInstance(ThreadContext callContext) throws OpenEJBException {
        BaseContext.State[] originalStates;
        Operation currentOp;
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Stack methodReadyPool = this.poolMap.get(deploymentInfo.getDeploymentID());
        if (methodReadyPool == null) {
            throw new SystemException("Invalid deployment id " + deploymentInfo.getDeploymentID() + " for this container");
        }
        EntityBean bean = (EntityBean)methodReadyPool.pop();
        if (bean == null) {
            try {
                bean = (EntityBean)deploymentInfo.getBeanClass().newInstance();
            }
            catch (Exception e) {
                logger.error("Bean instantiation failed for class " + deploymentInfo.getBeanClass(), e);
                throw new SystemException(e);
            }
            currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.SET_CONTEXT);
            originalStates = callContext.setCurrentAllowedStates(EntityContext.getStates());
            try {
                try {
                    bean.setEntityContext((javax.ejb.EntityContext)this.createEntityContext());
                }
                catch (Exception e) {
                    logger.error("Bean callback method failed ", e);
                    throw new ApplicationException(e);
                }
                Object var9_8 = null;
                callContext.setCurrentOperation(currentOp);
                callContext.setCurrentAllowedStates(originalStates);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                callContext.setCurrentOperation(currentOp);
                callContext.setCurrentAllowedStates(originalStates);
                throw throwable;
            }
        }
        this.reusingBean(bean, callContext);
        if (callContext.getCurrentOperation() != Operation.BUSINESS) {
            if (callContext.getCurrentOperation() != Operation.REMOVE) return bean;
        }
        currentOp = callContext.getCurrentOperation();
        callContext.setCurrentOperation(Operation.ACTIVATE);
        originalStates = callContext.setCurrentAllowedStates(EntityContext.getStates());
        try {
            try {
                bean.ejbActivate();
            }
            catch (Throwable e) {
                logger.error("Encountered exception during call to ejbActivate()", e);
                TransactionPolicy txPolicy = callContext.getTransactionPolicy();
                if (txPolicy == null) throw new ApplicationException(new RemoteException("Exception thrown while attempting to call ejbActivate() on the instance. Exception message = " + e.getMessage(), e));
                if (!txPolicy.isTransactionActive()) throw new ApplicationException(new RemoteException("Exception thrown while attempting to call ejbActivate() on the instance. Exception message = " + e.getMessage(), e));
                txPolicy.setRollbackOnly();
                throw new ApplicationException((Exception)((Object)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbActivate() on the instance", e)));
            }
            Object var11_14 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalStates);
            return bean;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalStates);
            throw throwable;
        }
    }

    private EntityContext createEntityContext() {
        return new EntityContext(this.securityService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void poolInstance(ThreadContext callContext, EntityBean bean, Object primaryKey) throws OpenEJBException {
        if (bean == null) {
            return;
        }
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (primaryKey != null && txPolicy != null && txPolicy.isTransactionActive()) {
            Key key = new Key(callContext.getDeploymentInfo().getDeploymentID(), primaryKey);
            SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
            if (wrapper == null) {
                wrapper = new SynchronizationWrapper(callContext.getDeploymentInfo(), primaryKey, bean, true, key, txPolicy);
                txPolicy.registerSynchronization(wrapper);
                txPolicy.putResource(key, wrapper);
                return;
            }
            if (callContext.getCurrentOperation() == Operation.REMOVE) {
                wrapper.disassociate();
                Stack methodReadyPool = this.poolMap.get(callContext.getDeploymentInfo().getDeploymentID());
                methodReadyPool.push(bean);
                return;
            }
            if (callContext.getCurrentOperation() == Operation.CREATE) {
                wrapper.associate();
            }
            wrapper.setEntityBean(bean);
            return;
        }
        if (primaryKey != null && callContext.getCurrentOperation() != Operation.REMOVE) {
            Operation currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.PASSIVATE);
            BaseContext.State[] originalStates = callContext.setCurrentAllowedStates(EntityContext.getStates());
            try {
                try {
                    bean.ejbPassivate();
                }
                catch (Throwable e) {
                    if (!txPolicy.isTransactionActive()) throw new ApplicationException(new RemoteException("Reflection exception thrown while attempting to call ejbPassivate() on the instance. Exception message = " + e.getMessage(), e));
                    txPolicy.setRollbackOnly();
                    throw new ApplicationException((Exception)((Object)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbPassivate() on the instance", e)));
                }
                Object var9_11 = null;
                callContext.setCurrentOperation(currentOp);
                callContext.setCurrentAllowedStates(originalStates);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                callContext.setCurrentOperation(currentOp);
                callContext.setCurrentAllowedStates(originalStates);
                throw throwable;
            }
        }
        Stack methodReadyPool = this.poolMap.get(callContext.getDeploymentInfo().getDeploymentID());
        methodReadyPool.push(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        this.discardInstance(callContext, bean);
        Operation currentOp = callContext.getCurrentOperation();
        callContext.setCurrentOperation(Operation.UNSET_CONTEXT);
        BaseContext.State[] originalStates = callContext.setCurrentAllowedStates(EntityContext.getStates());
        try {
            try {
                bean.unsetEntityContext();
            }
            catch (Exception e) {
                logger.info(this.getClass().getName() + ".freeInstance: ignoring exception " + e + " on bean instance " + bean);
                Object var7_6 = null;
                callContext.setCurrentOperation(currentOp);
                callContext.setCurrentAllowedStates(originalStates);
                return;
            }
            Object var7_5 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalStates);
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            callContext.setCurrentOperation(currentOp);
            callContext.setCurrentAllowedStates(originalStates);
            throw throwable;
        }
    }

    public void discardInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        Object primaryKey = callContext.getPrimaryKey();
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (primaryKey == null || txPolicy == null || !txPolicy.isTransactionActive()) {
            return;
        }
        Key key = new Key(callContext.getDeploymentInfo().getDeploymentID(), primaryKey);
        SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
        if (wrapper != null) {
            wrapper.disassociate();
        }
    }

    protected class SynchronizationWrapper
    implements TransactionPolicy.TransactionSynchronization {
        private EntityBean bean;
        private boolean available;
        private boolean associated;
        private final Key readyPoolKey;
        private final CoreDeploymentInfo deploymentInfo;
        private final Object primaryKey;
        private final TransactionPolicy txPolicy;

        public SynchronizationWrapper(CoreDeploymentInfo deploymentInfo, Object primaryKey, EntityBean bean, boolean available, Key readyPoolKey, TransactionPolicy txPolicy) {
            if (bean == null) {
                throw new IllegalArgumentException("bean is null");
            }
            if (readyPoolKey == null) {
                throw new IllegalArgumentException("key is null");
            }
            if (deploymentInfo == null) {
                throw new IllegalArgumentException("deploymentInfo is null");
            }
            if (primaryKey == null) {
                throw new IllegalArgumentException("primaryKey is null");
            }
            if (txPolicy == null) {
                throw new IllegalArgumentException("txEnv is null");
            }
            this.deploymentInfo = deploymentInfo;
            this.bean = bean;
            this.primaryKey = primaryKey;
            this.available = available;
            this.readyPoolKey = readyPoolKey;
            this.txPolicy = txPolicy;
            this.associated = true;
        }

        public void associate() {
            this.associated = true;
        }

        public void disassociate() {
            this.associated = false;
        }

        public boolean isAssociated() {
            return this.associated;
        }

        public synchronized boolean isAvailable() {
            return this.available;
        }

        public synchronized void setEntityBean(EntityBean ebean) {
            this.available = true;
            this.bean = ebean;
        }

        public synchronized EntityBean getEntityBean() {
            this.available = false;
            return this.bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void beforeCompletion() {
            EntityBean bean;
            if (!this.associated) return;
            SynchronizationWrapper synchronizationWrapper = this;
            synchronized (synchronizationWrapper) {
                bean = this.bean;
            }
            ThreadContext callContext = new ThreadContext(this.deploymentInfo, this.primaryKey);
            callContext.setCurrentOperation(Operation.STORE);
            callContext.setCurrentAllowedStates(EntityContext.getStates());
            ThreadContext oldCallContext = ThreadContext.enter(callContext);
            try {
                try {
                    bean.ejbStore();
                }
                catch (Exception re) {
                    logger.error("Exception occured during ejbStore()", re);
                    this.txPolicy.setRollbackOnly();
                    Object var6_5 = null;
                    ThreadContext.exit(oldCallContext);
                    return;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ThreadContext.exit(oldCallContext);
                throw throwable;
            }
            ThreadContext.exit(oldCallContext);
        }

        public void afterCompletion(TransactionPolicy.TransactionSynchronization.Status status) {
            this.txPolicy.removeResource(this.readyPoolKey);
        }
    }

    private static class Key {
        private final Object deploymentId;
        private final Object primaryKey;

        public Key(Object deploymentId, Object primaryKey) {
            if (deploymentId == null) {
                throw new NullPointerException("deploymentId is null");
            }
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is null");
            }
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.deploymentId.equals(key.deploymentId) && this.primaryKey.equals(key.primaryKey);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 31 * result + this.primaryKey.hashCode();
            return result;
        }
    }
}

