/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import org.apache.openejb.core.Operation;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorData {
    private Class clazz;
    private final List<Method> aroundInvoke = new ArrayList<Method>();
    private final List<Method> postConstruct = new ArrayList<Method>();
    private final List<Method> preDestroy = new ArrayList<Method>();
    private final List<Method> postActivate = new ArrayList<Method>();
    private final List<Method> prePassivate = new ArrayList<Method>();

    public InterceptorData(Class clazz) {
        this.clazz = clazz;
    }

    public Class getInterceptorClass() {
        return this.clazz;
    }

    public List<Method> getAroundInvoke() {
        return this.aroundInvoke;
    }

    public List<Method> getPostConstruct() {
        return this.postConstruct;
    }

    public List<Method> getPreDestroy() {
        return this.preDestroy;
    }

    public List<Method> getPostActivate() {
        return this.postActivate;
    }

    public List<Method> getPrePassivate() {
        return this.prePassivate;
    }

    public List<Method> getMethods(Operation operation) {
        switch (operation) {
            case BUSINESS: {
                return this.getAroundInvoke();
            }
            case BUSINESS_WS: {
                return this.getAroundInvoke();
            }
            case REMOVE: {
                return this.getAroundInvoke();
            }
            case POST_CONSTRUCT: {
                return this.getPostConstruct();
            }
            case PRE_DESTROY: {
                return this.getPreDestroy();
            }
            case ACTIVATE: {
                return this.getPostActivate();
            }
            case PASSIVATE: {
                return this.getPrePassivate();
            }
            case AFTER_BEGIN: {
                return this.getAroundInvoke();
            }
            case AFTER_COMPLETION: {
                return this.getAroundInvoke();
            }
            case BEFORE_COMPLETION: {
                return this.getAroundInvoke();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorData that = (InterceptorData)o;
        return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
    }

    public int hashCode() {
        return this.clazz != null ? this.clazz.hashCode() : 0;
    }

    public static InterceptorData scan(Class<?> clazz) {
        ClassFinder finder = new ClassFinder(new Class[]{clazz});
        InterceptorData data = new InterceptorData(clazz);
        data.aroundInvoke.addAll(finder.findAnnotatedMethods(AroundInvoke.class));
        data.postConstruct.addAll(finder.findAnnotatedMethods(PostConstruct.class));
        data.preDestroy.addAll(finder.findAnnotatedMethods(PreDestroy.class));
        data.postActivate.addAll(finder.findAnnotatedMethods(PostActivate.class));
        data.prePassivate.addAll(finder.findAnnotatedMethods(PrePassivate.class));
        return data;
    }
}

