/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.proxy.InvocationHandler;
import org.apache.openejb.util.proxy.ProxyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEjbProxyHandler
implements InvocationHandler,
Serializable {
    private static final String OPENEJB_LOCALCOPY = "openejb.localcopy";
    private IntraVmCopyMonitor.State strategy = IntraVmCopyMonitor.State.NONE;
    public final Object deploymentID;
    public final Object primaryKey;
    public boolean inProxyMap = false;
    private transient WeakReference<DeploymentInfo> deploymentInfo;
    public transient RpcContainer container;
    protected boolean isInvalidReference = false;
    protected Object clientIdentity;
    private boolean doIntraVmCopy;
    private boolean doCrossClassLoaderCopy;
    private static final boolean REMOTE_COPY_ENABLED = BaseEjbProxyHandler.parseRemoteCopySetting();
    protected final InterfaceType interfaceType;
    private transient WeakHashMap<Class, Object> interfaces;
    private transient WeakReference<Class> mainInterface;

    public BaseEjbProxyHandler(DeploymentInfo deploymentInfo, Object pk, InterfaceType interfaceType, List<Class> interfaces) {
        this.container = (RpcContainer)deploymentInfo.getContainer();
        this.deploymentID = deploymentInfo.getDeploymentID();
        this.interfaceType = interfaceType;
        this.primaryKey = pk;
        this.setDeploymentInfo(deploymentInfo);
        if (interfaces == null || interfaces.size() == 0) {
            InterfaceType objectInterfaceType = interfaceType.isHome() ? interfaceType.getCounterpart() : interfaceType;
            interfaces = new ArrayList<Class>(deploymentInfo.getInterfaces(objectInterfaceType));
        }
        this.setDoIntraVmCopy(!interfaceType.isLocal() && !interfaceType.isLocalBean());
        if (!interfaceType.isLocal() && !interfaceType.isLocalBean()) {
            this.setDoIntraVmCopy(REMOTE_COPY_ENABLED);
        }
        this.setInterfaces(interfaces);
        if (interfaceType.isHome()) {
            this.setMainInterface(deploymentInfo.getInterface(interfaceType));
        } else {
            this.setMainInterface(interfaces.get(0));
        }
    }

    protected void setDoIntraVmCopy(boolean doIntraVmCopy) {
        this.doIntraVmCopy = doIntraVmCopy;
        this.setStrategy();
    }

    protected void setDoCrossClassLoaderCopy(boolean doCrossClassLoaderCopy) {
        this.doCrossClassLoaderCopy = doCrossClassLoaderCopy;
        this.setStrategy();
    }

    private void setStrategy() {
        this.strategy = !this.doIntraVmCopy ? IntraVmCopyMonitor.State.NONE : (this.doCrossClassLoaderCopy ? IntraVmCopyMonitor.State.CLASSLOADER_COPY : IntraVmCopyMonitor.State.COPY);
    }

    protected Class<?> getInvokedInterface(Method method) {
        Class mainInterface = this.getMainInterface();
        if (this.interfaceType.isHome()) {
            return mainInterface;
        }
        if (this.interfaceType.isLocalBean()) {
            return mainInterface;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isAssignableFrom(mainInterface)) {
            return mainInterface;
        }
        for (Class secondaryInterface : this.interfaces.keySet()) {
            if (!declaringClass.isAssignableFrom(secondaryInterface)) continue;
            return secondaryInterface;
        }
        throw new IllegalStateException("Received method invocation and cannot determine corresponding business interface: method=" + method);
    }

    public Class getMainInterface() {
        return (Class)this.mainInterface.get();
    }

    private void setMainInterface(Class referent) {
        this.mainInterface = new WeakReference<Class>(referent);
    }

    private void setInterfaces(List<Class> interfaces) {
        this.interfaces = new WeakHashMap(interfaces.size());
        for (Class clazz : interfaces) {
            this.interfaces.put(clazz, null);
        }
    }

    public List<Class> getInterfaces() {
        Set<Class> classes = this.interfaces.keySet();
        return new ArrayList<Class>(classes);
    }

    private static boolean parseRemoteCopySetting() {
        return SystemInstance.get().getOptions().get(OPENEJB_LOCALCOPY, true);
    }

    protected void checkAuthorization(Method method) throws OpenEJBException {
    }

    public void setIntraVmCopyMode(boolean on) {
        this.setDoIntraVmCopy(on);
    }

    @Override
    public InvocationHandler getInvocationHandler() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        this.isValidReference(method);
        if (args == null) {
            args = new Object[]{};
        }
        if (method.getDeclaringClass() == Object.class) {
            Boolean bl;
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return this.toString();
            }
            if (!methodName.equals("equals")) {
                if (!methodName.equals("hashCode")) throw new UnsupportedOperationException("Unkown method: " + method);
                return new Integer(this.hashCode());
            }
            if (this.equals(args[0])) {
                bl = Boolean.TRUE;
                return bl;
            }
            bl = Boolean.FALSE;
            return bl;
        }
        if (method.getDeclaringClass() == IntraVmProxy.class) {
            String methodName = method.getName();
            if (!methodName.equals("writeReplace")) throw new UnsupportedOperationException("Unkown method: " + method);
            return this._writeReplace(proxy);
        }
        Class<?> interfce = this.getInvokedInterface(method);
        ThreadContext callContext = ThreadContext.getThreadContext();
        Object localClientIdentity = ClientSecurity.getIdentity();
        try {
            if (callContext == null && localClientIdentity != null) {
                SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
                securityService.associate(localClientIdentity);
            }
            if (this.strategy == IntraVmCopyMonitor.State.CLASSLOADER_COPY) {
                IntraVmCopyMonitor.pre(this.strategy);
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getDeploymentInfo().getClassLoader());
                try {
                    args = this.copyArgs(args);
                    method = this.copyMethod(method);
                    interfce = this.copyObj(interfce);
                    Object var9_12 = null;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    IntraVmCopyMonitor.post();
                    throw throwable;
                }
                IntraVmCopyMonitor.post();
            } else if (this.strategy == IntraVmCopyMonitor.State.COPY && args != null && args.length > 0) {
                IntraVmCopyMonitor.pre(this.strategy);
                try {
                    args = this.copyArgs(args);
                    Object var11_16 = null;
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    IntraVmCopyMonitor.post();
                    throw throwable;
                }
                IntraVmCopyMonitor.post();
            }
            try {
                Object returnValue = this._invoke(proxy, interfce, method, args);
                object = this.copy(this.strategy, returnValue);
            }
            catch (Throwable throwable) {
                throwable = this.copy(this.strategy, throwable);
                throw this.convertException(throwable, method, interfce);
            }
            Object var13_19 = null;
            if (callContext != null) return object;
            if (localClientIdentity == null) return object;
        }
        catch (Throwable throwable2) {
            Object var13_20 = null;
            if (callContext != null) throw throwable2;
            if (localClientIdentity == null) throw throwable2;
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            securityService.disassociate();
            throw throwable2;
        }
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        securityService.disassociate();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T copy(IntraVmCopyMonitor.State strategy, T object) throws IOException, ClassNotFoundException {
        T t;
        if (object == null || !strategy.isCopy()) {
            return object;
        }
        IntraVmCopyMonitor.pre(strategy);
        try {
            t = this.copyObj(object);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IntraVmCopyMonitor.post();
            throw throwable;
        }
        IntraVmCopyMonitor.post();
        return t;
    }

    private void isValidReference(Method method) throws NoSuchObjectException {
        if (this.isInvalidReference) {
            if (this.interfaceType.isComponent() && this.interfaceType.isLocal()) {
                throw new NoSuchObjectLocalException("reference is invalid");
            }
            if (this.interfaceType.isComponent() || Remote.class.isAssignableFrom(method.getDeclaringClass())) {
                throw new NoSuchObjectException("reference is invalid");
            }
            throw new NoSuchEJBException("reference is invalid");
        }
        this.getDeploymentInfo();
    }

    protected Throwable convertException(Throwable e, Method method, Class interfce) {
        boolean rmiRemote = Remote.class.isAssignableFrom(interfce);
        if (e instanceof TransactionRequiredException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBTransactionRequiredException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new TransactionRequiredLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof TransactionRolledbackException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBTransactionRolledbackException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new TransactionRolledbackLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof NoSuchObjectException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new NoSuchEJBException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new NoSuchObjectLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof RemoteException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new EJBException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof AccessException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new AccessLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new AccessLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        for (Class<?> type : method.getExceptionTypes()) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            return e;
        }
        while (e.getCause() != null && !(e instanceof RuntimeException)) {
            e = e.getCause();
        }
        return e;
    }

    private Method copyMethod(Method method) throws Exception {
        int parameterCount = method.getParameterTypes().length;
        Object[] types = new Object[1 + parameterCount];
        types[0] = method.getDeclaringClass();
        System.arraycopy(method.getParameterTypes(), 0, types, 1, parameterCount);
        types = this.copyArgs(types);
        Class targetClass = (Class)types[0];
        Class[] targetParameters = new Class[parameterCount];
        System.arraycopy(types, 1, targetParameters, 0, parameterCount);
        Method targetMethod = targetClass.getMethod(method.getName(), targetParameters);
        return targetMethod;
    }

    protected Throwable getCause(Throwable e) {
        if (e != null && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    public String toString() {
        String name = null;
        try {
            name = this.getProxyInfo().getInterface().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "proxy=" + name + ";deployment=" + this.deploymentID + ";pk=" + this.primaryKey;
    }

    public int hashCode() {
        if (this.primaryKey == null) {
            return this.deploymentID.hashCode();
        }
        return this.primaryKey.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            obj = ProxyManager.getInvocationHandler(obj);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        BaseEjbProxyHandler other = (BaseEjbProxyHandler)obj;
        if (this.primaryKey == null) {
            return other.primaryKey == null && this.deploymentID.equals(other.deploymentID);
        }
        return this.primaryKey.equals(other.primaryKey) && this.deploymentID.equals(other.deploymentID);
    }

    protected abstract Object _invoke(Object var1, Class var2, Method var3, Object[] var4) throws Throwable;

    protected Object[] copyArgs(Object[] objects) throws IOException, ClassNotFoundException {
        if (objects == null) {
            return objects;
        }
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.copyObj(objects[i]);
        }
        return objects;
    }

    protected <T> T copyObj(T object) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        Class<?> ooc = object.getClass();
        if (ooc == Integer.TYPE || ooc == String.class || ooc == Long.TYPE || ooc == Boolean.TYPE || ooc == Byte.TYPE || ooc == Float.TYPE || ooc == Double.TYPE || ooc == Short.TYPE || ooc == Long.class || ooc == Boolean.class || ooc == Byte.class || ooc == Character.class || ooc == Float.class || ooc == Double.class || ooc == Short.class || ooc == BigDecimal.class) {
            return object;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(128);
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(object);
            out.close();
        }
        catch (NotSerializableException e) {
            throw (IOException)new NotSerializableException(e.getMessage() + " : The EJB specification restricts remote interfaces to only serializable data types.  This can be disabled for in-vm use with the " + OPENEJB_LOCALCOPY + "=false system property.").initCause(e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        EjbObjectInputStream in = new EjbObjectInputStream(bais);
        Object obj = in.readObject();
        return (T)obj;
    }

    public void invalidateReference() {
        this.container = null;
        this.setDeploymentInfo(null);
        this.isInvalidReference = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateAllHandlers(Object key) {
        HashSet set = (HashSet)this.getLiveHandleRegistry().remove(key);
        if (set == null) {
            return;
        }
        HashSet hashSet = set;
        synchronized (hashSet) {
            for (BaseEjbProxyHandler handler : set) {
                handler.invalidateReference();
            }
        }
    }

    protected abstract Object _writeReplace(Object var1) throws ObjectStreamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerHandler(Object key, BaseEjbProxyHandler handler) {
        HashSet<BaseEjbProxyHandler> set = (HashSet<BaseEjbProxyHandler>)this.getLiveHandleRegistry().get(key);
        if (set != null) {
            HashSet<BaseEjbProxyHandler> hashSet = set;
            synchronized (hashSet) {
                set.add(handler);
            }
        } else {
            set = new HashSet<BaseEjbProxyHandler>();
            set.add(handler);
            this.getLiveHandleRegistry().put(key, set);
        }
    }

    public abstract ProxyInfo getProxyInfo();

    public DeploymentInfo getDeploymentInfo() {
        DeploymentInfo info = (DeploymentInfo)this.deploymentInfo.get();
        if (info == null || info.isDestroyed()) {
            this.invalidateReference();
            throw new IllegalStateException("Bean '" + this.deploymentID + "' has been undeployed.");
        }
        return info;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = new WeakReference<DeploymentInfo>(deploymentInfo);
    }

    public Hashtable getLiveHandleRegistry() {
        DeploymentInfo deploymentInfo = this.getDeploymentInfo();
        ProxyRegistry proxyRegistry = deploymentInfo.get(ProxyRegistry.class);
        if (proxyRegistry == null) {
            proxyRegistry = new ProxyRegistry();
            deploymentInfo.set(ProxyRegistry.class, proxyRegistry);
        }
        return proxyRegistry.liveHandleRegistry;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getInterfaces());
        out.writeObject(this.getMainInterface());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.setDeploymentInfo(containerSystem.getDeploymentInfo(this.deploymentID));
        this.container = (RpcContainer)this.getDeploymentInfo().getContainer();
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            this.setDoCrossClassLoaderCopy(true);
        }
        this.setInterfaces((List)in.readObject());
        this.setMainInterface((Class)in.readObject());
    }

    private static class ProxyRegistry {
        protected final Hashtable liveHandleRegistry = new Hashtable();

        private ProxyRegistry() {
        }
    }
}

