/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmHandle;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EjbObjectProxyHandler
extends BaseEjbProxyHandler {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    static final HashMap dispatchTable = new HashMap();

    public EjbObjectProxyHandler(DeploymentInfo deploymentInfo, Object pk, InterfaceType interfaceType, List<Class> interfaces) {
        super(deploymentInfo, pk, interfaceType, interfaces);
    }

    public abstract Object getRegistryId();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object _invoke(Object p, Class interfce, Method m, Object[] a) throws Throwable {
        Object object;
        Throwable exc;
        block25: {
            Object retValue = null;
            exc = null;
            try {
                try {
                    Integer operation;
                    if (logger.isDebugEnabled()) {
                        logger.debug("invoking method " + m.getName() + " on " + this.deploymentID + " with identity " + this.primaryKey);
                    }
                    if ((operation = (Integer)dispatchTable.get(m.getName())) != null) {
                        if (operation == 3) {
                            if (m.getParameterTypes()[0] != EJBObject.class && m.getParameterTypes()[0] != EJBLocalObject.class) {
                                operation = null;
                            }
                        } else {
                            Integer n = operation = m.getParameterTypes().length == 0 ? operation : null;
                        }
                    }
                    if (operation == null || !this.interfaceType.isComponent()) {
                        retValue = this.businessMethod(interfce, m, a, p);
                    } else {
                        switch (operation) {
                            case 1: {
                                retValue = this.getHandle(m, a, p);
                                break;
                            }
                            case 2: {
                                retValue = this.getPrimaryKey(m, a, p);
                                break;
                            }
                            case 3: {
                                retValue = this.isIdentical(m, a, p);
                                break;
                            }
                            case 4: {
                                retValue = this.remove(interfce, m, a, p);
                                break;
                            }
                            case 5: {
                                retValue = this.getEJBHome(m, a, p);
                                break;
                            }
                            case 6: {
                                retValue = this.getEJBLocalHome(m, a, p);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Inconsistent internal state");
                            }
                        }
                    }
                    object = retValue;
                    Object var10_13 = null;
                    if (!logger.isDebugEnabled()) return object;
                    if (exc != null) break block25;
                    logger.debug("finished invoking method " + m.getName() + ". Return value:" + retValue);
                    return object;
                }
                catch (InvalidateReferenceException ire) {
                    this.invalidateAllHandlers(this.getRegistryId());
                    exc = ire.getRootCause() != null ? ire.getRootCause() : ire;
                    throw exc;
                }
                catch (ApplicationException ae) {
                    exc = ae.getRootCause() != null ? ae.getRootCause() : ae;
                    if (!(exc instanceof EJBAccessException)) throw exc;
                    if (this.interfaceType.isBusiness()) {
                        throw exc;
                    }
                    if (!this.interfaceType.isLocal()) throw new AccessException(exc.getMessage());
                    throw new AccessLocalException(exc.getMessage()).initCause(exc.getCause());
                }
                catch (SystemException se) {
                    this.invalidateReference();
                    exc = se.getRootCause() != null ? se.getRootCause() : se;
                    logger.debug("The container received an unexpected exception: ", exc);
                    throw new RemoteException("Container has suffered a SystemException", exc);
                }
                catch (OpenEJBException oe) {
                    exc = oe.getRootCause() != null ? oe.getRootCause() : oe;
                    logger.debug("The container received an unexpected exception: ", exc);
                    throw new RemoteException("Unknown Container Exception", oe.getRootCause());
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (!logger.isDebugEnabled()) throw throwable;
                if (exc == null) {
                    logger.debug("finished invoking method " + m.getName() + ". Return value:" + retValue);
                    throw throwable;
                }
                logger.debug("finished invoking method " + m.getName() + " with exception " + exc);
                throw throwable;
            }
        }
        logger.debug("finished invoking method " + m.getName() + " with exception " + exc);
        return object;
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.getDeploymentInfo().getEJBHome();
    }

    protected Object getEJBLocalHome(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.getDeploymentInfo().getEJBLocalHome();
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return new IntraVmHandle(proxy);
    }

    @Override
    public ProxyInfo getProxyInfo() {
        return new ProxyInfo(this.getDeploymentInfo(), this.primaryKey, this.getInterfaces(), this.interfaceType);
    }

    @Override
    protected Object _writeReplace(Object proxy) throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(proxy);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return proxy;
        }
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            return proxy;
        }
        ApplicationServer applicationServer = ServerFederation.getApplicationServer();
        if (this.interfaceType.isBusiness()) {
            return applicationServer.getBusinessObject(this.getProxyInfo());
        }
        return applicationServer.getEJBObject(this.getProxyInfo());
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Class var1, Method var2, Object[] var3, Object var4) throws Throwable;

    protected Object businessMethod(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        return this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, this.primaryKey);
    }

    public static Object createProxy(DeploymentInfo deploymentInfo, Object primaryKey, InterfaceType interfaceType) {
        return EjbObjectProxyHandler.createProxy(deploymentInfo, primaryKey, interfaceType, null);
    }

    public static Object createProxy(DeploymentInfo deploymentInfo, Object primaryKey, InterfaceType interfaceType, List<Class> interfaces) {
        if (!interfaceType.isHome()) {
            interfaceType = interfaceType.getCounterpart();
        }
        EjbHomeProxyHandler homeHandler = EjbHomeProxyHandler.createHomeHandler(deploymentInfo, interfaceType, interfaces);
        return homeHandler.createProxy(primaryKey);
    }

    static {
        dispatchTable.put("getHandle", new Integer(1));
        dispatchTable.put("getPrimaryKey", new Integer(2));
        dispatchTable.put("isIdentical", new Integer(3));
        dispatchTable.put("remove", new Integer(4));
        dispatchTable.put("getEJBHome", new Integer(5));
        dispatchTable.put("getEJBLocalHome", new Integer(6));
    }
}

