/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.singleton;

import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.BaseSessionContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.spi.SecurityService;

public class SingletonContext
extends BaseSessionContext {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];

    public static BaseContext.State[] getStates() {
        return states;
    }

    public SingletonContext(SecurityService securityService) {
        super(securityService);
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    static {
        SingletonContext.states[Operation.INJECTION.ordinal()] = new BaseSessionContext.InjectionSessionState();
        SingletonContext.states[Operation.CREATE.ordinal()] = new BaseSessionContext.LifecycleSessionState();
        SingletonContext.states[Operation.BUSINESS.ordinal()] = new BaseSessionContext.BusinessSessionState();
        SingletonContext.states[Operation.BUSINESS_WS.ordinal()] = new BusinessWsStatelessState();
        SingletonContext.states[Operation.TIMEOUT.ordinal()] = new BaseSessionContext.TimeoutSessionState();
        SingletonContext.states[Operation.POST_CONSTRUCT.ordinal()] = new BaseSessionContext.PostConstructSessionState();
        SingletonContext.states[Operation.PRE_DESTROY.ordinal()] = new BaseSessionContext.LifecycleSessionState();
    }

    private static class BusinessWsStatelessState
    extends BaseSessionContext.SessionState {
        private BusinessWsStatelessState() {
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }
    }
}

