/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.io.Flushable;
import java.io.IOException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.BaseSessionContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.spi.SecurityService;

public class StatelessContext
extends BaseSessionContext
implements Flushable {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];
    private final Flushable flushable;

    public static BaseContext.State[] getStates() {
        return states;
    }

    public StatelessContext(SecurityService securityService, Flushable flushable) {
        super(securityService);
        this.flushable = flushable;
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    public void flush() throws IOException {
        this.flushable.flush();
    }

    static {
        StatelessContext.states[Operation.INJECTION.ordinal()] = new BaseSessionContext.InjectionSessionState();
        StatelessContext.states[Operation.CREATE.ordinal()] = new BaseSessionContext.LifecycleSessionState();
        StatelessContext.states[Operation.BUSINESS.ordinal()] = new BaseSessionContext.BusinessSessionState();
        StatelessContext.states[Operation.BUSINESS_WS.ordinal()] = new BusinessWsStatelessState();
        StatelessContext.states[Operation.TIMEOUT.ordinal()] = new BaseSessionContext.TimeoutSessionState();
        StatelessContext.states[Operation.POST_CONSTRUCT.ordinal()] = new BaseSessionContext.PostConstructSessionState();
        StatelessContext.states[Operation.PRE_DESTROY.ordinal()] = new BaseSessionContext.LifecycleSessionState();
    }

    private static class BusinessWsStatelessState
    extends BaseSessionContext.SessionState {
        private BusinessWsStatelessState() {
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }
    }
}

