/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.io.Flushable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.EjbWsContext;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessContext;
import org.apache.openejb.loader.Options;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.openejb.util.Pool;
import org.apache.openejb.util.SafeToolkit;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class StatelessInstanceManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    protected Duration accessTimeout;
    protected Duration closeTimeout;
    protected int beanCount = 0;
    protected final SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulInstanceManager");
    private SecurityService securityService;
    private final Pool.Builder poolBuilder;
    private final Executor executor;

    public StatelessInstanceManager(SecurityService securityService, Duration accessTimeout, Duration closeTimeout, Pool.Builder poolBuilder, int callbackThreads) {
        this.securityService = securityService;
        this.accessTimeout = accessTimeout;
        this.closeTimeout = closeTimeout;
        this.poolBuilder = poolBuilder;
        if (accessTimeout.getUnit() == null) {
            accessTimeout.setUnit(TimeUnit.MILLISECONDS);
        }
        this.executor = new ThreadPoolExecutor(callbackThreads, callbackThreads * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "StatelessPool");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public Object getInstance(ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Instance instance = null;
        try {
            Pool.Entry entry = data.poolPop();
            if (entry != null) {
                instance = (Instance)entry.get();
                instance.setPoolEntry(entry);
            }
        }
        catch (TimeoutException e) {
            ConcurrentAccessTimeoutException timeoutException = new ConcurrentAccessTimeoutException("No instances available in Stateless Session Bean pool.  Waited " + data.accessTimeout.toString());
            timeoutException.fillInStackTrace();
            throw new ApplicationException((Exception)timeoutException);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OpenEJBException("Unexpected Interruption of current thread: ", e);
        }
        if (instance == null) {
            try {
                instance = this.ceateInstance(callContext);
            }
            catch (Throwable t) {
                data.pool.push((Pool.Entry)null);
                if (t instanceof OpenEJBException) {
                    throw (OpenEJBException)t;
                }
                throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", t));
            }
        }
        return instance;
    }

    private Instance ceateInstance(ThreadContext callContext) throws ApplicationException {
        Instance instance;
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Class beanClass = deploymentInfo.getBeanClass();
        Operation originalOperation = callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
        Data data = (Data)deploymentInfo.getContainerData();
        try {
            Class clazz;
            Context ctx = deploymentInfo.getJndiEnc();
            InjectionProcessor injectionProcessor = new InjectionProcessor(beanClass, deploymentInfo.getInjections(), null, null, InjectionProcessor.unwrap(ctx));
            try {
                if (SessionBean.class.isAssignableFrom(beanClass) || beanClass.getMethod("setSessionContext", SessionContext.class) != null) {
                    callContext.setCurrentOperation(Operation.INJECTION);
                    injectionProcessor.setProperty("sessionContext", data.sessionContext);
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            Object bean = injectionProcessor.createInstance();
            HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
            for (InterceptorInstance interceptorInstance : deploymentInfo.getSystemInterceptors()) {
                clazz = interceptorInstance.getData().getInterceptorClass();
                interceptorInstances.put(clazz.getName(), interceptorInstance.getInterceptor());
            }
            for (InterceptorData interceptorData : deploymentInfo.getInstanceScopedInterceptors()) {
                if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                clazz = interceptorData.getInterceptorClass();
                InjectionProcessor interceptorInjector = new InjectionProcessor(clazz, deploymentInfo.getInjections(), InjectionProcessor.unwrap(ctx));
                try {
                    Object interceptorInstance = interceptorInjector.createInstance();
                    interceptorInstances.put(clazz.getName(), interceptorInstance);
                }
                catch (ConstructionException e) {
                    throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                }
            }
            interceptorInstances.put(beanClass.getName(), bean);
            callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
            callContext.setCurrentAllowedStates(StatelessContext.getStates());
            List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(bean, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
            interceptorStack.invoke(new Object[0]);
            if (bean instanceof SessionBean) {
                callContext.setCurrentOperation(Operation.CREATE);
                callContext.setCurrentAllowedStates(StatelessContext.getStates());
                Method create = deploymentInfo.getCreateMethod();
                interceptorStack = new InterceptorStack(bean, create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                interceptorStack.invoke(new Object[0]);
            }
            instance = new Instance(bean, interceptorInstances);
            Object var17_21 = null;
            callContext.setCurrentOperation(originalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
        }
        catch (Throwable e) {
            try {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                String t = "The bean instance " + deploymentInfo.getDeploymentID() + " threw a system exception:" + e;
                logger.error(t, e);
                throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", e));
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                callContext.setCurrentOperation(originalOperation);
                callContext.setCurrentAllowedStates(originalAllowedStates);
                throw throwable;
            }
        }
        return instance;
    }

    public void poolInstance(ThreadContext callContext, Object bean) throws OpenEJBException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Pool<Instance> pool = data.getPool();
        if (instance.getPoolEntry() != null) {
            pool.push(instance.getPoolEntry());
        } else {
            pool.push(instance);
        }
    }

    public void discardInstance(ThreadContext callContext, Object bean) throws SystemException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Pool<Instance> pool = data.getPool();
        pool.discard(instance.getPoolEntry());
    }

    private void freeInstance(ThreadContext callContext, Instance instance) {
        try {
            callContext.setCurrentOperation(Operation.PRE_DESTROY);
            callContext.setCurrentAllowedStates(StatelessContext.getStates());
            CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
            Method remove = instance.bean instanceof SessionBean ? deploymentInfo.getCreateMethod() : null;
            List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            interceptorStack.invoke(new Object[0]);
        }
        catch (Throwable re) {
            logger.error("The bean instance " + instance + " threw a system exception:" + re, re);
        }
    }

    public void deploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        ObjectName objectName;
        Options options = new Options(deploymentInfo.getProperties());
        Duration accessTimeout = this.getDuration(options, "Timeout", this.accessTimeout, Duration.Unit.milliseconds);
        accessTimeout = this.getDuration(options, "AccessTimeout", accessTimeout, Duration.Unit.milliseconds);
        Duration closeTimeout = this.getDuration(options, "CloseTimeout", this.closeTimeout, Duration.Unit.minutes);
        ObjectRecipe recipe = PassthroughFactory.recipe(new Pool.Builder(this.poolBuilder));
        recipe.allow(Option.CASE_INSENSITIVE_FACTORY);
        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        recipe.setAllProperties((Map)deploymentInfo.getProperties());
        Pool.Builder builder = (Pool.Builder)recipe.create();
        this.setDefault(builder.getMaxAge(), Duration.Unit.hours);
        this.setDefault(builder.getIdleTimeout(), Duration.Unit.minutes);
        this.setDefault(builder.getInterval(), Duration.Unit.minutes);
        builder.setSupplier(new StatelessSupplier(deploymentInfo));
        builder.setExecutor(this.executor);
        Data data = new Data(builder.build(), accessTimeout, closeTimeout);
        deploymentInfo.setContainerData(data);
        try {
            Context context = deploymentInfo.getJndiEnc();
            context.bind("java:comp/EJBContext", (Object)data.sessionContext);
            context.bind("java:comp/WebServiceContext", (Object)new EjbWsContext(data.sessionContext));
        }
        catch (NamingException e) {
            throw new OpenEJBException("Failed to bind EJBContext", e);
        }
        int min = builder.getMin();
        long maxAge = builder.getMaxAge().getTime(TimeUnit.MILLISECONDS);
        double maxAgeOffset = builder.getMaxAgeOffset();
        StatsInterceptor stats = new StatsInterceptor(deploymentInfo.getBeanClass());
        deploymentInfo.addSystemInterceptor(stats);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("EJBModule", deploymentInfo.getModuleID());
        jmxName.set("StatelessSessionBean", deploymentInfo.getEjbName());
        jmxName.set("j2eeType", "");
        jmxName.set("name", deploymentInfo.getEjbName());
        try {
            objectName = jmxName.set("j2eeType", "Invocations").build();
            server.registerMBean(new ManagedMBean(stats), objectName);
            data.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        try {
            objectName = jmxName.set("j2eeType", "Pool").build();
            server.registerMBean(new ManagedMBean(data.pool), objectName);
            data.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        if (!options.get("BackgroundStartup", false)) {
            for (int i = 0; i < min; ++i) {
                Instance obj = this.createInstance(deploymentInfo);
                if (obj == null) continue;
                long offset = maxAge > 0L ? (long)((double)(maxAge / (long)min * (long)i) * maxAgeOffset) % maxAge : 0L;
                data.getPool().add(obj, offset);
            }
        }
        data.getPool().start();
    }

    private void setDefault(Duration duration, Duration.Unit unit) {
        if (duration.getUnit() == null) {
            this.convert(duration, unit);
        }
    }

    private Duration getDuration(Options options, String property, Duration defaultValue, Duration.Unit defaultUnit) {
        String s = options.get(property, defaultValue.toString());
        Duration duration = new Duration(s);
        if (duration.getUnit() == null) {
            this.convert(duration, defaultUnit);
        }
        return duration;
    }

    private void convert(Duration duration, Duration.Unit unit) {
        Duration converted = new Duration(duration.getTime() + " " + (Object)((Object)unit));
        duration.setTime(converted.getTime());
        duration.setUnit(converted.getUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Instance createInstance(CoreDeploymentInfo deploymentInfo) {
        Instance instance;
        ThreadContext ctx = new ThreadContext(deploymentInfo, null);
        ThreadContext oldCallContext = ThreadContext.enter(ctx);
        try {
            instance = this.ceateInstance(ctx);
            Object var6_6 = null;
        }
        catch (OpenEJBException e) {
            try {
                logger.error("Unable to fill pool to mimimum size: for deployment '" + deploymentInfo.getDeploymentID() + "'", e);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                ThreadContext.exit(oldCallContext);
                throw throwable;
            }
            ThreadContext.exit(oldCallContext);
            return null;
        }
        ThreadContext.exit(oldCallContext);
        return instance;
    }

    public void undeploy(CoreDeploymentInfo deploymentInfo) {
        Data data = (Data)deploymentInfo.getContainerData();
        if (data == null) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName objectName : data.jmxNames) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to unregister MBean " + objectName);
            }
        }
        try {
            if (!data.closePool()) {
                logger.error("Timed-out waiting for stateless pool to close: for deployment '" + deploymentInfo.getDeploymentID() + "'");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        deploymentInfo.setContainerData(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Data {
        private final Pool<Instance> pool;
        private final Duration accessTimeout;
        private final Duration closeTimeout;
        private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
        private final SessionContext sessionContext;

        private Data(Pool<Instance> pool, Duration accessTimeout, Duration closeTimeout) {
            this.pool = pool;
            this.accessTimeout = accessTimeout;
            this.closeTimeout = closeTimeout;
            this.sessionContext = new StatelessContext(StatelessInstanceManager.this.securityService, new Flushable(){

                public void flush() throws IOException {
                    Data.this.getPool().flush();
                }
            });
        }

        public Duration getAccessTimeout() {
            return this.accessTimeout;
        }

        public Pool.Entry poolPop() throws InterruptedException, TimeoutException {
            return this.pool.pop(this.accessTimeout.getTime(), this.accessTimeout.getUnit());
        }

        public Pool<Instance> getPool() {
            return this.pool;
        }

        public boolean closePool() throws InterruptedException {
            return this.pool.close(this.closeTimeout.getTime(), this.closeTimeout.getUnit());
        }

        public ObjectName add(ObjectName name) {
            this.jmxNames.add(name);
            return name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatelessSupplier
    implements Pool.Supplier<Instance> {
        private final CoreDeploymentInfo deploymentInfo;

        private StatelessSupplier(CoreDeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(Instance instance, Pool.Event reason) {
            ThreadContext ctx = new ThreadContext(this.deploymentInfo, null);
            ThreadContext oldCallContext = ThreadContext.enter(ctx);
            try {
                StatelessInstanceManager.this.freeInstance(ctx, instance);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ThreadContext.exit(oldCallContext);
                throw throwable;
            }
            ThreadContext.exit(oldCallContext);
        }

        @Override
        public Instance create() {
            return StatelessInstanceManager.this.createInstance(this.deploymentInfo);
        }
    }
}

